/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.part.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Tuple;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.util.IBlockStateProvider;
import xiroc.dungeoncrawl.util.IRandom;

public class WeightedRandomBlock
implements IRandom<BlockState>,
IBlockStateProvider {
    public static final Random RANDOM = new Random();
    private int totalWeight;
    private BlockRegistry.TupleFloatBlock[] blocks;

    private WeightedRandomBlock() {
    }

    public WeightedRandomBlock(Tuple<Integer, BlockState>[] entries) {
        int weight = 0;
        for (Tuple<Integer, BlockState> entry : entries) {
            weight += ((Integer)entry.func_76341_a()).intValue();
        }
        this.totalWeight = weight;
        this.blocks = new BlockRegistry.TupleFloatBlock[entries.length];
        this.assign(entries);
    }

    public static WeightedRandomBlock of(Tuple<Integer, Block>[] entries) {
        WeightedRandomBlock block = new WeightedRandomBlock();
        int baseWeight = 0;
        for (Tuple<Integer, Block> entry : entries) {
            baseWeight += ((Integer)entry.func_76341_a()).intValue();
        }
        block.totalWeight = baseWeight;
        block.blocks = new BlockRegistry.TupleFloatBlock[entries.length];
        float f = 0.0f;
        int i = 0;
        for (Tuple<Integer, Block> entry : entries) {
            float weight = (float)((Integer)entry.func_76341_a()).intValue() / (float)block.totalWeight;
            block.blocks[i] = new BlockRegistry.TupleFloatBlock(Float.valueOf(weight + f), ((Block)entry.func_76340_b()).func_176223_P());
            f += weight;
            ++i;
        }
        return block;
    }

    private void assign(Tuple<Integer, BlockState>[] values) {
        float f = 0.0f;
        int i = 0;
        for (Tuple<Integer, BlockState> entry : values) {
            float weight = (float)((Integer)entry.func_76341_a()).intValue() / (float)this.totalWeight;
            this.blocks[i] = new BlockRegistry.TupleFloatBlock(Float.valueOf(weight + f), (BlockState)entry.func_76340_b());
            f += weight;
            ++i;
        }
    }

    @Override
    public BlockState roll(Random rand) {
        float f = rand.nextFloat();
        for (BlockRegistry.TupleFloatBlock entry : this.blocks) {
            if (!(((Float)entry.func_76341_a()).floatValue() >= f)) continue;
            return (BlockState)entry.func_76340_b();
        }
        return null;
    }

    @Override
    public BlockState get() {
        return this.roll(RANDOM);
    }
}

