/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReport;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateBlockBreakPacket;
import net.minecraft.network.play.server.SBlockActionPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SSpawnGlobalEntityPacket;
import net.minecraft.network.play.server.SSpawnMovingSoundEffectPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.WanderingTraderSpawner;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapIdTracker;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeWorldServer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.WorldCapabilityData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerWorld
extends World
implements IForgeWorldServer {
    private static final Logger field_147491_a = LogManager.getLogger();
    private final List<Entity> field_217497_w = Lists.newArrayList();
    private final Int2ObjectMap<Entity> field_217498_x = new Int2ObjectLinkedOpenHashMap();
    private final Map<UUID, Entity> field_175741_N = Maps.newHashMap();
    private final Queue<Entity> field_217499_z = Queues.newArrayDeque();
    private final List<ServerPlayerEntity> field_217491_A = Lists.newArrayList();
    boolean field_217492_a;
    private final MinecraftServer field_73061_a;
    private final SaveHandler field_217493_C;
    public boolean field_73058_d;
    private boolean field_73068_P;
    private int field_80004_Q;
    private final Teleporter field_85177_Q;
    private final ServerTickList<Block> field_94579_S = new ServerTickList(this, p_205341_0_ -> p_205341_0_ == null || p_205341_0_.func_176223_P().func_196958_f(), arg_0 -> Registry.field_212618_g.func_177774_c(arg_0), arg_0 -> Registry.field_212618_g.func_82594_a(arg_0), this::func_205338_b);
    private final ServerTickList<Fluid> field_205342_P = new ServerTickList(this, p_205774_0_ -> p_205774_0_ == null || p_205774_0_ == Fluids.field_204541_a, arg_0 -> Registry.field_212619_h.func_177774_c(arg_0), arg_0 -> Registry.field_212619_h.func_82594_a(arg_0), this::func_205339_a);
    private final Set<PathNavigator> field_217495_I = Sets.newHashSet();
    protected final RaidManager field_217494_c;
    private final ObjectLinkedOpenHashSet<BlockEventData> field_147490_S = new ObjectLinkedOpenHashSet();
    private boolean field_211159_Q;
    @Nullable
    private final WanderingTraderSpawner field_217496_L;
    protected Set<ChunkPos> doneChunks = Sets.newHashSet();
    private WorldCapabilityData capabilityData;

    public ServerWorld(MinecraftServer serverIn, Executor p_i50703_2_, SaveHandler p_i50703_3_, WorldInfo p_i50703_4_, DimensionType dimType, IProfiler p_i50703_6_, IChunkStatusListener p_i50703_7_) {
        super(p_i50703_4_, dimType, (p_217442_4_, p_217442_5_) -> new ServerChunkProvider((ServerWorld)p_217442_4_, p_i50703_3_.func_75765_b(), p_i50703_3_.func_197718_i(), p_i50703_3_.func_186340_h(), p_i50703_2_, p_217442_4_.func_175624_G().createChunkGenerator((World)p_217442_4_), serverIn.func_184103_al().func_72395_o(), p_i50703_7_, () -> serverIn.func_71218_a(DimensionType.field_223227_a_).func_217481_x()), p_i50703_6_, false);
        this.field_217493_C = p_i50703_3_;
        this.field_73061_a = serverIn;
        this.field_85177_Q = new Teleporter(this);
        this.func_72966_v();
        this.func_72947_a();
        this.func_175723_af().func_177725_a(serverIn.func_175580_aG());
        this.field_217494_c = this.func_217481_x().func_215752_a(() -> new RaidManager(this), RaidManager.func_215172_a((Dimension)this.field_73011_w));
        if (!serverIn.func_71264_H()) {
            this.func_72912_H().func_76060_a(serverIn.func_71265_f());
        }
        this.field_217496_L = this.field_73011_w.func_186058_p() == DimensionType.field_223227_a_ ? new WanderingTraderSpawner(this) : null;
        this.initCapabilities();
    }

    @Override
    public Biome func_225604_a_(int x, int y, int z) {
        return this.func_72863_F().func_201711_g().func_202090_b().func_225526_b_(x, y, z);
    }

    public void func_72835_b(BooleanSupplier hasTimeLeft) {
        boolean flag3;
        IProfiler iprofiler = this.func_217381_Z();
        this.field_211159_Q = true;
        iprofiler.func_76320_a("world border");
        this.func_175723_af().func_212673_r();
        iprofiler.func_219895_b("weather");
        boolean flag = this.func_72896_J();
        this.field_73011_w.updateWeather(() -> {
            if (this.field_73011_w.func_191066_m()) {
                if (this.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                    int i = this.field_72986_A.func_176133_A();
                    int j = this.field_72986_A.func_76071_n();
                    int k = this.field_72986_A.func_76083_p();
                    boolean flag1 = this.field_72986_A.func_76061_m();
                    boolean flag2 = this.field_72986_A.func_76059_o();
                    if (i > 0) {
                        --i;
                        j = flag1 ? 0 : 1;
                        k = flag2 ? 0 : 1;
                        flag1 = false;
                        flag2 = false;
                    } else {
                        if (j > 0) {
                            if (--j == 0) {
                                flag1 = !flag1;
                            }
                        } else {
                            j = flag1 ? this.field_73012_v.nextInt(12000) + 3600 : this.field_73012_v.nextInt(168000) + 12000;
                        }
                        if (k > 0) {
                            if (--k == 0) {
                                flag2 = !flag2;
                            }
                        } else {
                            k = flag2 ? this.field_73012_v.nextInt(12000) + 12000 : this.field_73012_v.nextInt(168000) + 12000;
                        }
                    }
                    this.field_72986_A.func_76090_f(j);
                    this.field_72986_A.func_76080_g(k);
                    this.field_72986_A.func_176142_i(i);
                    this.field_72986_A.func_76069_a(flag1);
                    this.field_72986_A.func_76084_b(flag2);
                }
                this.field_73018_p = this.field_73017_q;
                this.field_73017_q = this.field_72986_A.func_76061_m() ? (float)((double)this.field_73017_q + 0.01) : (float)((double)this.field_73017_q - 0.01);
                this.field_73017_q = MathHelper.func_76131_a((float)this.field_73017_q, (float)0.0f, (float)1.0f);
                this.field_73003_n = this.field_73004_o;
                this.field_73004_o = this.field_72986_A.func_76059_o() ? (float)((double)this.field_73004_o + 0.01) : (float)((double)this.field_73004_o - 0.01);
                this.field_73004_o = MathHelper.func_76131_a((float)this.field_73004_o, (float)0.0f, (float)1.0f);
            }
        });
        if (this.field_73003_n != this.field_73004_o) {
            this.field_73061_a.func_184103_al().func_148537_a((IPacket<?>)new SChangeGameStatePacket(7, this.field_73004_o), this.field_73011_w.func_186058_p());
        }
        if (this.field_73018_p != this.field_73017_q) {
            this.field_73061_a.func_184103_al().func_148537_a((IPacket<?>)new SChangeGameStatePacket(8, this.field_73017_q), this.field_73011_w.func_186058_p());
        }
        if (flag != this.func_72896_J()) {
            if (flag) {
                this.field_73061_a.func_184103_al().func_148537_a((IPacket<?>)new SChangeGameStatePacket(2, 0.0f), this.field_73011_w.func_186058_p());
            } else {
                this.field_73061_a.func_184103_al().func_148537_a((IPacket<?>)new SChangeGameStatePacket(1, 0.0f), this.field_73011_w.func_186058_p());
            }
            this.field_73061_a.func_184103_al().func_148537_a((IPacket<?>)new SChangeGameStatePacket(7, this.field_73004_o), this.field_73011_w.func_186058_p());
            this.field_73061_a.func_184103_al().func_148537_a((IPacket<?>)new SChangeGameStatePacket(8, this.field_73017_q), this.field_73011_w.func_186058_p());
        }
        if (this.func_72912_H().func_76093_s() && this.func_175659_aa() != Difficulty.HARD) {
            this.func_72912_H().func_176144_a(Difficulty.HARD);
        }
        if (this.field_73068_P && this.field_217491_A.stream().noneMatch(p_217449_0_ -> !p_217449_0_.func_175149_v() && !p_217449_0_.func_71026_bH())) {
            this.field_73068_P = false;
            if (this.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
                long l = this.func_72820_D() + 24000L;
                this.func_72877_b(ForgeEventFactory.onSleepFinished((ServerWorld)this, (long)(l - l % 24000L), (long)this.func_72820_D()));
            }
            this.func_229856_ab_();
            if (this.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                this.func_73051_P();
            }
        }
        this.func_72966_v();
        this.func_217389_a();
        iprofiler.func_219895_b("chunkSource");
        this.func_72863_F().func_217207_a(hasTimeLeft);
        iprofiler.func_219895_b("tickPending");
        if (this.field_72986_A.func_76067_t() != WorldType.field_180272_g) {
            this.field_94579_S.func_205365_a();
            this.field_205342_P.func_205365_a();
        }
        iprofiler.func_219895_b("raid");
        this.field_217494_c.func_215171_a();
        if (this.field_217496_L != null) {
            this.field_217496_L.func_221242_a();
        }
        iprofiler.func_219895_b("blockEvents");
        this.func_147488_Z();
        this.field_211159_Q = false;
        iprofiler.func_219895_b("entities");
        boolean bl = flag3 = !this.field_217491_A.isEmpty() || !this.func_217469_z().isEmpty();
        if (flag3) {
            this.func_82742_i();
        }
        if (flag3 || this.field_80004_Q++ < 300) {
            this.field_73011_w.func_186059_r();
            iprofiler.func_76320_a("global");
            for (int i1 = 0; i1 < this.field_217497_w.size(); ++i1) {
                Entity entity = this.field_217497_w.get(i1);
                this.func_217390_a(p_229858_0_ -> {
                    ++p_229858_0_.field_70173_aa;
                    if (p_229858_0_.canUpdate()) {
                        p_229858_0_.func_70071_h_();
                    }
                }, entity);
                if (!entity.field_70128_L) continue;
                this.field_217497_w.remove(i1--);
            }
            iprofiler.func_219895_b("regular");
            this.field_217492_a = true;
            ObjectIterator objectiterator = this.field_217498_x.int2ObjectEntrySet().iterator();
            while (true) {
                if (!objectiterator.hasNext()) {
                    Entity entity1;
                    this.field_217492_a = false;
                    while ((entity1 = this.field_217499_z.poll()) != null) {
                        this.func_217465_m(entity1);
                    }
                    iprofiler.func_76319_b();
                    this.func_217391_K();
                    break;
                }
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectiterator.next();
                Entity entity2 = (Entity)((Object)entry.getValue());
                Entity entity3 = entity2.func_184187_bx();
                if (!this.field_73061_a.func_71268_U() && (entity2 instanceof AnimalEntity || entity2 instanceof WaterMobEntity)) {
                    entity2.func_70106_y();
                }
                if (!this.field_73061_a.func_71220_V() && entity2 instanceof INPC) {
                    entity2.func_70106_y();
                }
                iprofiler.func_76320_a("checkDespawn");
                if (!entity2.field_70128_L) {
                    entity2.func_70623_bb();
                }
                iprofiler.func_76319_b();
                if (entity3 != null) {
                    if (!entity3.field_70128_L && entity3.func_184196_w(entity2)) continue;
                    entity2.func_184210_p();
                }
                iprofiler.func_76320_a("tick");
                if (!entity2.field_70128_L && !(entity2 instanceof EnderDragonPartEntity)) {
                    this.func_217390_a(this::func_217479_a, entity2);
                }
                iprofiler.func_76319_b();
                iprofiler.func_76320_a("remove");
                if (entity2.field_70128_L) {
                    this.func_217454_n(entity2);
                    objectiterator.remove();
                    this.removeEntityComplete(entity2, entity2 instanceof ServerPlayerEntity);
                }
                iprofiler.func_76319_b();
            }
        }
        iprofiler.func_76319_b();
    }

    private void func_229856_ab_() {
        this.field_217491_A.stream().filter(LivingEntity::func_70608_bn).collect(Collectors.toList()).forEach(p_229857_0_ -> p_229857_0_.func_225652_a_(false, false));
    }

    public void func_217441_a(Chunk chunkIn, int randomTickSpeed) {
        BlockPos blockpos;
        ChunkPos chunkpos = chunkIn.func_76632_l();
        boolean flag = this.func_72896_J();
        int i = chunkpos.func_180334_c();
        int j = chunkpos.func_180333_d();
        IProfiler iprofiler = this.func_217381_Z();
        iprofiler.func_76320_a("thunder");
        if (this.field_73011_w.canDoLightning(chunkIn) && flag && this.func_72911_I() && this.field_73012_v.nextInt(100000) == 0 && this.func_175727_C(blockpos = this.func_175736_a(this.func_217383_a(i, 0, j, 15)))) {
            boolean flag1;
            DifficultyInstance difficultyinstance = this.func_175649_E(blockpos);
            boolean bl = flag1 = this.func_82736_K().func_223586_b(GameRules.field_223601_d) && this.field_73012_v.nextDouble() < (double)difficultyinstance.func_180168_b() * 0.01;
            if (flag1) {
                SkeletonHorseEntity skeletonhorseentity = EntityType.field_200742_ah.func_200721_a(this);
                skeletonhorseentity.func_190691_p(true);
                skeletonhorseentity.func_70873_a(0);
                skeletonhorseentity.func_70107_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
                this.func_217376_c((Entity)skeletonhorseentity);
            }
            this.func_217468_a(new LightningBoltEntity(this, (double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, flag1));
        }
        iprofiler.func_219895_b("iceandsnow");
        if (this.field_73011_w.canDoRainSnowIce(chunkIn) && this.field_73012_v.nextInt(16) == 0) {
            BlockPos blockpos2 = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_217383_a(i, 0, j, 15));
            BlockPos blockpos3 = blockpos2.func_177977_b();
            Biome biome = this.func_226691_t_(blockpos2);
            if (this.isAreaLoaded(blockpos2, 1) && biome.func_201848_a(this, blockpos3)) {
                this.func_175656_a(blockpos3, Blocks.field_150432_aD.func_176223_P());
            }
            if (flag && biome.func_201850_b(this, blockpos2)) {
                this.func_175656_a(blockpos2, Blocks.field_150433_aE.func_176223_P());
            }
            if (flag && this.func_226691_t_(blockpos3).func_201851_b() == Biome.RainType.RAIN) {
                this.func_180495_p(blockpos3).func_177230_c().func_176224_k(this, blockpos3);
            }
        }
        iprofiler.func_219895_b("tickBlocks");
        if (randomTickSpeed > 0) {
            for (ChunkSection chunksection : chunkIn.func_76587_i()) {
                if (chunksection == Chunk.field_186036_a || !chunksection.func_206915_b()) continue;
                int k = chunksection.func_222632_g();
                for (int l = 0; l < randomTickSpeed; ++l) {
                    IFluidState ifluidstate;
                    BlockPos blockpos1 = this.func_217383_a(i, k, j, 15);
                    iprofiler.func_76320_a("randomTick");
                    BlockState blockstate = chunksection.func_177485_a(blockpos1.func_177958_n() - i, blockpos1.func_177956_o() - k, blockpos1.func_177952_p() - j);
                    if (blockstate.func_204519_t()) {
                        blockstate.func_227034_b_(this, blockpos1, this.field_73012_v);
                    }
                    if ((ifluidstate = blockstate.func_204520_s()).func_206890_h()) {
                        ifluidstate.func_206891_b(this, blockpos1, this.field_73012_v);
                    }
                    iprofiler.func_76319_b();
                }
            }
        }
        iprofiler.func_76319_b();
    }

    protected BlockPos func_175736_a(BlockPos pos) {
        BlockPos blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos, new BlockPos(blockpos.func_177958_n(), this.func_217301_I(), blockpos.func_177952_p())).func_186662_g(3.0);
        List<LivingEntity> list = this.func_175647_a(LivingEntity.class, axisalignedbb, p_217463_1_ -> p_217463_1_ != null && p_217463_1_.func_70089_S() && this.func_226660_f_(p_217463_1_.func_180425_c()));
        if (!list.isEmpty()) {
            return list.get(this.field_73012_v.nextInt(list.size())).func_180425_c();
        }
        if (blockpos.func_177956_o() == -1) {
            blockpos = blockpos.func_177981_b(2);
        }
        return blockpos;
    }

    public boolean func_211158_j_() {
        return this.field_211159_Q;
    }

    public void func_72854_c() {
        this.field_73068_P = false;
        if (!this.field_217491_A.isEmpty()) {
            int i = 0;
            int j = 0;
            for (ServerPlayerEntity serverplayerentity : this.field_217491_A) {
                if (serverplayerentity.func_175149_v()) {
                    ++i;
                    continue;
                }
                if (!serverplayerentity.func_70608_bn()) continue;
                ++j;
            }
            this.field_73068_P = j > 0 && j >= this.field_217491_A.size() - i;
        }
    }

    public ServerScoreboard func_96441_U() {
        return this.field_73061_a.func_200251_aP();
    }

    private void func_73051_P() {
        this.field_73011_w.resetRainAndThunder();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_72974_f() {
        if (this.field_72986_A.func_76075_d() <= 0) {
            this.field_72986_A.func_76056_b(this.func_181545_F() + 1);
        }
        int i = this.field_72986_A.func_76079_c();
        int j = this.field_72986_A.func_76074_e();
        int k = 0;
        while (this.func_184141_c(new BlockPos(i, 0, j)).isAir((IBlockReader)((Object)this), new BlockPos(i, 0, j))) {
            i += this.field_73012_v.nextInt(8) - this.field_73012_v.nextInt(8);
            j += this.field_73012_v.nextInt(8) - this.field_73012_v.nextInt(8);
            if (++k != 10000) continue;
        }
        this.field_72986_A.func_76058_a(i);
        this.field_72986_A.func_76087_c(j);
    }

    public void func_82742_i() {
        this.field_80004_Q = 0;
    }

    private void func_205339_a(NextTickListEntry<Fluid> fluidTickEntry) {
        IFluidState ifluidstate = this.func_204610_c(fluidTickEntry.field_180282_a);
        if (ifluidstate.func_206886_c() == fluidTickEntry.func_151351_a()) {
            ifluidstate.func_206880_a(this, fluidTickEntry.field_180282_a);
        }
    }

    private void func_205338_b(NextTickListEntry<Block> blockTickEntry) {
        BlockState blockstate = this.func_180495_p(blockTickEntry.field_180282_a);
        if (blockstate.func_177230_c() == blockTickEntry.func_151351_a()) {
            blockstate.func_227033_a_(this, blockTickEntry.field_180282_a, this.field_73012_v);
        }
    }

    public void func_217479_a(Entity entityIn) {
        if (entityIn instanceof PlayerEntity || this.func_72863_F().func_217204_a(entityIn)) {
            entityIn.func_226286_f_(entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_());
            entityIn.field_70126_B = entityIn.field_70177_z;
            entityIn.field_70127_C = entityIn.field_70125_A;
            if (entityIn.field_70175_ag) {
                ++entityIn.field_70173_aa;
                IProfiler iprofiler = this.func_217381_Z();
                iprofiler.func_194340_a(() -> entityIn.func_200600_R().getRegistryName() == null ? ((Object)entityIn.func_200600_R()).toString() : entityIn.func_200600_R().getRegistryName().toString());
                if (entityIn.canUpdate()) {
                    iprofiler.func_230035_c_("tickNonPassenger");
                }
                entityIn.func_70071_h_();
                iprofiler.func_76319_b();
            }
            this.func_217464_b(entityIn);
            if (entityIn.field_70175_ag) {
                for (Entity entity : entityIn.func_184188_bt()) {
                    this.func_217459_a(entityIn, entity);
                }
            }
        }
    }

    public void func_217459_a(Entity p_217459_1_, Entity p_217459_2_) {
        if (!p_217459_2_.field_70128_L && p_217459_2_.func_184187_bx() == p_217459_1_) {
            if (p_217459_2_ instanceof PlayerEntity || this.func_72863_F().func_217204_a(p_217459_2_)) {
                p_217459_2_.func_226286_f_(p_217459_2_.func_226277_ct_(), p_217459_2_.func_226278_cu_(), p_217459_2_.func_226281_cx_());
                p_217459_2_.field_70126_B = p_217459_2_.field_70177_z;
                p_217459_2_.field_70127_C = p_217459_2_.field_70125_A;
                if (p_217459_2_.field_70175_ag) {
                    ++p_217459_2_.field_70173_aa;
                    IProfiler iprofiler = this.func_217381_Z();
                    iprofiler.func_194340_a(() -> Registry.field_212629_r.func_177774_c(p_217459_2_.func_200600_R()).toString());
                    iprofiler.func_230035_c_("tickPassenger");
                    p_217459_2_.func_70098_U();
                    iprofiler.func_76319_b();
                }
                this.func_217464_b(p_217459_2_);
                if (p_217459_2_.field_70175_ag) {
                    for (Entity entity : p_217459_2_.func_184188_bt()) {
                        this.func_217459_a(p_217459_2_, entity);
                    }
                }
            }
        } else {
            p_217459_2_.func_184210_p();
        }
    }

    public void func_217464_b(Entity entityIn) {
        this.func_217381_Z().func_76320_a("chunkCheck");
        int i = MathHelper.func_76128_c((double)(entityIn.func_226277_ct_() / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.func_226278_cu_() / 16.0));
        int k = MathHelper.func_76128_c((double)(entityIn.func_226281_cx_() / 16.0));
        if (!entityIn.field_70175_ag || entityIn.field_70176_ah != i || entityIn.field_70162_ai != j || entityIn.field_70164_aj != k) {
            if (entityIn.field_70175_ag && this.func_217354_b(entityIn.field_70176_ah, entityIn.field_70164_aj)) {
                this.func_212866_a_(entityIn.field_70176_ah, entityIn.field_70164_aj).func_76608_a(entityIn, entityIn.field_70162_ai);
            }
            if (!entityIn.func_184189_br() && !this.func_217354_b(i, k)) {
                entityIn.field_70175_ag = false;
            } else {
                this.func_212866_a_(i, k).func_76612_a(entityIn);
            }
        }
        this.func_217381_Z().func_76319_b();
    }

    @Override
    public boolean func_175660_a(PlayerEntity player, BlockPos pos) {
        return super.func_175660_a(player, pos);
    }

    @Override
    public boolean canMineBlockBody(PlayerEntity player, BlockPos pos) {
        return !this.field_73061_a.func_175579_a(this, pos, player) && this.func_175723_af().func_177746_a(pos);
    }

    public void func_73052_b(WorldSettings settings) {
        if (!this.field_73011_w.func_76567_e()) {
            this.field_72986_A.func_176143_a(BlockPos.field_177992_a.func_177981_b(this.func_72863_F().func_201711_g().func_205470_d()));
        } else if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            this.field_72986_A.func_176143_a(BlockPos.field_177992_a.func_177984_a());
        } else {
            ChunkPos chunkpos;
            if (ForgeEventFactory.onCreateWorldSpawn((World)this, (WorldSettings)settings)) {
                return;
            }
            BiomeProvider biomeprovider = this.func_72863_F().func_201711_g().func_202090_b();
            List list = biomeprovider.func_76932_a();
            Random random = new Random(this.func_72905_C());
            BlockPos blockpos = biomeprovider.func_225531_a_(0, this.func_181545_F(), 0, 256, list, random);
            ChunkPos chunkPos = chunkpos = blockpos == null ? new ChunkPos(0, 0) : new ChunkPos(blockpos);
            if (blockpos == null) {
                field_147491_a.warn("Unable to find spawn biome");
            }
            boolean flag = false;
            for (Block block : BlockTags.field_205599_H.func_199885_a()) {
                if (!biomeprovider.func_205706_b().contains((Object)block.func_176223_P())) continue;
                flag = true;
                break;
            }
            this.field_72986_A.func_176143_a(chunkpos.func_206849_h().func_177982_a(8, this.func_72863_F().func_201711_g().func_205470_d(), 8));
            int i1 = 0;
            int j1 = 0;
            int i = 0;
            int j = -1;
            int k = 32;
            for (int l = 0; l < 1024; ++l) {
                BlockPos blockpos1;
                if (i1 > -16 && i1 <= 16 && j1 > -16 && j1 <= 16 && (blockpos1 = this.field_73011_w.func_206920_a(new ChunkPos(chunkpos.field_77276_a + i1, chunkpos.field_77275_b + j1), flag)) != null) {
                    this.field_72986_A.func_176143_a(blockpos1);
                    break;
                }
                if (i1 == j1 || i1 < 0 && i1 == -j1 || i1 > 0 && i1 == 1 - j1) {
                    int k1 = i;
                    i = -j;
                    j = k1;
                }
                i1 += i;
                j1 += j;
            }
            if (settings.func_77167_c()) {
                this.func_73047_i();
            }
        }
    }

    protected void func_73047_i() {
        ConfiguredFeature configuredfeature = Feature.field_214487_aO.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        configuredfeature.func_222734_a((IWorld)this, this.func_72863_F().func_201711_g(), this.field_73012_v, new BlockPos(this.field_72986_A.func_76079_c(), this.field_72986_A.func_76075_d(), this.field_72986_A.func_76074_e()));
    }

    @Nullable
    public BlockPos func_180504_m() {
        return this.field_73011_w.func_177496_h();
    }

    public void func_217445_a(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave) throws SessionLockException {
        ServerChunkProvider serverchunkprovider = this.func_72863_F();
        if (!skipSave) {
            if (progress != null) {
                progress.func_200210_a((ITextComponent)new TranslationTextComponent("menu.savingLevel", new Object[0]));
            }
            this.func_73042_a();
            if (progress != null) {
                progress.func_200209_c((ITextComponent)new TranslationTextComponent("menu.savingChunks", new Object[0]));
            }
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Save((IWorld)this));
            serverchunkprovider.func_217210_a(flush);
        }
    }

    protected void func_73042_a() throws SessionLockException {
        this.func_217437_v();
        this.field_73011_w.func_186057_q();
        this.func_72863_F().func_217227_h().func_212775_b();
    }

    public List<Entity> func_217482_a(@Nullable EntityType<?> p_217482_1_, Predicate<? super Entity> p_217482_2_) {
        ArrayList list = Lists.newArrayList();
        ServerChunkProvider serverchunkprovider = this.func_72863_F();
        for (Entity entity : this.field_217498_x.values()) {
            if (p_217482_1_ != null && entity.func_200600_R() != p_217482_1_ || !serverchunkprovider.func_73149_a(MathHelper.func_76128_c((double)entity.func_226277_ct_()) >> 4, MathHelper.func_76128_c((double)entity.func_226281_cx_()) >> 4) || !p_217482_2_.test(entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public List<EnderDragonEntity> func_217439_j() {
        ArrayList list = Lists.newArrayList();
        for (Entity entity : this.field_217498_x.values()) {
            if (!(entity instanceof EnderDragonEntity) || !entity.func_70089_S()) continue;
            list.add((EnderDragonEntity)entity);
        }
        return list;
    }

    public List<ServerPlayerEntity> func_217490_a(Predicate<? super ServerPlayerEntity> p_217490_1_) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayerEntity serverplayerentity : this.field_217491_A) {
            if (!p_217490_1_.test(serverplayerentity)) continue;
            list.add(serverplayerentity);
        }
        return list;
    }

    @Nullable
    public ServerPlayerEntity func_217472_l_() {
        List<ServerPlayerEntity> list = this.func_217490_a(LivingEntity::func_70089_S);
        return list.isEmpty() ? null : list.get(this.field_73012_v.nextInt(list.size()));
    }

    public Object2IntMap<EntityClassification> func_217450_l() {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        ObjectIterator objectiterator = this.field_217498_x.values().iterator();
        while (objectiterator.hasNext()) {
            MobEntity mobentity;
            Entity entity = (Entity)((Object)objectiterator.next());
            if (entity instanceof MobEntity && ((mobentity = (MobEntity)entity).func_104002_bU() || mobentity.func_213392_I())) continue;
            EntityClassification entityclassification = entity.getClassification(true);
            if (entityclassification == EntityClassification.MISC || !this.func_72863_F().func_223435_b(entity)) continue;
            object2intmap.mergeInt((Object)entityclassification, 1, Integer::sum);
        }
        return object2intmap;
    }

    public boolean func_217376_c(Entity entityIn) {
        return this.func_72838_d(entityIn);
    }

    public boolean func_217470_d(Entity entityIn) {
        return this.func_72838_d(entityIn);
    }

    public void func_217460_e(Entity p_217460_1_) {
        boolean flag = p_217460_1_.field_98038_p;
        p_217460_1_.field_98038_p = true;
        this.func_217470_d(p_217460_1_);
        p_217460_1_.field_98038_p = flag;
        this.func_217464_b(p_217460_1_);
    }

    public void func_217446_a(ServerPlayerEntity p_217446_1_) {
        this.func_217448_f(p_217446_1_);
        this.func_217464_b(p_217446_1_);
    }

    public void func_217447_b(ServerPlayerEntity p_217447_1_) {
        this.func_217448_f(p_217447_1_);
        this.func_217464_b(p_217447_1_);
    }

    public void func_217435_c(ServerPlayerEntity player) {
        this.func_217448_f(player);
    }

    public void func_217433_d(ServerPlayerEntity player) {
        this.func_217448_f(player);
    }

    private void func_217448_f(ServerPlayerEntity player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent((Entity)player, (World)this))) {
            return;
        }
        Entity entity = this.field_175741_N.get(player.func_110124_au());
        if (entity != null) {
            field_147491_a.warn("Force-added player with duplicate UUID {}", (Object)player.func_110124_au().toString());
            entity.func_213319_R();
            this.func_217434_e((ServerPlayerEntity)entity);
        }
        this.field_217491_A.add(player);
        this.func_72854_c();
        IChunk ichunk = this.func_217353_a(MathHelper.func_76128_c((double)(player.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(player.func_226281_cx_() / 16.0)), ChunkStatus.field_222617_m, true);
        if (ichunk instanceof Chunk) {
            ichunk.func_76612_a(player);
        }
        this.func_217465_m(player);
    }

    private boolean func_72838_d(Entity entityIn) {
        if (entityIn.field_70128_L) {
            field_147491_a.warn("Tried to add entity {} but it was marked as removed already", (Object)EntityType.func_200718_a(entityIn.func_200600_R()));
            return false;
        }
        if (this.func_217478_l(entityIn)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entityIn, (World)this))) {
            return false;
        }
        IChunk ichunk = this.func_217353_a(MathHelper.func_76128_c((double)(entityIn.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(entityIn.func_226281_cx_() / 16.0)), ChunkStatus.field_222617_m, entityIn.field_98038_p);
        if (!(ichunk instanceof Chunk)) {
            return false;
        }
        ichunk.func_76612_a(entityIn);
        this.func_217465_m(entityIn);
        return true;
    }

    public boolean func_217440_f(Entity entityIn) {
        if (this.func_217478_l(entityIn)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entityIn, (World)this))) {
            return false;
        }
        this.func_217465_m(entityIn);
        return true;
    }

    private boolean func_217478_l(Entity entityIn) {
        Entity entity = this.field_175741_N.get(entityIn.func_110124_au());
        if (entity == null) {
            return false;
        }
        field_147491_a.warn("Keeping entity {} that already exists with UUID {}", (Object)EntityType.func_200718_a(entity.func_200600_R()), (Object)entityIn.func_110124_au().toString());
        return true;
    }

    public void func_217466_a(Chunk chunkIn) {
        this.field_147483_b.addAll(chunkIn.func_177434_r().values());
        ClassInheritanceMultiMap<Entity>[] aclassinheritancemultimap = chunkIn.func_177429_s();
        int i = aclassinheritancemultimap.length;
        for (int j = 0; j < i; ++j) {
            for (Entity entity : aclassinheritancemultimap[j]) {
                if (entity instanceof ServerPlayerEntity) continue;
                if (this.field_217492_a) {
                    throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Removing entity while ticking!"));
                }
                this.field_217498_x.remove(entity.func_145782_y());
                this.func_217484_g(entity);
            }
        }
    }

    @Deprecated
    public void func_217484_g(Entity entityIn) {
        this.removeEntityComplete(entityIn, false);
    }

    public void removeEntityComplete(Entity entityIn, boolean keepData) {
        if (entityIn instanceof EnderDragonEntity) {
            for (EnderDragonPartEntity enderdragonpartentity : ((EnderDragonEntity)entityIn).func_213404_dT()) {
                enderdragonpartentity.remove(keepData);
            }
        }
        entityIn.remove(keepData);
        this.field_175741_N.remove(entityIn.func_110124_au());
        this.func_72863_F().func_217226_b(entityIn);
        if (entityIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entityIn;
            this.field_217491_A.remove((Object)serverplayerentity);
        }
        this.func_96441_U().func_181140_a(entityIn);
        if (entityIn instanceof MobEntity) {
            this.field_217495_I.remove(((MobEntity)entityIn).func_70661_as());
        }
        entityIn.onRemovedFromWorld();
    }

    private void func_217465_m(Entity entityIn) {
        if (this.field_217492_a) {
            this.field_217499_z.add(entityIn);
        } else {
            this.field_217498_x.put(entityIn.func_145782_y(), (Object)entityIn);
            if (entityIn instanceof EnderDragonEntity) {
                for (EnderDragonPartEntity enderdragonpartentity : ((EnderDragonEntity)entityIn).func_213404_dT()) {
                    this.field_217498_x.put(enderdragonpartentity.func_145782_y(), (Object)enderdragonpartentity);
                }
            }
            this.field_175741_N.put(entityIn.func_110124_au(), entityIn);
            this.func_72863_F().func_217230_c(entityIn);
            if (entityIn instanceof MobEntity) {
                this.field_217495_I.add(((MobEntity)entityIn).func_70661_as());
            }
        }
        entityIn.onAddedToWorld();
    }

    public void func_217467_h(Entity entityIn) {
        this.removeEntity(entityIn, false);
    }

    public void removeEntity(Entity entityIn, boolean keepData) {
        if (this.field_217492_a) {
            throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Removing entity while ticking!"));
        }
        this.func_217454_n(entityIn);
        this.field_217498_x.remove(entityIn.func_145782_y());
        this.removeEntityComplete(entityIn, keepData);
    }

    private void func_217454_n(Entity entityIn) {
        IChunk ichunk = this.func_217353_a(entityIn.field_70176_ah, entityIn.field_70164_aj, ChunkStatus.field_222617_m, false);
        if (ichunk instanceof Chunk) {
            ((Chunk)ichunk).func_76622_b(entityIn);
        }
    }

    public void func_217434_e(ServerPlayerEntity player) {
        this.removePlayer(player, false);
    }

    public void removePlayer(ServerPlayerEntity player, boolean keepData) {
        player.remove(keepData);
        this.removeEntity(player, keepData);
        this.func_72854_c();
    }

    public void func_217468_a(LightningBoltEntity entityIn) {
        this.field_217497_w.add(entityIn);
        this.field_73061_a.func_184103_al().func_148543_a(null, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), 512.0, this.field_73011_w.func_186058_p(), (IPacket<?>)new SSpawnGlobalEntityPacket((Entity)entityIn));
    }

    @Override
    public void func_175715_c(int breakerId, BlockPos pos, int progress) {
        for (ServerPlayerEntity serverplayerentity : this.field_73061_a.func_184103_al().func_181057_v()) {
            double d2;
            double d1;
            double d0;
            if (serverplayerentity == null || serverplayerentity.field_70170_p != this || serverplayerentity.func_145782_y() == breakerId || !((d0 = (double)pos.func_177958_n() - serverplayerentity.func_226277_ct_()) * d0 + (d1 = (double)pos.func_177956_o() - serverplayerentity.func_226278_cu_()) * d1 + (d2 = (double)pos.func_177952_p() - serverplayerentity.func_226281_cx_()) * d2 < 1024.0)) continue;
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SAnimateBlockBreakPacket(breakerId, pos, progress));
        }
    }

    @Override
    public void func_184148_a(@Nullable PlayerEntity player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)player, (SoundEvent)soundIn, (SoundCategory)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        this.field_73061_a.func_184103_al().func_148543_a(player, x, y, z, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.field_73011_w.func_186058_p(), (IPacket<?>)new SPlaySoundEffectPacket(soundIn, category, x, y, z, volume, pitch));
    }

    @Override
    public void func_217384_a(@Nullable PlayerEntity playerIn, Entity entityIn, SoundEvent eventIn, SoundCategory categoryIn, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)playerIn, (SoundEvent)eventIn, (SoundCategory)categoryIn, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        eventIn = event.getSound();
        categoryIn = event.getCategory();
        volume = event.getVolume();
        this.field_73061_a.func_184103_al().func_148543_a(playerIn, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.field_73011_w.func_186058_p(), (IPacket<?>)new SSpawnMovingSoundEffectPacket(eventIn, categoryIn, entityIn, volume, pitch));
    }

    @Override
    public void func_175669_a(int id, BlockPos pos, int data) {
        this.field_73061_a.func_184103_al().func_148540_a((IPacket<?>)new SPlaySoundEventPacket(id, pos, data, true));
    }

    @Override
    public void func_217378_a(@Nullable PlayerEntity player, int type, BlockPos pos, int data) {
        this.field_73061_a.func_184103_al().func_148543_a(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 64.0, this.field_73011_w.func_186058_p(), (IPacket<?>)new SPlaySoundEventPacket(type, pos, data, false));
    }

    @Override
    public void func_184138_a(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        this.func_72863_F().func_217217_a(pos);
        VoxelShape voxelshape = oldState.func_196952_d((IBlockReader)((Object)this), pos);
        VoxelShape voxelshape1 = newState.func_196952_d((IBlockReader)((Object)this), pos);
        if (VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (IBooleanFunction)IBooleanFunction.field_223236_g_)) {
            for (PathNavigator pathnavigator : this.field_217495_I) {
                if (pathnavigator.func_188553_i()) continue;
                pathnavigator.func_220970_c(pos);
            }
        }
    }

    @Override
    public void func_72960_a(Entity entityIn, byte state) {
        this.func_72863_F().func_217216_a(entityIn, (IPacket)new SEntityStatusPacket(entityIn, state));
    }

    public ServerChunkProvider func_72863_F() {
        return (ServerChunkProvider)super.func_72863_F();
    }

    @Override
    public Explosion func_217401_a(@Nullable Entity entityIn, @Nullable DamageSource damageSourceIn, double xIn, double yIn, double zIn, float explosionRadius, boolean causesFire, Explosion.Mode modeIn) {
        Explosion explosion = new Explosion(this, entityIn, xIn, yIn, zIn, explosionRadius, causesFire, modeIn);
        if (ForgeEventFactory.onExplosionStart((World)this, (Explosion)explosion)) {
            return explosion;
        }
        if (damageSourceIn != null) {
            explosion.func_199592_a(damageSourceIn);
        }
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (modeIn == Explosion.Mode.NONE) {
            explosion.func_180342_d();
        }
        for (ServerPlayerEntity serverplayerentity : this.field_217491_A) {
            if (!(serverplayerentity.func_70092_e(xIn, yIn, zIn) < 4096.0)) continue;
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SExplosionPacket(xIn, yIn, zIn, explosionRadius, explosion.func_180343_e(), explosion.func_77277_b().get((Object)serverplayerentity)));
        }
        return explosion;
    }

    @Override
    public void func_175641_c(BlockPos pos, Block blockIn, int eventID, int eventParam) {
        this.field_147490_S.add((Object)new BlockEventData(pos, blockIn, eventID, eventParam));
    }

    private void func_147488_Z() {
        while (!this.field_147490_S.isEmpty()) {
            BlockEventData blockeventdata = (BlockEventData)this.field_147490_S.removeFirst();
            if (!this.func_147485_a(blockeventdata)) continue;
            this.field_73061_a.func_184103_al().func_148543_a(null, blockeventdata.func_180328_a().func_177958_n(), blockeventdata.func_180328_a().func_177956_o(), blockeventdata.func_180328_a().func_177952_p(), 64.0, this.field_73011_w.func_186058_p(), (IPacket<?>)new SBlockActionPacket(blockeventdata.func_180328_a(), blockeventdata.func_151337_f(), blockeventdata.func_151339_d(), blockeventdata.func_151338_e()));
        }
    }

    private boolean func_147485_a(BlockEventData event) {
        BlockState blockstate = this.func_180495_p(event.func_180328_a());
        return blockstate.func_177230_c() == event.func_151337_f() ? blockstate.func_189547_a(this, event.func_180328_a(), event.func_151339_d(), event.func_151338_e()) : false;
    }

    public ServerTickList<Block> func_205220_G_() {
        return this.field_94579_S;
    }

    public ServerTickList<Fluid> func_205219_F_() {
        return this.field_205342_P;
    }

    @Override
    @Nonnull
    public MinecraftServer func_73046_m() {
        return this.field_73061_a;
    }

    public Teleporter func_85176_s() {
        return this.field_85177_Q;
    }

    public TemplateManager func_184163_y() {
        return this.field_217493_C.func_186340_h();
    }

    public <T extends IParticleData> int func_195598_a(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        SSpawnParticlePacket sspawnparticlepacket = new SSpawnParticlePacket(type, false, posX, posY, posZ, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
        int i = 0;
        for (int j = 0; j < this.field_217491_A.size(); ++j) {
            ServerPlayerEntity serverplayerentity = this.field_217491_A.get(j);
            if (!this.func_195601_a(serverplayerentity, false, posX, posY, posZ, (IPacket<?>)sspawnparticlepacket)) continue;
            ++i;
        }
        return i;
    }

    public <T extends IParticleData> boolean func_195600_a(ServerPlayerEntity player, T type, boolean longDistance, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        SSpawnParticlePacket ipacket = new SSpawnParticlePacket(type, longDistance, posX, posY, posZ, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
        return this.func_195601_a(player, longDistance, posX, posY, posZ, (IPacket<?>)ipacket);
    }

    private boolean func_195601_a(ServerPlayerEntity player, boolean longDistance, double posX, double posY, double posZ, IPacket<?> packet) {
        if (player.func_71121_q() != this) {
            return false;
        }
        BlockPos blockpos = player.func_180425_c();
        if (blockpos.func_218137_a((IPosition)new Vec3d(posX, posY, posZ), longDistance ? 512.0 : 32.0)) {
            player.field_71135_a.func_147359_a(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity func_73045_a(int id) {
        return (Entity)((Object)this.field_217498_x.get(id));
    }

    @Nullable
    public Entity func_217461_a(UUID p_217461_1_) {
        return this.field_175741_N.get(p_217461_1_);
    }

    @Nullable
    public BlockPos func_211157_a(String name, BlockPos pos, int radius, boolean p_211157_4_) {
        return this.func_72863_F().func_201711_g().func_211403_a(this, name, pos, radius, p_211157_4_);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73061_a.func_199529_aN();
    }

    @Override
    public NetworkTagManager func_205772_D() {
        return this.field_73061_a.func_199731_aO();
    }

    @Override
    public void func_82738_a(long worldTime) {
        super.func_82738_a(worldTime);
        this.field_72986_A.func_215763_z().func_216331_a((Object)this.field_73061_a, worldTime);
    }

    @Override
    public boolean func_217402_u() {
        return this.field_73058_d;
    }

    public void func_217437_v() throws SessionLockException {
        this.field_217493_C.func_75762_c();
    }

    public SaveHandler func_217485_w() {
        return this.field_217493_C;
    }

    public DimensionSavedDataManager func_217481_x() {
        return this.func_72863_F().func_217227_h();
    }

    @Override
    @Nullable
    public MapData func_217406_a(String mapName) {
        return this.func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215753_b(() -> new MapData(mapName), mapName);
    }

    @Override
    public void func_217399_a(MapData mapDataIn) {
        this.func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215757_a(mapDataIn);
    }

    @Override
    public int func_217395_y() {
        return this.func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215752_a(MapIdTracker::new, "idcounts").func_215162_a();
    }

    @Override
    public void func_175652_B(BlockPos pos) {
        ChunkPos chunkpos = new ChunkPos(new BlockPos(this.field_72986_A.func_76079_c(), 0, this.field_72986_A.func_76074_e()));
        super.func_175652_B(pos);
        this.func_72863_F().func_217222_b(TicketType.field_219488_a, chunkpos, 11, (Object)Unit.INSTANCE);
        this.func_72863_F().func_217228_a(TicketType.field_219488_a, new ChunkPos(pos), 11, (Object)Unit.INSTANCE);
    }

    public LongSet func_217469_z() {
        ForcedChunksSaveData forcedchunkssavedata = this.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
        return forcedchunkssavedata != null ? LongSets.unmodifiable((LongSet)forcedchunkssavedata.func_212438_a()) : LongSets.EMPTY_SET;
    }

    public boolean func_217458_b(int chunkX, int chunkZ, boolean add) {
        boolean flag;
        ForcedChunksSaveData forcedchunkssavedata = this.func_217481_x().func_215752_a(ForcedChunksSaveData::new, "chunks");
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        long i = chunkpos.func_201841_a();
        if (add) {
            flag = forcedchunkssavedata.func_212438_a().add(i);
            if (flag) {
                this.func_212866_a_(chunkX, chunkZ);
            }
        } else {
            flag = forcedchunkssavedata.func_212438_a().remove(i);
        }
        forcedchunkssavedata.func_76186_a(flag);
        if (flag) {
            this.func_72863_F().func_217206_a(chunkpos, add);
        }
        return flag;
    }

    public List<ServerPlayerEntity> func_217369_A() {
        return this.field_217491_A;
    }

    @Override
    public void func_217393_a(BlockPos p_217393_1_, BlockState p_217393_2_, BlockState p_217393_3_) {
        Optional<PointOfInterestType> optional1;
        Optional<PointOfInterestType> optional = PointOfInterestType.func_221047_b(p_217393_2_);
        if (!Objects.equals(optional, optional1 = PointOfInterestType.func_221047_b(p_217393_3_))) {
            BlockPos blockpos = p_217393_1_.func_185334_h();
            optional.ifPresent(p_217476_2_ -> this.func_73046_m().execute(() -> {
                this.func_217443_B().func_219140_a(blockpos);
                DebugPacketSender.func_218805_b((ServerWorld)this, (BlockPos)blockpos);
            }));
            optional1.ifPresent(p_217457_2_ -> this.func_73046_m().execute(() -> {
                this.func_217443_B().func_219135_a(blockpos, p_217457_2_);
                DebugPacketSender.func_218799_a((ServerWorld)this, (BlockPos)blockpos);
            }));
        }
    }

    public PointOfInterestManager func_217443_B() {
        return this.func_72863_F().func_217231_i();
    }

    public boolean func_217483_b_(BlockPos p_217483_1_) {
        return this.func_217471_a(p_217483_1_, 1);
    }

    public boolean func_222887_a(SectionPos p_222887_1_) {
        return this.func_217483_b_(p_222887_1_.func_218160_t());
    }

    public boolean func_217471_a(BlockPos p_217471_1_, int p_217471_2_) {
        if (p_217471_2_ > 6) {
            return false;
        }
        return this.func_217486_a(SectionPos.func_218167_a((BlockPos)p_217471_1_)) <= p_217471_2_;
    }

    public int func_217486_a(SectionPos p_217486_1_) {
        return this.func_217443_B().func_219150_a(p_217486_1_);
    }

    public RaidManager func_217452_C() {
        return this.field_217494_c;
    }

    @Nullable
    public Raid func_217475_c_(BlockPos pos) {
        return this.field_217494_c.func_215174_a(pos, 9216);
    }

    public boolean func_217455_d_(BlockPos pos) {
        return this.func_217475_c_(pos) != null;
    }

    public void func_217489_a(IReputationType type, Entity target, IReputationTracking host) {
        host.func_213739_a(type, target);
    }

    public void func_225322_a(Path p_225322_1_) throws IOException {
        Object entry2;
        ChunkManager chunkmanager = this.func_72863_F().field_217237_a;
        try (BufferedWriter writer = Files.newBufferedWriter(p_225322_1_.resolve("stats.txt"), new OpenOption[0]);){
            writer.write(String.format("spawning_chunks: %d\n", chunkmanager.func_219246_e().func_219358_b()));
            for (Object entry2 : this.func_217450_l().object2IntEntrySet()) {
                writer.write(String.format("spawn_count.%s: %d\n", ((EntityClassification)((Object)entry2.getKey())).func_220363_a(), entry2.getIntValue()));
            }
            writer.write(String.format("entities: %d\n", this.field_217498_x.size()));
            writer.write(String.format("block_entities: %d\n", this.field_147482_g.size()));
            writer.write(String.format("block_ticks: %d\n", this.func_205220_G_().func_225420_a()));
            writer.write(String.format("fluid_ticks: %d\n", this.func_205219_F_().func_225420_a()));
            writer.write("distance_manager: " + chunkmanager.func_219246_e().func_225412_c() + "\n");
            writer.write(String.format("pending_tasks: %d\n", this.func_72863_F().func_225314_f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.func_72914_a(crashreport);
        BufferedWriter writer1 = Files.newBufferedWriter(p_225322_1_.resolve("example_crash.txt"), new OpenOption[0]);
        Object object = null;
        try {
            writer1.write(crashreport.func_71502_e());
        }
        catch (Throwable entry2) {
            object = entry2;
            throw entry2;
        }
        finally {
            if (writer1 != null) {
                if (object != null) {
                    try {
                        ((Writer)writer1).close();
                    }
                    catch (Throwable entry2) {
                        ((Throwable)object).addSuppressed(entry2);
                    }
                } else {
                    ((Writer)writer1).close();
                }
            }
        }
        Path path = p_225322_1_.resolve("chunks.csv");
        BufferedWriter writer2 = Files.newBufferedWriter(path, new OpenOption[0]);
        entry2 = null;
        try {
            chunkmanager.func_225406_a(writer2);
        }
        catch (Throwable throwable) {
            entry2 = throwable;
            throw throwable;
        }
        finally {
            if (writer2 != null) {
                if (entry2 != null) {
                    try {
                        ((Writer)writer2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)entry2).addSuppressed(throwable);
                    }
                } else {
                    ((Writer)writer2).close();
                }
            }
        }
        Path path1 = p_225322_1_.resolve("entities.csv");
        try (BufferedWriter writer3 = Files.newBufferedWriter(path1, new OpenOption[0]);){
            ServerWorld.func_225320_a(writer3, (Iterable<Entity>)this.field_217498_x.values());
        }
        Path path2 = p_225322_1_.resolve("global_entities.csv");
        try (BufferedWriter writer4 = Files.newBufferedWriter(path2, new OpenOption[0]);){
            ServerWorld.func_225320_a(writer4, this.field_217497_w);
        }
        Path path3 = p_225322_1_.resolve("block_entities.csv");
        try (BufferedWriter writer5 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            this.func_225321_a(writer5);
        }
    }

    private static void func_225320_a(Writer p_225320_0_, Iterable<Entity> p_225320_1_) throws IOException {
        CSVWriter csvwriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("y").func_225423_a("z").func_225423_a("uuid").func_225423_a("type").func_225423_a("alive").func_225423_a("display_name").func_225423_a("custom_name").func_225422_a(p_225320_0_);
        for (Entity entity : p_225320_1_) {
            ITextComponent itextcomponent = entity.func_200201_e();
            ITextComponent itextcomponent1 = entity.func_145748_c_();
            csvwriter.func_225426_a(new Object[]{entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_110124_au(), Registry.field_212629_r.func_177774_c(entity.func_200600_R()), entity.func_70089_S(), itextcomponent1.getString(), itextcomponent != null ? itextcomponent.getString() : null});
        }
    }

    private void func_225321_a(Writer p_225321_1_) throws IOException {
        CSVWriter csvwriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("y").func_225423_a("z").func_225423_a("type").func_225422_a(p_225321_1_);
        for (TileEntity tileentity : this.field_147482_g) {
            BlockPos blockpos = tileentity.func_174877_v();
            csvwriter.func_225426_a(new Object[]{blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p(), Registry.field_212626_o.func_177774_c(tileentity.func_200662_C())});
        }
    }

    @VisibleForTesting
    public void func_229854_a_(MutableBoundingBox p_229854_1_) {
        this.field_147490_S.removeIf(p_229855_1_ -> p_229854_1_.func_175898_b((Vec3i)p_229855_1_.func_180328_a()));
    }

    protected void initCapabilities() {
        ICapabilityProvider parent = this.field_73011_w.initCapabilities();
        this.gatherCapabilities(parent);
        this.capabilityData = this.func_217481_x().func_215752_a(() -> new WorldCapabilityData((INBTSerializable)this.getCapabilities()), "capabilities");
        this.capabilityData.setCapabilities(this.field_73011_w, (INBTSerializable)this.getCapabilities());
    }

    public Stream<Entity> getEntities() {
        return this.field_217498_x.values().stream();
    }
}

