/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class Explosion {
    private final boolean field_77286_a;
    private final Mode field_222260_b;
    private final Random field_77290_i = new Random();
    private final World field_77287_j;
    private final double field_77284_b;
    private final double field_77285_c;
    private final double field_77282_d;
    @Nullable
    private final Entity field_77283_e;
    private final float field_77280_f;
    private DamageSource field_199593_j;
    private final List<BlockPos> field_77281_g = Lists.newArrayList();
    private final Map<PlayerEntity, Vec3d> field_77288_k = Maps.newHashMap();
    private final Vec3d position;

    @OnlyIn(value=Dist.CLIENT)
    public Explosion(World worldIn, @Nullable Entity entityIn, double x, double y, double z, float size, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, size, false, Mode.DESTROY, affectedPositions);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Explosion(World worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Mode modeIn, List<BlockPos> affectedBlockPositionsIn) {
        this(worldIn, exploderIn, xIn, yIn, zIn, sizeIn, causesFireIn, modeIn);
        this.field_77281_g.addAll(affectedBlockPositionsIn);
    }

    public Explosion(World worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Mode modeIn) {
        this.field_77287_j = worldIn;
        this.field_77283_e = exploderIn;
        this.field_77280_f = sizeIn;
        this.field_77284_b = xIn;
        this.field_77285_c = yIn;
        this.field_77282_d = zIn;
        this.field_77286_a = causesFireIn;
        this.field_222260_b = modeIn;
        this.field_199593_j = DamageSource.func_94539_a((Explosion)this);
        this.position = new Vec3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
    }

    public static float func_222259_a(Vec3d p_222259_0_, Entity p_222259_1_) {
        AxisAlignedBB axisalignedbb = p_222259_1_.func_174813_aQ();
        double d0 = 1.0 / ((axisalignedbb.field_72336_d - axisalignedbb.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.field_72337_e - axisalignedbb.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.field_72334_f - axisalignedbb.field_72339_c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d7;
                        double d6;
                        double d5 = MathHelper.func_219803_d((double)f, (double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72336_d);
                        Vec3d vec3d = new Vec3d(d5 + d3, d6 = MathHelper.func_219803_d((double)f1, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72337_e), (d7 = MathHelper.func_219803_d((double)f2, (double)axisalignedbb.field_72339_c, (double)axisalignedbb.field_72334_f)) + d4);
                        if (p_222259_1_.field_70170_p.func_217299_a(new RayTraceContext(vec3d, p_222259_0_, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, p_222259_1_)).func_216346_c() == RayTraceResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.field_77284_b;
                    double d6 = this.field_77285_c;
                    double d8 = this.field_77282_d;
                    float f1 = 0.3f;
                    for (float f = this.field_77280_f * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = this.field_77287_j.func_180495_p(blockpos);
                        IFluidState ifluidstate = this.field_77287_j.func_204610_c(blockpos);
                        if (!blockstate.isAir((IBlockReader)((Object)this.field_77287_j), blockpos) || !ifluidstate.func_206888_e()) {
                            float f2 = Math.max(blockstate.getExplosionResistance(this.field_77287_j, blockpos, this.field_77283_e, this), ifluidstate.getExplosionResistance(this.field_77287_j, blockpos, this.field_77283_e, this));
                            if (this.field_77283_e != null) {
                                f2 = this.field_77283_e.func_180428_a(this, (IBlockReader)((Object)this.field_77287_j), blockpos, blockstate, ifluidstate, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_174816_a(this, (IBlockReader)((Object)this.field_77287_j), blockpos, blockstate, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.field_77281_g.addAll(set);
        float f3 = this.field_77280_f * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.field_77284_b - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.field_77284_b + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.field_77285_c - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.field_77285_c + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.field_77282_d - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.field_77282_d + (double)f3 + 1.0));
        List list = this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.field_77287_j, (Explosion)this, (List)list, (double)f3);
        Vec3d vec3d = new Vec3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            PlayerEntity playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)((Object)list.get(k2));
            if (entity.func_180427_aV() || !((d12 = (double)(MathHelper.func_76133_a((double)entity.func_195048_a(vec3d)) / f3)) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.func_226277_ct_() - this.field_77284_b) * d5 + (d7 = entity.func_226280_cw_() - this.field_77285_c) * d7 + (d9 = entity.func_226281_cx_() - this.field_77282_d) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = Explosion.func_222259_a(vec3d, entity);
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(this.func_199591_b(), (int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof PlayerEntity) || (playerentity = (PlayerEntity)entity).func_175149_v() || playerentity.func_184812_l_() && playerentity.field_71075_bZ.field_75100_b) continue;
            this.field_77288_k.put(playerentity, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        boolean flag;
        if (this.field_77287_j.field_72995_K) {
            this.field_77287_j.func_184134_a(this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.field_222260_b != Mode.NONE;
        if (spawnParticles) {
            if (!(this.field_77280_f < 2.0f) && flag) {
                this.field_77287_j.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
            } else {
                this.field_77287_j.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.field_77281_g, this.field_77287_j.field_73012_v);
            for (BlockPos blockpos : this.field_77281_g) {
                BlockState blockstate = this.field_77287_j.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (blockstate.isAir((IBlockReader)((Object)this.field_77287_j), blockpos)) continue;
                BlockPos blockpos1 = blockpos.func_185334_h();
                this.field_77287_j.func_217381_Z().func_76320_a("explosion_blocks");
                if (blockstate.canDropFromExplosion((IBlockReader)((Object)this.field_77287_j), blockpos, this) && this.field_77287_j instanceof ServerWorld) {
                    TileEntity tileentity = blockstate.hasTileEntity() ? this.field_77287_j.func_175625_s(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_77287_j).func_216023_a(this.field_77287_j.field_73012_v).func_216015_a(LootParameters.field_216286_f, blockpos).func_216015_a(LootParameters.field_216289_i, ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, tileentity).func_216021_b(LootParameters.field_216281_a, this.field_77283_e);
                    if (this.field_222260_b == Mode.DESTROY) {
                        lootcontext$builder.func_216015_a(LootParameters.field_216290_j, Float.valueOf(this.field_77280_f));
                    }
                    blockstate.func_215693_a(lootcontext$builder).forEach(p_229977_2_ -> Explosion.func_229976_a_((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_229977_2_, blockpos1));
                }
                blockstate.onBlockExploded(this.field_77287_j, blockpos, this);
                this.field_77287_j.func_217381_Z().func_76319_b();
            }
            for (Pair pair : objectarraylist) {
                Block.func_180635_a(this.field_77287_j, (BlockPos)pair.getSecond(), (ItemStack)((Object)pair.getFirst()));
            }
        }
        if (this.field_77286_a) {
            for (BlockPos blockpos2 : this.field_77281_g) {
                if (this.field_77290_i.nextInt(3) != 0 || !this.field_77287_j.func_180495_p(blockpos2).func_196958_f() || !this.field_77287_j.func_180495_p(blockpos2.func_177977_b()).func_200015_d((IBlockReader)((Object)this.field_77287_j), blockpos2.func_177977_b())) continue;
                this.field_77287_j.func_175656_a(blockpos2, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    private static void func_229976_a_(ObjectArrayList<Pair<ItemStack, BlockPos>> p_229976_0_, ItemStack p_229976_1_, BlockPos p_229976_2_) {
        int i = p_229976_0_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_229976_0_.get(j);
            ItemStack itemstack = (ItemStack)((Object)pair.getFirst());
            if (!ItemEntity.func_226532_a_(itemstack, p_229976_1_)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_(itemstack, p_229976_1_, 16);
            p_229976_0_.set(j, (Object)Pair.of((Object)((Object)itemstack1), (Object)pair.getSecond()));
            if (!p_229976_1_.func_190926_b()) continue;
            return;
        }
        p_229976_0_.add((Object)Pair.of((Object)((Object)p_229976_1_), (Object)p_229976_2_));
    }

    public DamageSource func_199591_b() {
        return this.field_199593_j;
    }

    public void func_199592_a(DamageSource damageSourceIn) {
        this.field_199593_j = damageSourceIn;
    }

    public Map<PlayerEntity, Vec3d> func_77277_b() {
        return this.field_77288_k;
    }

    @Nullable
    public LivingEntity func_94613_c() {
        if (this.field_77283_e == null) {
            return null;
        }
        if (this.field_77283_e instanceof TNTEntity) {
            return ((TNTEntity)this.field_77283_e).func_94083_c();
        }
        if (this.field_77283_e instanceof LivingEntity) {
            return (LivingEntity)this.field_77283_e;
        }
        return this.field_77283_e instanceof DamagingProjectileEntity ? ((DamagingProjectileEntity)this.field_77283_e).field_70235_a : null;
    }

    public void func_180342_d() {
        this.field_77281_g.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.field_77281_g;
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public static enum Mode {
        NONE,
        BREAK,
        DESTROY;

    }
}

