/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.recipes;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class SmokingRecipeSupplier
implements Supplier<SmokingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final Object output;
    public final int count;
    public final float experience;
    public final int time;

    public SmokingRecipeSupplier(ResourceLocation key, Object input, Object output, int count, float experience, int time) {
        this(key, "", input, output, count, experience, time);
    }

    public SmokingRecipeSupplier(ResourceLocation key, String group, Object input, Object output, int count, float experience, int time) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.output = output;
        this.count = count;
        this.experience = experience;
        this.time = time;
    }

    @Override
    public SmokingRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        return new SmokingRecipe(this.key, this.group, ing, stack, this.experience, this.time);
    }
}

