/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.fluids.JAOPCAFluidHandlerItem;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABucketItem
extends Item
implements IMaterialFormBucketItem {
    private final IMaterialFormFluid fluid;
    private final IFluidFormSettings settings;
    private OptionalInt itemStackLimit = OptionalInt.empty();
    private Optional<Boolean> beaconPayment = Optional.empty();
    private Optional<Boolean> hasEffect = Optional.empty();
    private Optional<Rarity> rarity = Optional.empty();
    private OptionalInt burnTime = OptionalInt.empty();

    public JAOPCABucketItem(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(new Item.Properties().func_200919_a(Items.field_151133_ar).func_200916_a(ItemFormType.getItemGroup()));
        this.fluid = fluid;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    public int getItemStackLimit(ItemStack stack) {
        if (!this.itemStackLimit.isPresent()) {
            this.itemStackLimit = OptionalInt.of(this.settings.getItemStackLimitFunction().applyAsInt(this.getMaterial()));
        }
        return this.itemStackLimit.getAsInt();
    }

    public boolean isBeaconPayment(ItemStack stack) {
        if (!this.beaconPayment.isPresent()) {
            this.beaconPayment = Optional.of(this.settings.getIsBeaconPaymentFunction().test(this.getMaterial()));
        }
        return this.beaconPayment.get();
    }

    public boolean func_77636_d(ItemStack stack) {
        if (!this.hasEffect.isPresent()) {
            this.hasEffect = Optional.of(this.settings.getHasEffectFunction().test(this.getMaterial()));
        }
        return this.hasEffect.get() != false || super.func_77636_d(stack);
    }

    public Rarity func_77613_e(ItemStack stack) {
        if (!this.rarity.isPresent()) {
            this.rarity = Optional.of(this.settings.getDisplayRarityFunction().apply(this.getMaterial()));
        }
        return this.rarity.get();
    }

    public int getBurnTime(ItemStack itemStack) {
        if (!this.burnTime.isPresent()) {
            this.burnTime = OptionalInt.of(this.settings.getBurnTimeFunction().applyAsInt(this.getMaterial()));
        }
        return this.burnTime.getAsInt();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        RayTraceResult rayTraceResult;
        ItemStack stack = player.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)player, (World)world, (ItemStack)stack, (RayTraceResult)(rayTraceResult = JAOPCABucketItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE)));
        if (ret != null) {
            return ret;
        }
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        BlockPos resultPos = blockRayTraceResult.func_216350_a();
        if (world.func_175660_a(player, resultPos) && player.func_175151_a(resultPos, blockRayTraceResult.func_216354_b(), stack)) {
            BlockPos pos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
            if (this.tryPlaceContainedLiquid(player, world, pos, blockRayTraceResult)) {
                this.onLiquidPlaced(world, stack, pos);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return new ActionResult(ActionResultType.SUCCESS, (Object)this.emptyBucket(stack, player));
            }
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    protected ItemStack emptyBucket(ItemStack stack, PlayerEntity player) {
        return !player.field_71075_bZ.field_75098_d ? new ItemStack((IItemProvider)Items.field_151133_ar) : stack;
    }

    public void onLiquidPlaced(World world, ItemStack stack, BlockPos pos) {
    }

    public boolean tryPlaceContainedLiquid(PlayerEntity player, World world, BlockPos pos, BlockRayTraceResult rayTraceResult) {
        BlockState blockState = world.func_180495_p(pos);
        Material blockMaterial = blockState.func_185904_a();
        boolean flag = !blockMaterial.func_76220_a();
        boolean flag1 = blockMaterial.func_76222_j();
        if (world.func_175623_d(pos) || flag || flag1) {
            FluidStack stack = new FluidStack(this.fluid.asFluid(), 1000);
            if (world.field_73011_w.func_177500_n() && this.fluid.asFluid().func_207185_a(FluidTags.field_206959_a)) {
                int i = pos.func_177958_n();
                int j = pos.func_177956_o();
                int k = pos.func_177952_p();
                world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    world.func_195589_b((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else {
                if (!world.field_72995_K && (flag || flag1) && !blockMaterial.func_76224_d()) {
                    world.func_175655_b(pos, true);
                }
                this.playEmptySound(player, (IWorld)world, pos);
                world.func_180501_a(pos, this.fluid.asFluid().getAttributes().getStateForPlacement((ILightReader)world, pos, stack).func_206883_i(), 11);
            }
            return true;
        }
        return rayTraceResult == null ? false : this.tryPlaceContainedLiquid(player, world, rayTraceResult.func_216350_a().func_177972_a(rayTraceResult.func_216354_b()), null);
    }

    protected void playEmptySound(PlayerEntity player, IWorld world, BlockPos pos) {
        SoundEvent soundEvent = this.fluid.asFluid().getAttributes().getEmptySound();
        if (soundEvent == null) {
            soundEvent = this.fluid.asFluid().func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        world.func_184133_a(player, pos, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new JAOPCAFluidHandlerItem(this.fluid, stack);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("item.jaopca." + this.getForm().getName(), this.getMaterial(), this.func_77658_a());
    }
}

