/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.client.render.tileentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Calendar;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.client.render.tileentity.RenderTileEntityChestBase;
import org.cyclops.colossalchests.tileentity.TileColossalChest;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class RenderTileEntityColossalChest
extends RenderTileEntityChestBase<TileColossalChest> {
    public static final Map<ChestMaterial, ResourceLocation> TEXTURES_CHEST = Maps.newHashMap();
    public static final Map<ChestMaterial, ResourceLocation> TEXTURES_INTERFACE = Maps.newHashMap();

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            for (ResourceLocation value : TEXTURES_CHEST.values()) {
                event.addSprite(value);
            }
            for (ResourceLocation value : TEXTURES_INTERFACE.values()) {
                event.addSprite(value);
            }
        }
    }

    public RenderTileEntityColossalChest(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super(tileEntityRendererDispatcher);
    }

    @Override
    protected void handleRotation(TileColossalChest tile, MatrixStack matrixStack) {
        if (tile.isStructureComplete()) {
            Vec3d renderOffset = tile.getRenderOffset();
            matrixStack.func_227861_a_(-renderOffset.field_72450_a, -renderOffset.field_72448_b, -renderOffset.field_72449_c);
        }
        super.handleRotation(tile, matrixStack);
        matrixStack.func_227861_a_(0.0, (double)((float)tile.getSizeSingular() * 0.0625f), 0.0);
        float size = (float)tile.getSizeSingular() * 1.125f;
        matrixStack.func_227862_a_(size, size, size);
    }

    public void render(TileColossalChest tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (tile.isStructureComplete()) {
            matrixStack.func_227860_a_();
            super.func_225616_a_(tile, partialTicks, matrixStack, renderTypeBuffer, combinedLightIn, combinedOverlayIn);
            if (tile.isStructureComplete() && tile.lidAngle == 0.0f && (GeneralConfig.alwaysShowInterfaceOverlay || Minecraft.func_71410_x().field_71439_g.func_213453_ef())) {
                matrixStack.func_227860_a_();
                Material materialInterface = this.getMaterialInterface(tile);
                IVertexBuilder buffer = materialInterface.func_229311_a_(renderTypeBuffer, RenderType::func_228658_l_);
                for (Vec3i interfaceLocation : tile.getInterfaceLocations()) {
                    float translateX = interfaceLocation.func_177958_n() - tile.func_174877_v().func_177958_n();
                    float translateY = interfaceLocation.func_177956_o() - tile.func_174877_v().func_177956_o();
                    float translateZ = interfaceLocation.func_177952_p() - tile.func_174877_v().func_177952_p();
                    matrixStack.func_227861_a_((double)translateX, (double)translateY, (double)translateZ);
                    this.renderInterface(matrixStack, buffer, materialInterface.func_229314_c_(), interfaceLocation.equals((Object)tile.func_174877_v()), combinedLightIn);
                    matrixStack.func_227861_a_((double)(-translateX), (double)(-translateY), (double)(-translateZ));
                }
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227865_b_();
        }
    }

    public boolean isGlobalRenderer(TileColossalChest tile) {
        return true;
    }

    @Override
    protected Direction getDirection(TileColossalChest tile) {
        return tile.getRotation().func_176734_d();
    }

    @Override
    protected Material getMaterial(TileColossalChest tile) {
        return new Material(Atlases.field_228747_f_, TEXTURES_CHEST.get((Object)tile.getMaterial()));
    }

    protected Material getMaterialInterface(TileColossalChest tile) {
        return new Material(Atlases.field_228747_f_, TEXTURES_INTERFACE.get((Object)tile.getMaterial()));
    }

    protected void setMatrixOrientation(MatrixStack matrixStack, Direction direction) {
        float translateX = -1.0f - (float)direction.func_82601_c();
        float translateY = direction.func_96559_d();
        float translateZ = direction.func_82599_e();
        if (direction == Direction.NORTH) {
            translateZ += 1.0f;
            translateX += 2.0f;
            translateY -= 1.0f;
        } else if (direction == Direction.EAST) {
            translateX += 3.0f;
            translateY -= 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.WEST) {
            translateY -= 1.0f;
        } else if (direction == Direction.SOUTH) {
            translateX += 1.0f;
            translateY -= 1.0f;
        } else if (direction == Direction.UP) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.DOWN) {
            translateX += 1.0f;
        }
        matrixStack.func_227861_a_((double)(translateX * 16.0f), (double)(translateY * 16.0f), (double)(translateZ * 16.0f));
        int rotationY = 0;
        int rotationX = 0;
        if (direction == Direction.SOUTH) {
            rotationY = 0;
        } else if (direction == Direction.NORTH) {
            rotationY = 180;
        } else if (direction == Direction.EAST) {
            rotationY = 90;
        } else if (direction == Direction.WEST) {
            rotationY = -90;
        } else if (direction == Direction.UP) {
            rotationX = -90;
        } else if (direction == Direction.DOWN) {
            rotationX = 90;
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotationY));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)rotationX));
    }

    protected void renderInterface(MatrixStack matrixStack, IVertexBuilder buffer, TextureAtlasSprite sprite, boolean core, int combinedLightIn) {
        for (Direction side : Direction.values()) {
            matrixStack.func_227860_a_();
            float scale = 0.063f;
            matrixStack.func_227862_a_(scale, scale, scale);
            matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
            this.setMatrixOrientation(matrixStack, side);
            float indent = -0.2f;
            if (side == Direction.UP) {
                indent = -15.8f;
            }
            if (side == Direction.DOWN) {
                indent *= 2.0f;
            }
            int alpha = 255;
            float posMin = core ? 5.0f : 6.0f;
            float posMax = 16.0f - posMin;
            float uvScale = posMin / 16.0f;
            float uMin = (sprite.func_94212_f() - sprite.func_94209_e()) * uvScale + sprite.func_94209_e();
            float uMax = (sprite.func_94212_f() - sprite.func_94209_e()) * (1.0f - uvScale) + sprite.func_94209_e();
            float vMin = (sprite.func_94210_h() - sprite.func_94206_g()) * uvScale + sprite.func_94206_g();
            float vMax = (sprite.func_94210_h() - sprite.func_94206_g()) * (1.0f - uvScale) + sprite.func_94206_g();
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            buffer.func_227888_a_(matrix, posMax, posMax, indent).func_225586_a_(255, 255, 255, alpha).func_225583_a_(uMin, vMax).func_227886_a_(combinedLightIn).func_181675_d();
            buffer.func_227888_a_(matrix, posMax, posMin, indent).func_225586_a_(255, 255, 255, alpha).func_225583_a_(uMin, vMin).func_227886_a_(combinedLightIn).func_181675_d();
            buffer.func_227888_a_(matrix, posMin, posMin, indent).func_225586_a_(255, 255, 255, alpha).func_225583_a_(uMax, vMin).func_227886_a_(combinedLightIn).func_181675_d();
            buffer.func_227888_a_(matrix, posMin, posMax, indent).func_225586_a_(255, 255, 255, alpha).func_225583_a_(uMax, vMax).func_227886_a_(combinedLightIn).func_181675_d();
            matrixStack.func_227865_b_();
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        boolean christmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        TEXTURES_CHEST.put(ChestMaterial.WOOD, new ResourceLocation("entity/chest/" + (christmas ? "christmas" : "normal") + ""));
        TEXTURES_CHEST.put(ChestMaterial.COPPER, new ResourceLocation("colossalchests", "models/chest_copper"));
        TEXTURES_CHEST.put(ChestMaterial.IRON, new ResourceLocation("colossalchests", "models/chest_iron"));
        TEXTURES_CHEST.put(ChestMaterial.SILVER, new ResourceLocation("colossalchests", "models/chest_silver"));
        TEXTURES_CHEST.put(ChestMaterial.GOLD, new ResourceLocation("colossalchests", "models/chest_gold"));
        TEXTURES_CHEST.put(ChestMaterial.DIAMOND, new ResourceLocation("colossalchests", "models/chest_diamond"));
        TEXTURES_CHEST.put(ChestMaterial.OBSIDIAN, new ResourceLocation("colossalchests", "models/chest_obsidian"));
        TEXTURES_INTERFACE.put(ChestMaterial.WOOD, new ResourceLocation("colossalchests", "blocks/interface_wood"));
        TEXTURES_INTERFACE.put(ChestMaterial.COPPER, new ResourceLocation("colossalchests", "blocks/interface_copper"));
        TEXTURES_INTERFACE.put(ChestMaterial.IRON, new ResourceLocation("colossalchests", "blocks/interface_iron"));
        TEXTURES_INTERFACE.put(ChestMaterial.SILVER, new ResourceLocation("colossalchests", "blocks/interface_silver"));
        TEXTURES_INTERFACE.put(ChestMaterial.GOLD, new ResourceLocation("colossalchests", "blocks/interface_gold"));
        TEXTURES_INTERFACE.put(ChestMaterial.DIAMOND, new ResourceLocation("colossalchests", "blocks/interface_diamond"));
        TEXTURES_INTERFACE.put(ChestMaterial.OBSIDIAN, new ResourceLocation("colossalchests", "blocks/interface_obsidian"));
    }
}

