/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.command.CommandTBTeleportHome;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfHome
extends ItemTablet {
    public ItemTabletOfHome() {
        super("tablet_of_home", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfHome.get());
        this.func_185043_a(ANCIENT_PROPERTY, (stack, worldIn, entityIn) -> this.isAncient(stack) ? 1.0f : 0.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            boolean isAncient = this.isAncient(stack);
            if (isAncient) {
                this.addItemDesc(list, "_ancient", new Object[0]);
            }
            this.addItemUse(list, !this.isEnchanted(stack) ? "1" : "2", new Object[0]);
            this.addInfoInBeta(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    protected boolean doEffects(World world, ServerPlayerEntity player, ItemStack stack) {
        boolean isSameDim;
        Pair<World, BlockPos> respawnPoint = CommandTBTeleportHome.getRespawnPoint((PlayerEntity)player);
        if (respawnPoint.getLeft() == null || respawnPoint.getRight() == null) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_FAILED.getTranslation(new Object[0]));
            return false;
        }
        boolean bl = isSameDim = respawnPoint.getLeft() == world;
        if (!isSameDim && !((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.getTranslation(new Object[0]));
            return false;
        }
        Location location = new SpawnHelper((ServerWorld)respawnPoint.getLeft(), (BlockPos)respawnPoint.getRight()).findSpawnPlace(false);
        if (location.isOrigin()) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_FAILED.getTranslation(new Object[0]));
            return false;
        }
        CallbackHandler.addCallback(1, () -> {
            boolean isAncient = this.isAncient(stack);
            AxisAlignedBB area = isAncient ? player.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0) : null;
            ServerPlayerEntity newPlayer = Helper.teleportEntity(player, location);
            if (isAncient) {
                List entities = world.func_72839_b((Entity)player, area);
                entities.forEach(entity -> Helper.teleportEntity(entity, new Location((Entity)newPlayer)));
            }
            newPlayer.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslation(new Object[0]));
            ModTriggers.USE_HOME.trigger(player);
        });
        return true;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        NBTStackHelper.setBoolean(stack, "enchant", true);
        this.setUseCount(stack, this.getUseMax());
        return true;
    }
}

