/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.registry.ModTags;

public class SpawnHelper {
    private final World world;
    private final int dimId;
    private final int actualHeight;
    private final BlockPos initPos;
    private List<BlockPos> positions;
    private final Map<BlockPos, EnumSpawnPlace> spawnPlaces = new HashMap<BlockPos, EnumSpawnPlace>();
    private BlockPos spawnPos = null;
    private EnumSpawnType spawnType = EnumSpawnType.NONE;

    public SpawnHelper(ServerWorld world, BlockPos initPos) {
        this.world = world;
        this.dimId = Helper.getDimensionId((IWorld)world);
        this.actualHeight = world.func_72940_L();
        this.initPos = Helper.getCloserValidPos((World)world, initPos);
    }

    public Location findSpawnPlace() {
        return this.findSpawnPlace(false);
    }

    public Location findSafePlace(int range, boolean withHeight) {
        this.initPositions(this.initPos.func_177982_a(-range, withHeight ? -range : 0, -range), this.initPos.func_177982_a(range, withHeight ? range : 0, range));
        for (BlockPos currentPos : this.positions) {
            if (!this.isValidSpawnPlace(currentPos)) continue;
            return new Location(currentPos, (IWorld)this.world);
        }
        return this.spawnType.ordinal() >= EnumSpawnType.NORMAL.ordinal() ? new Location(this.spawnPos, this.dimId) : Location.ORIGIN;
    }

    public Location findPlaceInStructure(ResourceLocation structureRL) {
        return this.findPlaceInStructure(structureRL.func_110624_b(), structureRL.func_110623_a());
    }

    public Location findPlaceInStructure(String structureRL) {
        Pair<String, String> rl = Helper.parseRLString(structureRL);
        return this.findPlaceInStructure((String)rl.getLeft(), (String)rl.getRight());
    }

    public Location findPlaceInStructure(String domain, String path) {
        if (SupportStructures.BURIED_TREASURE.is(domain, path)) {
            this.positions = ImmutableList.of((Object)this.initPos);
        } else {
            this.initChunkPositions();
        }
        int y = SupportStructures.getY(domain, path);
        int maxY = Math.min(y + 16, this.actualHeight);
        int minY = Math.max(y - 16, 0);
        int yUp = this.initPos.func_177956_o();
        int yDown = yUp - 1;
        boolean canGoDown = true;
        boolean canGoUp = true;
        while (canGoUp || canGoDown) {
            canGoUp = yUp < maxY;
            canGoDown = yDown > minY;
            for (BlockPos pos : this.positions) {
                BlockPos currentPos;
                if (canGoUp && this.isValidSpawnPlace(currentPos = new BlockPos(pos.func_177958_n(), yUp, pos.func_177952_p()))) {
                    return new Location(currentPos, this.dimId);
                }
                if (!canGoDown || !this.isValidSpawnPlace(currentPos = new BlockPos(pos.func_177958_n(), yDown, pos.func_177952_p()))) continue;
                return new Location(currentPos, this.dimId);
            }
            ++yUp;
            --yDown;
        }
        return this.spawnType.ordinal() >= EnumSpawnType.NORMAL.ordinal() ? new Location(this.spawnPos, this.dimId) : Location.ORIGIN;
    }

    private boolean containLiquid(BlockState state) {
        return !state.func_204520_s().func_206888_e();
    }

    public Location findSpawnPlace(boolean isGrave) {
        int minY;
        int maxY;
        boolean wasInLiquid;
        if (isGrave && this.isValidGravePlace(this.initPos) || this.isValidSpawnPlace(this.initPos)) {
            return new Location(this.initPos, this.dimId);
        }
        this.initChunkPositions();
        BlockPos adjustedPos = this.initPos;
        boolean bl = wasInLiquid = (Boolean)ConfigTombstone.general.allowGraveInWater.get() == false && (this.containLiquid(this.world.func_180495_p(adjustedPos)) || World.func_175701_a((BlockPos)adjustedPos.func_177984_a()) && this.containLiquid(this.world.func_180495_p(adjustedPos.func_177984_a())));
        if (wasInLiquid) {
            adjustedPos = adjustedPos.func_177984_a();
            while (this.containLiquid(this.world.func_180495_p(adjustedPos))) {
                if (World.func_175701_a((BlockPos)(adjustedPos = adjustedPos.func_177984_a())) && adjustedPos.func_177956_o() - this.initPos.func_177956_o() <= 300) continue;
                adjustedPos = this.initPos;
                wasInLiquid = false;
                break;
            }
        }
        if (!isGrave) {
            maxY = Math.min(adjustedPos.func_177956_o() + 70, this.actualHeight);
            minY = Math.max(adjustedPos.func_177956_o() - 70, 0);
        } else {
            maxY = this.actualHeight;
            minY = 0;
        }
        int yUp = adjustedPos.func_177956_o();
        int yDown = yUp - 1;
        boolean canGoDown = true;
        boolean canGoUp = true;
        while (canGoUp || canGoDown) {
            canGoUp = yUp < maxY;
            canGoDown = !wasInLiquid && yDown > minY;
            for (BlockPos pos : this.positions) {
                boolean valid;
                BlockPos currentPos;
                if (canGoUp) {
                    currentPos = new BlockPos(pos.func_177958_n(), yUp, pos.func_177952_p());
                    boolean bl2 = valid = !isGrave ? this.isValidSpawnPlace(currentPos) : this.isValidGravePlace(currentPos);
                    if (valid) {
                        return new Location(currentPos, this.dimId);
                    }
                }
                if (!canGoDown) continue;
                currentPos = new BlockPos(pos.func_177958_n(), yDown, pos.func_177952_p());
                valid = !isGrave ? this.isValidSpawnPlace(currentPos) : this.isValidGravePlace(currentPos);
                if (!valid) continue;
                return new Location(currentPos, this.dimId);
            }
            ++yUp;
            --yDown;
        }
        boolean valid = false;
        if (isGrave) {
            if (this.spawnType != EnumSpawnType.NONE) {
                valid = true;
            }
        } else if (this.spawnType.ordinal() >= EnumSpawnType.NORMAL.ordinal()) {
            valid = true;
        }
        return valid ? new Location(this.spawnPos, (IWorld)this.world) : Location.ORIGIN;
    }

    private boolean isValidSpawnPlace(BlockPos pos) {
        if (this.isSafeGround(pos.func_177977_b()) && this.isSafePlace(pos) && this.isSafePlace(pos.func_177984_a())) {
            this.setTypeAndPosition(EnumSpawnType.IDEAL, pos);
            return true;
        }
        return false;
    }

    private boolean isValidGravePlace(BlockPos pos) {
        if (this.isGravePlace(pos)) {
            this.setTypeAndPosition(EnumSpawnType.MINIMAL, pos);
            if (this.isSafeGround(pos.func_177977_b())) {
                this.setTypeAndPosition(EnumSpawnType.NORMAL, pos);
                if (this.isSafePlace(pos.func_177984_a()) && this.isSafePlace(pos.func_177981_b(2))) {
                    this.setTypeAndPosition(EnumSpawnType.IDEAL, pos);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isGravePlace(BlockPos pos) {
        return this.isSafePlace(pos) && this.world.func_175625_s(pos) == null;
    }

    private boolean isSafeGround(BlockPos pos) {
        EnumSpawnPlace placeType = this.getPlaceType(pos);
        return placeType.isGround() || (Boolean)ConfigTombstone.general.allowGraveInWater.get() != false && placeType.isWater();
    }

    private boolean isSafePlace(BlockPos pos) {
        EnumSpawnPlace placeType = this.getPlaceType(pos);
        return placeType.isSafe() || (Boolean)ConfigTombstone.general.allowGraveInWater.get() != false && placeType.isWater();
    }

    private void setTypeAndPosition(EnumSpawnType type, BlockPos pos) {
        if (type.ordinal() > this.spawnType.ordinal()) {
            this.spawnType = type;
            this.spawnPos = pos;
        }
    }

    private EnumSpawnPlace getPlaceType(BlockPos pos) {
        return this.spawnPlaces.computeIfAbsent(pos, p -> SpawnHelper.getPathNodeTypeRaw(this.world, p));
    }

    private void initChunkPositions() {
        ChunkPos chunkPos = new ChunkPos(this.initPos);
        this.initPositions(new BlockPos(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d()), new BlockPos(chunkPos.func_180332_e(), 0, chunkPos.func_180330_f()));
    }

    private void initPositions(BlockPos startPos, BlockPos endPos) {
        this.spawnPos = null;
        this.spawnType = EnumSpawnType.NONE;
        this.spawnPlaces.clear();
        this.positions = SpawnHelper.getAllInBox(startPos, endPos).sorted(Comparator.comparingDouble(pos -> Helper.getDistanceSq((Vec3i)pos, this.initPos.func_177958_n(), 0, this.initPos.func_177952_p()))).collect(Collectors.toList());
    }

    public static Stream<BlockPos> getAllInBox(BlockPos startPos, BlockPos endPos) {
        int minX = Math.min(startPos.func_177958_n(), endPos.func_177958_n());
        int maxX = Math.max(startPos.func_177958_n(), endPos.func_177958_n());
        int minY = Math.min(startPos.func_177956_o(), endPos.func_177956_o());
        int maxY = Math.max(startPos.func_177956_o(), endPos.func_177956_o());
        int minZ = Math.min(startPos.func_177952_p(), endPos.func_177952_p());
        int maxZ = Math.max(startPos.func_177952_p(), endPos.func_177952_p());
        Stream.Builder<BlockPos> list = Stream.builder();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    list.accept(new BlockPos(x, y, z));
                }
            }
        }
        return list.build();
    }

    private static <T extends World> EnumSpawnPlace getPathNodeTypeRaw(T world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Material mat = state.func_185904_a();
        if (!Helper.isValidPos(world, pos) || !world.func_175667_e(pos)) {
            return EnumSpawnPlace.UNSAFE;
        }
        PathNodeType type = block.getAiPathNodeType(state, world, pos, null);
        if (type == null) {
            if (mat == Material.field_151579_a) {
                return EnumSpawnPlace.SAFE;
            }
            if (mat == Material.field_151586_h) {
                return EnumSpawnPlace.WATER;
            }
            if (mat == Material.field_151587_i || mat == Material.field_151581_o || mat == Material.field_151567_E) {
                return EnumSpawnPlace.UNSAFE;
            }
            if (block.func_203417_a(ModTags.Blocks.graves) || block == Blocks.field_150426_aN || block == Blocks.field_185778_de || block == Blocks.field_185774_da || block == Blocks.field_150458_ak || block.func_203417_a(BlockTags.field_203292_x) || block.func_203417_a(BlockTags.field_203291_w) || block.func_203417_a(BlockTags.field_219757_z) || block.func_203417_a(BlockTags.field_200028_e) || block.func_203417_a(BlockTags.field_219747_F) || block.func_203417_a(BlockTags.field_206952_E)) {
                return EnumSpawnPlace.GROUND;
            }
            if (block == Blocks.field_150434_aF || block == Blocks.field_196814_hQ || block.func_203417_a(BlockTags.field_212185_E) || block.func_203417_a(BlockTags.field_200029_f) || block.func_203417_a(BlockTags.field_219748_G) || block.func_203417_a(Tags.Blocks.FENCE_GATES)) {
                return EnumSpawnPlace.UNSAFE;
            }
            return !mat.func_76230_c() ? EnumSpawnPlace.SAFE : (block.func_220081_d(state, world, pos) ? EnumSpawnPlace.GROUND : EnumSpawnPlace.UNSAFE);
        }
        if (type == PathNodeType.OPEN) {
            return EnumSpawnPlace.SAFE;
        }
        if (type == PathNodeType.BLOCKED || type == PathNodeType.WALKABLE) {
            return EnumSpawnPlace.GROUND;
        }
        return EnumSpawnPlace.UNSAFE;
    }

    public static enum EnumSpawnType {
        NONE,
        MINIMAL,
        NORMAL,
        FIT,
        IDEAL;

    }

    public static enum EnumSpawnPlace {
        SAFE,
        GROUND,
        UNSAFE,
        WATER;


        public boolean isSafe() {
            return this == SAFE;
        }

        public boolean isGround() {
            return this == GROUND;
        }

        public boolean isWater() {
            return this == WATER;
        }
    }
}

