/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules.support;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.CommonRuleEvaluator;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.typed.AttributeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class GenericRuleEvaluator
extends CommonRuleEvaluator {
    public GenericRuleEvaluator(AttributeMap map) {
        super(map, InControl.setup.getLogger(), new ModRuleCompatibilityLayer());
    }

    @Override
    protected void addChecks(AttributeMap map) {
        super.addChecks(map);
        if (map.has(RuleKeys.HOSTILE)) {
            this.addHostileCheck(map);
        }
        if (map.has(RuleKeys.PASSIVE)) {
            this.addPassiveCheck(map);
        }
        if (map.has(RuleKeys.CANSPAWNHERE)) {
            this.addCanSpawnHereCheck(map);
        }
        if (map.has(RuleKeys.NOTCOLLIDING)) {
            this.addNotCollidingCheck(map);
        }
        if (map.has(RuleKeys.SPAWNER)) {
            this.addSpawnerCheck(map);
        }
        if (map.has(RuleKeys.MOB)) {
            this.addMobsCheck(map);
        }
        if (map.has(RuleKeys.PLAYER)) {
            this.addPlayerCheck(map);
        }
        if (map.has(RuleKeys.REALPLAYER)) {
            this.addRealPlayerCheck(map);
        }
        if (map.has(RuleKeys.FAKEPLAYER)) {
            this.addFakePlayerCheck(map);
        }
        if (map.has(RuleKeys.EXPLOSION)) {
            this.addExplosionCheck(map);
        }
        if (map.has(RuleKeys.PROJECTILE)) {
            this.addProjectileCheck(map);
        }
        if (map.has(RuleKeys.FIRE)) {
            this.addFireCheck(map);
        }
        if (map.has(RuleKeys.MAGIC)) {
            this.addMagicCheck(map);
        }
        if (map.has(RuleKeys.SOURCE)) {
            this.addSourceCheck(map);
        }
        if (map.has(RuleKeys.MOD)) {
            this.addModsCheck(map);
        }
        if (map.has(RuleKeys.MINCOUNT)) {
            this.addMinCountCheck(map);
        }
        if (map.has(RuleKeys.MAXCOUNT)) {
            this.addMaxCountCheck(map);
        }
    }

    private void addCanSpawnHereCheck(AttributeMap map) {
        boolean c = map.get(RuleKeys.CANSPAWNHERE);
        if (c) {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof MobEntity) {
                    return MobEntity.func_223315_a((EntityType)entity.func_200600_R(), (IWorld)entity.func_130014_f_(), (SpawnReason)SpawnReason.NATURAL, (BlockPos)entity.func_180425_c(), null);
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof MobEntity) {
                    return !MobEntity.func_223315_a((EntityType)entity.func_200600_R(), (IWorld)entity.func_130014_f_(), (SpawnReason)SpawnReason.NATURAL, (BlockPos)entity.func_180425_c(), null);
                }
                return true;
            });
        }
    }

    private void addNotCollidingCheck(AttributeMap map) {
        boolean c = map.get(RuleKeys.NOTCOLLIDING);
        if (c) {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof MobEntity) {
                    return ((MobEntity)entity).func_205019_a((IWorldReader)entity.func_130014_f_());
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof MobEntity) {
                    return !((MobEntity)entity).func_205019_a((IWorldReader)entity.func_130014_f_());
                }
                return true;
            });
        }
    }

    private void addSpawnerCheck(AttributeMap map) {
        boolean c = map.get(RuleKeys.SPAWNER);
        if (c) {
            this.checks.add((event, query) -> {
                if (event instanceof LivingSpawnEvent.CheckSpawn) {
                    LivingSpawnEvent.CheckSpawn checkSpawn = (LivingSpawnEvent.CheckSpawn)event;
                    return checkSpawn.isSpawner();
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                if (event instanceof LivingSpawnEvent.CheckSpawn) {
                    LivingSpawnEvent.CheckSpawn checkSpawn = (LivingSpawnEvent.CheckSpawn)event;
                    return !checkSpawn.isSpawner();
                }
                return false;
            });
        }
    }

    private void addHostileCheck(AttributeMap map) {
        if (map.get(RuleKeys.HOSTILE).booleanValue()) {
            this.checks.add((event, query) -> query.getEntity(event) instanceof IMob);
        } else {
            this.checks.add((event, query) -> !(query.getEntity(event) instanceof IMob));
        }
    }

    private void addPassiveCheck(AttributeMap map) {
        if (map.get(RuleKeys.PASSIVE).booleanValue()) {
            this.checks.add((event, query) -> query.getEntity(event) instanceof AnimalEntity && !(query.getEntity(event) instanceof IMob));
        } else {
            this.checks.add((event, query) -> !(query.getEntity(event) instanceof AnimalEntity) || query.getEntity(event) instanceof IMob);
        }
    }

    private void addMobsCheck(AttributeMap map) {
        List<String> mobs = map.getList(RuleKeys.MOB);
        if (mobs.size() == 1) {
            String id = mobs.get(0);
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            if (type != null) {
                this.checks.add((event, query) -> type.equals(query.getEntity(event).func_200600_R()));
            } else {
                InControl.setup.getLogger().log(Level.ERROR, "Unknown mob '" + id + "'!");
            }
        } else {
            HashSet<EntityType> classes = new HashSet<EntityType>();
            for (String id : mobs) {
                EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
                if (type != null) {
                    classes.add(type);
                    continue;
                }
                InControl.setup.getLogger().log(Level.ERROR, "Unknown mob '" + id + "'!");
            }
            if (!classes.isEmpty()) {
                this.checks.add((event, query) -> classes.contains(query.getEntity(event).getClass()));
            }
        }
    }

    private void addModsCheck(AttributeMap map) {
        List<String> mods = map.getList(RuleKeys.MOD);
        if (mods.size() == 1) {
            String modid = mods.get(0);
            this.checks.add((event, query) -> {
                String mod = query.getEntity(event).func_200600_R().getRegistryName().func_110624_b();
                return modid.equals(mod);
            });
        } else {
            HashSet<String> modids = new HashSet<String>();
            for (String modid : mods) {
                modids.add(modid);
            }
            this.checks.add((event, query) -> {
                String mod = query.getEntity(event).func_200600_R().getRegistryName().func_110624_b();
                return modids.contains(mod);
            });
        }
    }

    @Nullable
    private CountInfo parseCountInfo(String json) {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isString()) {
                int amount;
                String[] splitted = StringUtils.split((String)element.getAsString(), (char)',');
                try {
                    amount = Integer.parseInt(splitted[0]);
                }
                catch (NumberFormatException e) {
                    InControl.setup.getLogger().log(Level.ERROR, "Bad amount for mincount '" + splitted[0] + "'!");
                    return null;
                }
                EntityType entityClass = null;
                if (splitted.length > 1 && (entityClass = this.findEntity(splitted[1])) == null) {
                    InControl.setup.getLogger().log(Level.ERROR, "Cannot find mob '" + splitted[1] + "'!");
                    return null;
                }
                return new CountInfo().setAmount(amount).addEntityType(entityClass);
            }
            int amount = element.getAsInt();
            return new CountInfo().setAmount(amount);
        }
        if (element.isJsonObject()) {
            String error;
            JsonObject obj = element.getAsJsonObject();
            int amount = obj.get("amount").getAsInt();
            CountInfo info = new CountInfo().setAmount(amount);
            if (obj.has("mob")) {
                if (obj.get("mob").isJsonPrimitive()) {
                    String entity = obj.get("mob").getAsString();
                    EntityType entityType = this.findEntity(entity);
                    if (entityType == null) {
                        return null;
                    }
                    info.addEntityType(entityType);
                } else if (obj.get("mob").isJsonArray()) {
                    JsonArray array = obj.get("mob").getAsJsonArray();
                    for (JsonElement el : array) {
                        String entity = el.getAsString();
                        EntityType entityType = this.findEntity(entity);
                        if (entityType == null) {
                            InControl.setup.getLogger().log(Level.ERROR, "Cannot find mob '" + entity + "'!");
                            return null;
                        }
                        info.addEntityType(entityType);
                    }
                } else {
                    InControl.setup.getLogger().log(Level.ERROR, "Bad entity tag in count description!");
                    return null;
                }
            }
            if (obj.has("mod")) {
                String mod = obj.get("mod").getAsString();
                info.setMod(mod);
            }
            if (obj.has("perplayer")) {
                info.setScaledPerPlayer(obj.get("perplayer").getAsBoolean());
            }
            if (obj.has("perchunk")) {
                info.setScaledPerChunk(obj.get("perchunk").getAsBoolean());
            }
            if (obj.has("passive")) {
                info.setPassive(obj.get("passive").getAsBoolean());
            }
            if (obj.has("hostile")) {
                info.setHostile(obj.get("hostile").getAsBoolean());
            }
            if ((error = info.validate()) != null) {
                InControl.setup.getLogger().log(Level.ERROR, error);
                return null;
            }
            return info;
        }
        InControl.setup.getLogger().log(Level.ERROR, "Count description '" + json + "' is not valid!");
        return null;
    }

    private EntityType findEntity(String id) {
        EntityType ee = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
        if (ee == null) {
            InControl.setup.getLogger().log(Level.ERROR, "Unknown mob '" + id + "'!");
            return null;
        }
        return ee;
    }

    private void addMinCountCheck(AttributeMap map) {
        String json = map.get(RuleKeys.MINCOUNT);
        CountInfo info = this.parseCountInfo(json);
        if (info == null) {
            return;
        }
        BiFunction<World, Entity, Integer> counter = this.getCounter(info);
        Function<World, Integer> amountAdjuster = this.getAmountAdjuster(info, info.amount);
        this.checks.add((event, query) -> {
            int amount;
            Entity entity;
            World world = query.getWorld(event);
            int count = (Integer)counter.apply(world, entity = query.getEntity(event));
            return count >= (amount = ((Integer)amountAdjuster.apply(world)).intValue());
        });
    }

    private void addMaxCountCheck(AttributeMap map) {
        String json = map.get(RuleKeys.MAXCOUNT);
        CountInfo info = this.parseCountInfo(json);
        BiFunction<World, Entity, Integer> counter = this.getCounter(info);
        Function<World, Integer> amountAdjuster = this.getAmountAdjuster(info, info.amount);
        this.checks.add((event, query) -> {
            int amount;
            Entity entity;
            World world = query.getWorld(event);
            int count = (Integer)counter.apply(world, entity = query.getEntity(event));
            return count < (amount = ((Integer)amountAdjuster.apply(world)).intValue());
        });
    }

    private Function<World, Integer> getAmountAdjuster(CountInfo info, int infoAmount) {
        Function<World, Integer> amountAdjuster = info.scaledPerChunk ? world -> infoAmount * InControl.setup.cache.getValidSpawnChunks((World)world) / 289 : (info.scaledPerPlayer ? world -> infoAmount * InControl.setup.cache.getValidPlayers((World)world) : world -> infoAmount);
        return amountAdjuster;
    }

    private BiFunction<World, Entity, Integer> getCounter(CountInfo info) {
        List infoEntityType;
        BiFunction<World, Entity, Integer> counter = info.mod != null ? (info.hostile ? (world, entity) -> InControl.setup.cache.getCountPerModHostile((World)world, info.mod) : (info.passive ? (world, entity) -> InControl.setup.cache.getCountPerModPassive((World)world, info.mod) : (world, entity) -> InControl.setup.cache.getCountPerMod((World)world, info.mod))) : (info.hostile ? (world, entity) -> InControl.setup.cache.getCountHostile((World)world) : (info.passive ? (world, entity) -> InControl.setup.cache.getCountPassive((World)world) : ((infoEntityType = info.entityTypes).isEmpty() ? (world, entity) -> InControl.setup.cache.getCount((World)world, entity.func_200600_R()) : (infoEntityType.size() == 1 ? (world, entity) -> {
            EntityType entityType = (EntityType)infoEntityType.get(0);
            return InControl.setup.cache.getCount((World)world, entityType);
        } : (world, entity) -> {
            int amount = 0;
            for (EntityType cls : infoEntityType) {
                amount += InControl.setup.cache.getCount((World)world, cls);
            }
            return amount;
        }))));
        return counter;
    }

    private void addPlayerCheck(AttributeMap map) {
        boolean asPlayer = map.get(RuleKeys.PLAYER);
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) instanceof PlayerEntity);
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) instanceof PlayerEntity);
        }
    }

    private boolean isFakePlayer(Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        if (entity instanceof FakePlayer) {
            return true;
        }
        PlayerList playerList = entity.func_130014_f_().func_73046_m().func_184103_al();
        ServerPlayerEntity playerByUUID = playerList.func_177451_a(((PlayerEntity)entity).func_146103_bH().getId());
        if (playerByUUID == null) {
            return true;
        }
        return entity != playerByUUID;
    }

    private boolean isRealPlayer(Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        return !this.isFakePlayer(entity);
    }

    private void addRealPlayerCheck(AttributeMap map) {
        boolean asPlayer = map.get(RuleKeys.REALPLAYER);
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? false : this.isRealPlayer(query.getAttacker(event)));
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? true : !this.isRealPlayer(query.getAttacker(event)));
        }
    }

    private void addFakePlayerCheck(AttributeMap map) {
        boolean asPlayer = map.get(RuleKeys.FAKEPLAYER);
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? false : this.isFakePlayer(query.getAttacker(event)));
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? true : !this.isFakePlayer(query.getAttacker(event)));
        }
    }

    private void addExplosionCheck(AttributeMap map) {
        boolean explosion = map.get(RuleKeys.EXPLOSION);
        if (explosion) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_94541_c());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_94541_c());
        }
    }

    private void addProjectileCheck(AttributeMap map) {
        boolean projectile = map.get(RuleKeys.PROJECTILE);
        if (projectile) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_76352_a());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_76352_a());
        }
    }

    private void addFireCheck(AttributeMap map) {
        boolean fire = map.get(RuleKeys.FIRE);
        if (fire) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_76347_k());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_76347_k());
        }
    }

    private void addMagicCheck(AttributeMap map) {
        boolean magic = map.get(RuleKeys.MAGIC);
        if (magic) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).func_82725_o());
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).func_82725_o());
        }
    }

    private void addSourceCheck(AttributeMap map) {
        List<String> sources = map.getList(RuleKeys.SOURCE);
        HashSet<String> sourceSet = new HashSet<String>(sources);
        this.checks.add((event, query) -> {
            if (query.getSource(event) == null) {
                return false;
            }
            return sourceSet.contains(query.getSource(event).func_76355_l());
        });
    }

    @Override
    public boolean match(Event event, IEventQuery query) {
        for (BiFunction rule : this.checks) {
            if (((Boolean)rule.apply(event, query)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static class CountInfo {
        private int amount;
        private List<EntityType> entityTypes = new ArrayList<EntityType>();
        private boolean scaledPerPlayer = false;
        private boolean scaledPerChunk = false;
        private boolean passive = false;
        private boolean hostile = false;
        private String mod = null;

        public CountInfo setAmount(int amount) {
            this.amount = amount;
            return this;
        }

        public CountInfo addEntityType(EntityType entityClass) {
            if (entityClass != null) {
                this.entityTypes.add(entityClass);
            }
            return this;
        }

        public CountInfo setScaledPerPlayer(boolean scaledPerPlayer) {
            this.scaledPerPlayer = scaledPerPlayer;
            return this;
        }

        public CountInfo setScaledPerChunk(boolean scaledPerChunk) {
            this.scaledPerChunk = scaledPerChunk;
            return this;
        }

        public CountInfo setPassive(boolean passive) {
            this.passive = passive;
            return this;
        }

        public CountInfo setHostile(boolean hostile) {
            this.hostile = hostile;
            return this;
        }

        public CountInfo setMod(String mod) {
            this.mod = mod;
            return this;
        }

        public String validate() {
            if (this.scaledPerPlayer && this.scaledPerChunk) {
                return "You cannot combine 'perchunk' and 'perplayer'!";
            }
            if (this.mod != null && !this.entityTypes.isEmpty()) {
                return "You cannot combine 'mod' with 'mob'!";
            }
            if (this.passive && this.hostile) {
                return "Don't use passive and hostile at the same time!";
            }
            if ((this.passive || this.hostile) && !this.entityTypes.isEmpty()) {
                return "You cannot combine 'passive' or 'hostile' with 'mob'!";
            }
            return null;
        }
    }
}

