/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.List;
import java.util.Set;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.codemodel.type.TypeVisitorWithContext;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;

public class GenericTypeID
implements TypeID {
    public final TypeParameter parameter;

    public GenericTypeID(TypeParameter parameter) {
        this.parameter = parameter;
    }

    public boolean matches(LocalMemberCache cache, StoredType type) {
        if (type.getSpecifiedStorage() != null && this.parameter.storage != null && !type.getActualStorage().equals(this.parameter.storage)) {
            return false;
        }
        return this.parameter.matches(cache, type.type);
    }

    @Override
    public GenericTypeID getNormalized() {
        return this;
    }

    @Override
    public StoredType instance(GenericMapper mapper, StorageTag storage) {
        StoredType mapped = mapper.map(this);
        return new StoredType(mapped.type, StorageTag.union(mapper.position, mapped.getSpecifiedStorage(), storage));
    }

    @Override
    public <R> R accept(TypeVisitor<R> visitor) {
        return visitor.visitGeneric(this);
    }

    @Override
    public <C, R, E extends Exception> R accept(C context, TypeVisitorWithContext<C, R, E> visitor) throws E {
        return visitor.visitGeneric(context, this);
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isValueType() {
        return false;
    }

    @Override
    public boolean isDestructible() {
        return false;
    }

    @Override
    public boolean isDestructible(Set<HighLevelDefinition> scanning) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public boolean hasInferenceBlockingTypeParameters(TypeParameter[] parameters) {
        for (TypeParameter parameter : parameters) {
            if (parameter != this.parameter) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasDefaultValue() {
        return false;
    }

    @Override
    public void extractTypeParameters(List<TypeParameter> typeParameters) {
        if (!typeParameters.contains(this.parameter)) {
            typeParameters.add(this.parameter);
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.parameter.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericTypeID other = (GenericTypeID)obj;
        return this.parameter == other.parameter;
    }

    public String toString() {
        return this.parameter.toString();
    }
}

