/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item.transformed;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformer;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.item.transformed.IngredientTransformed;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.item.crafting.Ingredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.MCIngredientTransformed")
@Document(value="vanilla/api/items/MCIngredientTransformed")
public class MCIngredientTransformed<T extends IIngredient>
implements IIngredient {
    private final T base;
    private final IIngredientTransformer<T> transformer;

    public MCIngredientTransformed(T base, IIngredientTransformer<T> transformer) {
        this.base = base;
        this.transformer = transformer;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        return new IngredientTransformed(this);
    }

    @ZenCodeType.Getter(value="transformer")
    public IIngredientTransformer<T> getTransformer() {
        return this.transformer;
    }

    @Override
    public IItemStack getRemainingItem(IItemStack stack) {
        return this.transformer.transform(stack);
    }

    @Override
    public String getCommandString() {
        return this.transformer.getCommandString(this.base);
    }

    @ZenCodeType.Getter(value="baseIngredient")
    public T getBaseIngredient() {
        return this.base;
    }

    @Override
    @ZenCodeType.Method
    public boolean matches(IItemStack stack) {
        return this.base.matches(stack);
    }

    @Override
    @ZenCodeType.Getter(value="items")
    public IItemStack[] getItems() {
        return this.base.getItems();
    }

    @Override
    @ZenCodeType.Caster(implicit=true)
    public MapData asMapData() {
        return this.base.asMapData();
    }

    @Override
    @ZenCodeType.Caster(implicit=true)
    public IData asIData() {
        return this.base.asIData();
    }
}

