/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.BracketDumper;
import com.blamejared.crafttweaker.api.annotations.BracketResolver;
import com.blamejared.crafttweaker.api.annotations.Preprocessor;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

public class CraftTweakerRegistry {
    private static final Type TYPE_ZEN_REGISTER = Type.getType(ZenRegister.class);
    private static final Type TYPE_PRE_PROCESSOR = Type.getType(Preprocessor.class);
    private static final List<Class> ZEN_CLASSES = new ArrayList<Class>();
    private static final List<Class> ZEN_GLOBALS = new ArrayList<Class>();
    private static final List<Method> BRACKET_RESOLVERS = new ArrayList<Method>();
    private static final Map<String, Supplier<Collection<String>>> BRACKET_DUMPERS = new HashMap<String, Supplier<Collection<String>>>();
    private static final Map<String, Class> ZEN_CLASS_MAP = new HashMap<String, Class>();
    private static final List<IPreprocessor> PREPROCESSORS = new ArrayList<IPreprocessor>();
    private static final Map<String, List<Class>> EXPANSIONS = new HashMap<String, List<Class>>();

    public static void findClasses() {
        ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> TYPE_ZEN_REGISTER.equals((Object)a.getAnnotationType())).collect(Collectors.toList()).forEach(CraftTweakerRegistry::addClass);
        CraftTweakerRegistry.sortClasses();
        ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> TYPE_PRE_PROCESSOR.equals((Object)a.getAnnotationType())).forEach(data -> {
            Type type = data.getClassType();
            try {
                Class<?> clazz = Class.forName(type.getClassName(), false, CraftTweaker.class.getClassLoader());
                boolean valid = false;
                for (Class<?> intFace : clazz.getInterfaces()) {
                    if (intFace != IPreprocessor.class) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    CraftTweakerAPI.logWarning("Preprocessor: \"%s\" does not implement IPreprocessor!", type.getClassName());
                    return;
                }
                IPreprocessor preprocessor = null;
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (constructor.getParameterCount() != 0) continue;
                    try {
                        preprocessor = (IPreprocessor)constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        CraftTweakerAPI.logThrowing("Preprocessor: \"%s\" can not be instantiated! Make sure it has a public empty constructor", e, new Object[0]);
                        e.printStackTrace();
                    }
                }
                if (preprocessor != null) {
                    PREPROCESSORS.add(preprocessor);
                } else {
                    CraftTweakerAPI.logWarning("Can not register Preprocessor: \"%s\"!", type.getClassName());
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        });
    }

    private static void addClass(ModFileScanData.AnnotationData data) {
        if (data.getAnnotationData().containsKey("modDeps")) {
            List modOnly = (List)data.getAnnotationData().get("modDeps");
            for (String mod : modOnly) {
                if (mod == null || mod.isEmpty() || ModList.get().isLoaded(mod)) continue;
                return;
            }
        }
        CraftTweaker.LOG.info("Found ZenRegister: {}", (Object)data.getClassType().getClassName());
        try {
            Class<?> clazz = Class.forName(data.getClassType().getClassName(), false, CraftTweaker.class.getClassLoader());
            ZEN_CLASSES.add(clazz);
            if (!clazz.isInterface() && IRecipeManager.class.isAssignableFrom(clazz)) {
                RecipeTypeBracketHandler.registerRecipeManager(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void sortClasses() {
        for (Class zenClass : ZEN_CLASSES) {
            if (zenClass.isAnnotationPresent(ZenCodeType.Name.class)) {
                ZenCodeType.Name name = zenClass.getAnnotation(ZenCodeType.Name.class);
                ZEN_CLASS_MAP.put(name.value(), zenClass);
            }
            if (zenClass.isAnnotationPresent(ZenCodeType.Expansion.class)) {
                EXPANSIONS.computeIfAbsent(zenClass.getAnnotation(ZenCodeType.Expansion.class).value(), s -> new ArrayList()).add(zenClass);
            }
            if (CraftTweakerRegistry.hasGlobal(zenClass)) {
                ZEN_GLOBALS.add(zenClass);
            }
            for (Method method : zenClass.getDeclaredMethods()) {
                CraftTweakerRegistry.handleBracketResolver(method);
                CraftTweakerRegistry.handleBracketDumper(method);
            }
        }
    }

    private static void handleBracketResolver(Method method) {
        if (!method.isAnnotationPresent(BracketResolver.class)) {
            return;
        }
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as a BracketResolver, but it is not public and static.", method.toString());
            return;
        }
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length == 1 && parameters[0].equals(String.class)) {
            BRACKET_RESOLVERS.add(method);
        } else {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as a BracketResolver, but it does not have a String as it's only parameter.", method.toString());
        }
        if (!CommandStringDisplayable.class.isAssignableFrom(method.getReturnType())) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as a BracketResolver, so it should return something that implements %s.", method.toString(), CommandStringDisplayable.class.getSimpleName());
        }
    }

    private static void handleBracketDumper(Method method) {
        if (!method.isAnnotationPresent(BracketDumper.class)) {
            return;
        }
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as a BracketDumper, but it is not public and static.", method.toString());
            return;
        }
        if (method.getParameterCount() != 0) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as BracketDumper but does not have 0 parameters.", method.toString());
            return;
        }
        if (!Collection.class.isAssignableFrom(method.getReturnType()) || ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0] != String.class) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as BracketDumper but does not have 'Collection<String>' as return type.", method.toGenericString());
            return;
        }
        String value = method.getAnnotation(BracketDumper.class).value();
        BRACKET_DUMPERS.merge(value, () -> {
            try {
                return (Collection)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ignored) {
                return null;
            }
        }, (dumpFun1, dumpFun2) -> () -> CraftTweakerRegistry.lambda$null$5((Supplier)dumpFun1, (Supplier)dumpFun2));
    }

    private static boolean hasGlobal(Class zenClass) {
        for (Method method : zenClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ZenCodeGlobals.Global.class) || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : zenClass.getDeclaredFields()) {
            if (!accessibleObject.isAnnotationPresent(ZenCodeGlobals.Global.class) || !Modifier.isPublic(((Field)accessibleObject).getModifiers()) || !Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Class> getZenClassMap() {
        return ImmutableMap.copyOf(ZEN_CLASS_MAP);
    }

    public static List<Class> getClassesInPackage(String name) {
        return ZEN_CLASS_MAP.keySet().stream().filter(key -> key.startsWith(name)).map(ZEN_CLASS_MAP::get).collect(Collectors.toList());
    }

    public static Set<String> getRootPackages() {
        return ZEN_CLASS_MAP.keySet().stream().map(s -> s.split("\\.")[0]).collect(Collectors.toSet());
    }

    public static List<Class> getZenGlobals() {
        return ImmutableList.copyOf(ZEN_GLOBALS);
    }

    public static List<Method> getBracketResolvers() {
        return ImmutableList.copyOf(BRACKET_RESOLVERS);
    }

    public static Map<String, Supplier<Collection<String>>> getBracketDumpers() {
        return ImmutableMap.copyOf(BRACKET_DUMPERS);
    }

    public static List<IPreprocessor> getPreprocessors() {
        return PREPROCESSORS;
    }

    public static Map<String, List<Class>> getExpansions() {
        return EXPANSIONS;
    }

    private static /* synthetic */ Collection lambda$null$5(Supplier dumpFun1, Supplier dumpFun2) {
        Collection strings1 = (Collection)dumpFun1.get();
        Collection strings2 = (Collection)dumpFun2.get();
        HashSet result = new HashSet(strings1.size() + strings2.size());
        result.addAll(strings1);
        result.addAll(strings2);
        return result;
    }
}

