/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import java.io.File;
import org.apache.commons.io.FilenameUtils;

public enum FilenameFilter implements java.io.FilenameFilter
{
    XML("xml"),
    JSON("json"),
    CFG("cfg"),
    CONF("conf"),
    ZENSCRIPT("zs"),
    ZIP("zip"),
    TXT("txt"),
    PNG("png"),
    JAR("jar"),
    EXECUTABLE("exe"),
    GITIGNORE("gitignore"),
    JAVA("java"),
    GZIP("gzip"),
    LOG("log"),
    DAT("dat"),
    OBJ("obj"),
    CLASS("class"),
    ROADWORKS_SCRIPT("rs"),
    ROADWORKS_GUI("rgui"),
    ROADWORKS_STYLING("rstyle"),
    ROADWORKS_PLUGIN("plugin");

    private String[] extensions;

    private FilenameFilter(String ... suffix) {
        this.extensions = suffix;
    }

    public static boolean isKnown(File dir, String name) {
        for (FilenameFilter filter : FilenameFilter.values()) {
            if (!filter.accept(dir, name)) continue;
            return true;
        }
        return false;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean accept(File dir, String name) {
        return FilenameUtils.isExtension((String)name, (String[])this.extensions);
    }
}

