/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.reward;

import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardGiver;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;

public class RewardManager {
    private static RewardManager INSTANCE = new RewardManager();
    private HashMap<UUID, RewardGiver> rewards = new HashMap();

    private RewardManager() {
    }

    public static RewardManager get() {
        return INSTANCE;
    }

    public RewardGiver getGiver(UUID uuid, String name) {
        return this.rewards.computeIfAbsent(uuid, uuid1 -> new RewardGiver(uuid, name));
    }

    public HashMap<UUID, RewardGiver> getRewards() {
        return this.rewards;
    }

    public List<ResourceLocation> collectRewardsResourceLocations(UUID uuid) {
        return this.rewards.values().stream().map(rewardGiver -> rewardGiver.collectRewardsResourceLocations(uuid)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Reward getReward(ResourceLocation resourceLocation) {
        for (RewardGiver value : this.rewards.values()) {
            for (Reward reward : value.getRewards()) {
                if (!reward.getResourceLocation().equals((Object)resourceLocation)) continue;
                return reward;
            }
        }
        return null;
    }
}

