/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.tablet.client;

import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.modules.filter.network.PacketSyncHandItem;
import mcjty.rftoolsbase.modules.tablet.items.TabletContainer;
import mcjty.rftoolsbase.modules.tablet.items.TabletItem;
import mcjty.rftoolsbase.setup.RFToolsBaseMessages;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;

public class GuiTablet
extends GenericGuiContainer<GenericTileEntity, TabletContainer> {
    public static final int TABLET_WIDTH = 180;
    public static final int TABLET_HEIGHT = 188;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsbase", "textures/gui/tablet.png");
    private ToggleButton[] buttons;

    public GuiTablet(TabletContainer container, PlayerInventory inventory) {
        super((ModBase)RFToolsBase.instance, null, (Container)container, inventory, ManualHelper.create("rftoolsbase:tools/tablet"));
        this.field_146999_f = 180;
        this.field_147000_g = 188;
    }

    public void init() {
        super.init();
        Panel toplevel = (Panel)Widgets.positional().background(iconLocation);
        this.buttons = new ToggleButton[6];
        for (int i = 0; i < 6; ++i) {
            int finalI = i;
            this.buttons[i] = ((ToggleButton)new ToggleButton().hint(14 + i * 23, 32, 19, 8)).event(() -> this.setActive(finalI));
            toplevel.children(new Widget[]{this.buttons[i]});
        }
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void updateActiveButton(int current) {
        for (int i = 0; i < 6; ++i) {
            this.buttons[i].pressed(i == current);
        }
    }

    private Hand getHand() {
        if (this.minecraft.field_71439_g == null || this.minecraft.field_71439_g.func_184600_cs() == null) {
            return Hand.MAIN_HAND;
        }
        return this.minecraft.field_71439_g.func_184600_cs();
    }

    protected void func_146979_b(int i, int i2) {
        super.func_146979_b(i, i2);
        ItemStack heldItem = this.minecraft.field_71439_g.func_184586_b(this.getHand());
        this.updateActiveButton(TabletItem.getCurrentSlot(heldItem));
    }

    private void setActive(int i) {
        ItemStack heldItem = this.minecraft.field_71439_g.func_184586_b(this.getHand());
        TabletItem.setCurrentSlot((PlayerEntity)this.minecraft.field_71439_g, heldItem, i);
        this.updateActiveButton(i);
        this.syncStack();
    }

    private void syncStack() {
        RFToolsBaseMessages.INSTANCE.sendToServer((Object)new PacketSyncHandItem((PlayerEntity)this.minecraft.field_71439_g));
    }
}

