/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.registry.sapling;

import com.davenonymous.bonsaitrees2.block.ModObjects;
import com.davenonymous.bonsaitrees2.registry.sapling.SaplingDrop;
import com.davenonymous.libnonymous.utils.GsonHelper;
import com.davenonymous.libnonymous.utils.RecipeData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class SaplingInfo
extends RecipeData {
    private final ResourceLocation id;
    public Ingredient ingredient;
    public int baseTicks;
    public ItemStack sapling;
    public ArrayList<SaplingDrop> drops;
    public Set<String> tags;

    public SaplingInfo(ResourceLocation id, Ingredient ingredient, int baseTicks) {
        this.id = id;
        this.ingredient = ingredient;
        this.baseTicks = baseTicks;
        this.drops = new ArrayList();
        this.tags = new HashSet<String>();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModObjects.saplingRecipeSerializer;
    }

    public IRecipeType<?> func_222127_g() {
        return ModObjects.saplingRecipeType;
    }

    public int getRequiredTicks() {
        return this.baseTicks;
    }

    public void addDrop(SaplingDrop drop) {
        this.drops.add(drop);
        this.drops.sort((a, b) -> (int)(b.chance * 1000.0f) - (int)(a.chance * 1000.0f));
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public boolean isValidTag(String tag) {
        return this.tags.contains(tag);
    }

    public List<ItemStack> getRandomizedDrops(Random rand) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (SaplingDrop drop : this.drops) {
            ItemStack dropStack = drop.getRandomDrop(rand);
            if (dropStack.func_190926_b()) continue;
            result.add(dropStack);
        }
        return result;
    }

    public String serializePretty() {
        JsonObject result = new JsonObject();
        result.addProperty("type", "bonsaitrees2:sapling");
        JsonObject saplingObj = new JsonObject();
        saplingObj.addProperty("item", this.sapling.func_77973_b().getRegistryName().toString());
        result.add("sapling", (JsonElement)saplingObj);
        JsonArray drops = new JsonArray();
        for (SaplingDrop drop : this.drops) {
            JsonObject itemObj = new JsonObject();
            itemObj.addProperty("item", drop.resultStack.func_77973_b().getRegistryName().toString());
            JsonObject dropObj = new JsonObject();
            dropObj.add("result", (JsonElement)itemObj);
            dropObj.addProperty("rolls", (Number)drop.rolls);
            dropObj.addProperty("chance", (Number)Float.valueOf(drop.chance / 100.0f));
            drops.add((JsonElement)dropObj);
        }
        result.add("drops", (JsonElement)drops);
        JsonArray soilTags = new JsonArray();
        this.tags.forEach(arg_0 -> ((JsonArray)soilTags).add(arg_0));
        result.add("compatibleSoilTags", (JsonElement)soilTags);
        return GsonHelper.GSON.toJson((JsonElement)result);
    }
}

