/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.block;

import com.davenonymous.bonsaitrees2.api.IBonsaiCuttingTool;
import com.davenonymous.bonsaitrees2.block.BonsaiPotTileEntity;
import com.davenonymous.bonsaitrees2.block.HoppingBonsaiPotTileEntity;
import com.davenonymous.bonsaitrees2.block.ModObjects;
import com.davenonymous.bonsaitrees2.compat.top.ITopInfoProvider;
import com.davenonymous.bonsaitrees2.config.Config;
import com.davenonymous.bonsaitrees2.misc.PotColorizer;
import com.davenonymous.bonsaitrees2.registry.SoilCompatibility;
import com.davenonymous.bonsaitrees2.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees2.registry.soil.SoilInfo;
import com.davenonymous.bonsaitrees2.util.Logz;
import com.davenonymous.libnonymous.base.BaseBlock;
import com.davenonymous.libnonymous.misc.ColorProperty;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;

public class BonsaiPotBlock
extends BaseBlock
implements IGrowable,
IWaterLoggable,
ITopInfoProvider {
    private final Random rand = new Random();
    private final VoxelShape shape = VoxelShapes.func_197873_a((double)0.065f, (double)0.005f, (double)0.065f, (double)0.935f, (double)0.185f, (double)0.935f);
    boolean hopping;

    public BonsaiPotBlock(boolean hopping) {
        super(Block.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_151667_k).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).harvestLevel(0).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)ColorProperty.COLOR, (Comparable)Integer.valueOf(8))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.FALSE));
        this.hopping = hopping;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (this.hopping) {
            return new HoppingBonsaiPotTileEntity();
        }
        return new BonsaiPotTileEntity();
    }

    public static BonsaiPotTileEntity getOwnTile(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BonsaiPotTileEntity)) {
            return null;
        }
        return (BonsaiPotTileEntity)te;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BonsaiPotTileEntity tile = BonsaiPotBlock.getOwnTile((IBlockReader)worldIn, pos);
        if (tile == null) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            return;
        }
        if (tile.hasSapling()) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tile.getSaplingStack());
        }
        if (tile.hasSoil()) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tile.getSoilStack());
        }
        if (tile.hasSoil() && tile.hasSapling() && tile.getProgress() >= 1.0) {
            tile.dropLoot();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean playerHasShovel;
        DyeColor color;
        if (player.func_213453_ef()) {
            return ActionResultType.FAIL;
        }
        if (!(world.func_175625_s(pos) instanceof BonsaiPotTileEntity)) {
            return ActionResultType.FAIL;
        }
        ItemStack playerStack = player.func_184586_b(Hand.MAIN_HAND);
        if (playerStack.func_190926_b()) {
            playerStack = player.func_184586_b(Hand.OFF_HAND);
        }
        if (playerStack.func_190926_b()) {
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BonsaiPotTileEntity pot = (BonsaiPotTileEntity)world.func_175625_s(pos);
        SoilInfo soil = ModObjects.soilRecipeHelper.getSoilForItem(world, playerStack);
        if (soil != null && !pot.hasSoil()) {
            if (player.func_184812_l_()) {
                ItemStack soilStack = playerStack.func_77946_l();
                soilStack.func_190920_e(1);
                pot.setSoil(soilStack);
            } else {
                pot.setSoil(playerStack.func_77979_a(1));
            }
            return ActionResultType.SUCCESS;
        }
        SaplingInfo sapling = ModObjects.saplingRecipeHelper.getSaplingInfoForItem(world, playerStack);
        if (sapling != null && !pot.hasSapling()) {
            if (!pot.hasSoil()) {
                SoilInfo randomSoil = (SoilInfo)ModObjects.soilRecipeHelper.getRandomRecipe(world.func_199532_z(), world.field_73012_v);
                if (randomSoil != null) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("hint.bonsaitrees.pot_has_no_soil", new Object[]{randomSoil.ingredient.func_193365_a()[0].func_200301_q()}), true);
                } else {
                    Logz.warn("There is no soil available. Please check the config and logs for errors!", new Object[0]);
                }
                return ActionResultType.SUCCESS;
            }
            SoilInfo potSoil = ModObjects.soilRecipeHelper.getSoilForItem(world, pot.getSoilStack());
            if (!SoilCompatibility.INSTANCE.canTreeGrowOnSoil(sapling, potSoil)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("hint.bonsaitrees.incompatible_soil", new Object[0]), true);
                return ActionResultType.SUCCESS;
            }
            if (player.func_184812_l_()) {
                ItemStack saplingStack = playerStack.func_77946_l();
                saplingStack.func_190920_e(1);
                pot.setSapling(saplingStack);
            } else {
                pot.setSapling(playerStack.func_77979_a(1));
            }
            return ActionResultType.SUCCESS;
        }
        DyeColor blockColor = DyeColor.func_196056_a((int)((Integer)state.func_177229_b((IProperty)ColorProperty.COLOR)));
        if (Tags.Items.DYES.func_199685_a_((Object)playerStack.func_77973_b()) && (color = DyeColor.getColor((ItemStack)playerStack)) != null) {
            if (blockColor == color) {
                return ActionResultType.SUCCESS;
            }
            if (!player.func_184812_l_() && !((Boolean)Config.NO_DYE_COST.get()).booleanValue()) {
                playerStack.func_77979_a(1);
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)ColorProperty.COLOR, (Comparable)Integer.valueOf(color.func_196059_a())), 2);
            return ActionResultType.SUCCESS;
        }
        boolean playerHasAxe = this.canCutBonsaiTree(playerStack, player);
        if (playerHasAxe) {
            boolean inWorkingCondition;
            if (!pot.hasSapling()) {
                return ActionResultType.FAIL;
            }
            boolean bl = inWorkingCondition = !playerStack.func_77984_f() || playerStack.func_77952_i() + 1 < playerStack.func_77958_k();
            if (pot.getProgress() >= 1.0 && inWorkingCondition) {
                pot.dropLoot();
                pot.setSapling(pot.saplingStack);
                playerStack.func_96631_a(1, this.rand, (ServerPlayerEntity)player);
                return ActionResultType.SUCCESS;
            }
            if (pot.growTicks >= 20 && pot.getProgress() <= 0.75) {
                pot.dropSapling();
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.SUCCESS;
        }
        boolean bl = playerHasShovel = playerStack.func_77973_b().getHarvestLevel(playerStack, ToolType.SHOVEL, player, Blocks.field_150346_d.func_176223_P()) != -1;
        if (playerHasShovel) {
            if (pot.hasSapling()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("hint.bonsaitrees.can_not_remove_soil_with_sapling", new Object[0]), true);
                return ActionResultType.FAIL;
            }
            if (!pot.hasSoil()) {
                return ActionResultType.FAIL;
            }
            pot.dropSoil();
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, handIn, hit);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("bonsaitrees2:color")) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)ColorProperty.COLOR, (Comparable)Integer.valueOf(PotColorizer.DEFAULT_COLOR.func_196059_a())), 2);
            return;
        }
        int color = tag.func_74762_e("bonsaitrees2:color");
        world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)ColorProperty.COLOR, (Comparable)Integer.valueOf(color)), 2);
    }

    private boolean canCutBonsaiTree(ItemStack stack, PlayerEntity player) {
        if (stack.func_77973_b().getHarvestLevel(stack, ToolType.AXE, player, Blocks.field_196662_n.func_176223_P()) != -1) {
            return true;
        }
        if (stack.func_77973_b() instanceof IBonsaiCuttingTool) {
            return true;
        }
        String regName = stack.func_77973_b().getRegistryName().toString();
        return ((List)Config.ADDITIONAL_CUTTING_TOOLS.get()).contains(regName);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{ColorProperty.COLOR});
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208198_y});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) == false;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return this.shape;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        if (!(world.func_175625_s(pos) instanceof BonsaiPotTileEntity)) {
            return false;
        }
        BonsaiPotTileEntity tile = (BonsaiPotTileEntity)world.func_175625_s(pos);
        return tile.isGrowing();
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        if (!(world.func_175625_s(pos) instanceof BonsaiPotTileEntity)) {
            return false;
        }
        BonsaiPotTileEntity tile = (BonsaiPotTileEntity)world.func_175625_s(pos);
        if (!tile.isGrowing()) {
            return false;
        }
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        if (!(world.func_175625_s(pos) instanceof BonsaiPotTileEntity)) {
            return;
        }
        BonsaiPotTileEntity tile = (BonsaiPotTileEntity)world.func_175625_s(pos);
        tile.boostProgress();
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        if (!(world.func_175625_s(data.getPos()) instanceof BonsaiPotTileEntity)) {
            return;
        }
        BonsaiPotTileEntity teBonsai = (BonsaiPotTileEntity)world.func_175625_s(data.getPos());
        if (teBonsai.hasSapling()) {
            probeInfo.horizontal().item(teBonsai.saplingStack).itemLabel(teBonsai.saplingStack);
        }
        if (teBonsai.hasSoil()) {
            probeInfo.horizontal().item(teBonsai.soilStack).itemLabel(teBonsai.soilStack);
        }
        if (teBonsai.hasSapling()) {
            probeInfo.progress((int)(teBonsai.getProgress() * 100.0), 100, probeInfo.defaultProgressStyle().suffix("%").filledColor(-12277180).alternateFilledColor(-12277180).backgroundColor(-8165037));
        }
    }
}

