/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class ExceptionEditor
extends AbstractParameterEditor {
    private ChoiceLabel label;

    private static ExceptionType parseFacingSafe(String t) {
        if ("*".equals(t)) {
            return null;
        }
        return ExceptionType.getExceptionForCode(t);
    }

    @Override
    public void build(Minecraft mc, Screen gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = Widgets.horizontal();
        this.label = (ChoiceLabel)new ChoiceLabel().desiredWidth(160);
        this.label.choices(new String[]{"*"});
        for (ExceptionType exception : ExceptionType.values()) {
            this.label.choices(new String[]{exception.getCode()});
        }
        this.label.event(newChoice -> callback.valueChanged(this.readValue()));
        constantPanel.children(new Widget[]{this.label});
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_EXCEPTION);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant((Object)((Object)ExceptionEditor.parseFacingSafe(this.label.getCurrentChoice())));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.label.choice("*");
        } else {
            ExceptionType exception = (ExceptionType)((Object)value.getValue());
            this.label.choice(exception.getCode());
        }
    }
}

