/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.furnator;

import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import owmii.lib.block.TileBase;
import owmii.lib.util.IVariant;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.furnator.FurnatorBlock;
import owmii.powah.config.Configs;

public class FurnatorTile
extends TileBase.EnergyProvider<Tier, FurnatorBlock> {
    public FurnatorTile(Tier variant) {
        super(ITiles.FURNATOR, (IVariant)variant);
        this.inv.add(1);
    }

    public FurnatorTile() {
        this(Tier.STARTER);
    }

    protected void generate(World world) {
        ItemStack fuelStack = this.inv.getStackInSlot(this.builtInSlots());
        if (this.nextBuff <= 0L && !fuelStack.func_190926_b()) {
            this.buffer = (long)ForgeHooks.getBurnTime((ItemStack)fuelStack) * (Long)Configs.GENERAL.fuelTicks.get();
            if (this.buffer <= 0L) {
                return;
            }
            this.nextBuff = this.buffer;
            if (fuelStack.hasContainerItem()) {
                this.inv.setStack(1, fuelStack.getContainerItem());
            } else {
                fuelStack.func_190918_g(1);
            }
        }
    }

    public boolean hasEnergyBuffer() {
        return true;
    }

    public boolean keepEnergy() {
        return true;
    }

    public int getChargingSlots() {
        return 1;
    }

    public boolean canInsert(int index, ItemStack stack) {
        return index == this.builtInSlots() ? ForgeHooks.getBurnTime((ItemStack)stack) > 0 : super.canInsert(index, stack);
    }
}

