/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class LockerWorldData
extends WorldSavedData
implements Supplier<LockerWorldData> {
    public Map<String, BlockPos> lockers = new HashMap<String, BlockPos>();
    public static final String ID = "lockers";

    public LockerWorldData() {
        this(ID);
    }

    public LockerWorldData(String name) {
        super(name);
    }

    public void func_76184_a(CompoundNBT compound) {
        this.lockers = new HashMap<String, BlockPos>();
        ListNBT lockerList = compound.func_150295_c("Lockers", 10);
        for (int i = 0; i < lockerList.size(); ++i) {
            CompoundNBT lockerTag = (CompoundNBT)lockerList.get(i);
            String lockerID = lockerTag.func_74779_i("ID");
            BlockPos pos = new BlockPos(lockerTag.func_74762_e("X"), lockerTag.func_74762_e("Y"), lockerTag.func_74762_e("Z"));
            this.lockers.put(lockerID, pos);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT lockerList = new ListNBT();
        for (String lockerID : this.lockers.keySet()) {
            CompoundNBT lockerTag = new CompoundNBT();
            lockerTag.func_74778_a("ID", lockerID);
            lockerTag.func_74768_a("X", this.lockers.get(lockerID).func_177958_n());
            lockerTag.func_74768_a("Y", this.lockers.get(lockerID).func_177956_o());
            lockerTag.func_74768_a("Z", this.lockers.get(lockerID).func_177952_p());
            lockerList.add((Object)lockerTag);
        }
        compound.func_218657_a("Lockers", (INBT)lockerList);
        return compound;
    }

    public String createLocker(String lockerID, BlockPos pos) {
        int suffixIndex = 2;
        String fixedLockerID = lockerID;
        while (this.lockers.containsKey(fixedLockerID) && fixedLockerID.length() < 12) {
            fixedLockerID = lockerID + suffixIndex;
            ++suffixIndex;
        }
        if (fixedLockerID.length() >= 12) {
            return "";
        }
        this.lockers.put(fixedLockerID, pos);
        this.func_76185_a();
        return fixedLockerID;
    }

    public void removeLocker(String lockerID) {
        this.lockers.remove(lockerID);
        this.func_76185_a();
    }

    public Map<String, BlockPos> getLockers() {
        return this.lockers;
    }

    @Override
    public LockerWorldData get() {
        return this;
    }

    @Nullable
    public static LockerWorldData get(World world) {
        if (!world.func_201670_d()) {
            return LockerWorldData.get(world.func_73046_m().func_71218_a(world.func_201675_m().func_186058_p()));
        }
        return null;
    }

    public static LockerWorldData get(ServerWorld world) {
        DimensionSavedDataManager data = world.func_217481_x();
        LockerWorldData saver = (LockerWorldData)data.func_215752_a(() -> new LockerWorldData(), ID);
        if (saver == null) {
            saver = new LockerWorldData();
            data.func_215757_a((WorldSavedData)saver);
        }
        return saver;
    }
}

