package net.minecraftforge.lex.sortfix;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.discovery.ASMDataTable.ASMData;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import net.minecraft.launchwrapper.IClassTransformer;

public class Transformer implements IClassTransformer
{
	@Override
	public byte[] transform(String name, String deobf, byte[] data)
	{
		if (!name.startsWith("cpw.mods.fml.common.discovery.ModDiscoverer"))
		{
			return data;
		}
		
		System.out.println("=======================Sorter Transformer Running===================");
		
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(data);
        classReader.accept(classNode, 0);

        FMLRelaunchLog.info("Sort Fixer: Processing class");
        for (MethodNode method : classNode.methods)
        {
        	if (!method.name.equals("findModDirMods"))
        	{
        		continue;
        	}
        	FMLRelaunchLog.info("  Method Located:");
        	for (int x = 0; x < method.instructions.size(); x++)
        	{
        		AbstractInsnNode isn = method.instructions.get(x);
        		if (isn instanceof MethodInsnNode)
        		{
        			MethodInsnNode call = (MethodInsnNode)isn;
        			if (call.name.equals("sort") &&
        		        call.desc.equals("([Ljava/lang/Object;)V") &&
        		        call.owner.equals("java/util/Arrays"))
        			{
        				call.owner = "net/minecraftforge/lex/sortfix/CorePlugin";
		        		FMLRelaunchLog.info(call.name + " " + call.desc + " " + call.owner);
        			}
        		}
        	}

        }

        ClassWriter writer = new ClassWriter(ClassWriter.COMPUTE_MAXS);
        classNode.accept(writer);
        return writer.toByteArray();
	}
}