package net.minecraftforge.lex.sortfix;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;

import net.minecraft.launchwrapper.IClassTransformer;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;

public class CorePlugin implements IFMLLoadingPlugin
{
	@Override public String[] getLibraryRequestClass(){ return null; }
	@Override
	public String[] getASMTransformerClass()
	{
		return new String[]{ "net.minecraftforge.lex.sortfix.Transformer" };
	}

	@Override public String getModContainerClass(){ return null; }
	@Override public String getSetupClass() { return null; }
	@Override public void injectData(Map<String, Object> data){}

	public static void sort(Object[] a) 
	{
		File[] files = (File[])a;
		Arrays.sort(files, new Comparator<File>()
		{
			@Override
			public int compare(File o1, File o2)
			{
				return o1.getAbsolutePath().toLowerCase(Locale.US).compareTo(o2.getAbsolutePath().toLowerCase(Locale.US));
			}
		});
	}
}
