/*
 * Decompiled with CFR 0.152.
 */
package worldcore.asm;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDummyContainer;
import org.lwjgl.opengl.GL11;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import worldcore.interfaces.IWCFog;

public class WCFogDistance
implements IClassTransformer {
    private static int fogX;
    private static int fogZ;
    private static boolean fogInit;
    private static float storedFinalFogCloseness;

    public byte[] transform(String name, String newname, byte[] bytes) {
        if (name.equals("net.minecraft.client.renderer.EntityRenderer")) {
            return WCFogDistance.patchEntityRenderer(newname, bytes, false);
        }
        if (name.equals("bfe")) {
            return WCFogDistance.patchEntityRenderer(newname, bytes, true);
        }
        return bytes;
    }

    public static byte[] patchEntityRenderer(String name, byte[] bytes, boolean obfuscated) {
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        boolean found = false;
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode.name.equals("setupFog") || methodNode.name.equals("a")) {
                for (AbstractInsnNode insnNode : methodNode.instructions) {
                    if (!(insnNode instanceof FieldInsnNode)) continue;
                    FieldInsnNode node = (FieldInsnNode)insnNode;
                    if (!node.name.equals("mc") && !node.name.equals("q") || !(node.getNext() instanceof FieldInsnNode)) continue;
                    FieldInsnNode worldNode = (FieldInsnNode)node.getNext();
                    if (!worldNode.name.equals("theWorld") && !worldNode.name.equals("f") || !(worldNode.getNext() instanceof FieldInsnNode)) continue;
                    FieldInsnNode providerNode = (FieldInsnNode)worldNode.getNext();
                    if (!providerNode.name.equals("provider") && !providerNode.name.equals("t") || providerNode.getNext().getOpcode() != 25) continue;
                    InsnList toInject = new InsnList();
                    toInject.add((AbstractInsnNode)new VarInsnNode(25, 3));
                    toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
                    toInject.add((AbstractInsnNode)new VarInsnNode(23, 6));
                    if (obfuscated) {
                        toInject.add((AbstractInsnNode)new MethodInsnNode(184, "worldcore/asm/WCFogDistance", "setBiomeFogDistance", "(Lnn;IF)V"));
                    } else {
                        toInject.add((AbstractInsnNode)new MethodInsnNode(184, "worldcore/asm/WCFogDistance", "setBiomeFogDistance", "(Lnet/minecraft/entity/Entity;IF)V"));
                    }
                    methodNode.instructions.insertBefore(node.getPrevious(), toInject);
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            throw new RuntimeException("setupFog transformer failed");
        }
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static void setBiomeFogDistance(Entity entity, int distance, float farPlaneDistance) {
        World world = entity.field_70170_p;
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        if (playerX == fogX && playerZ == fogZ && fogInit) {
            if (distance < 0) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)(farPlaneDistance * 0.8f));
            } else {
                float fogDistance = Math.min(farPlaneDistance, 256.0f * storedFinalFogCloseness);
                GL11.glFogf((int)2915, (float)(fogDistance * 0.25f));
                GL11.glFogf((int)2916, (float)fogDistance);
            }
            return;
        }
        fogInit = true;
        int blenddistance = Minecraft.func_71410_x().field_71474_y.field_74347_j ? ForgeDummyContainer.blendRanges[Minecraft.func_71410_x().field_71474_y.field_74339_e] : 0;
        int divider = 0;
        float fogCloseness = 0.0f;
        for (int x = -blenddistance; x <= blenddistance; ++x) {
            for (int z = -blenddistance; z <= blenddistance; ++z) {
                BiomeGenBase biome = world.func_72807_a(playerX + x, playerZ + z);
                fogCloseness = biome instanceof IWCFog ? (fogCloseness += ((IWCFog)biome).getFogCloseness()) : (fogCloseness += 1.0f);
                ++divider;
            }
        }
        float finalFogCloseness = fogCloseness / (float)divider;
        fogX = playerX;
        fogZ = playerZ;
        storedFinalFogCloseness = finalFogCloseness;
        if (distance < 0) {
            GL11.glFogf((int)2915, (float)0.0f);
            GL11.glFogf((int)2916, (float)(farPlaneDistance * 0.8f));
        } else {
            float fogDistance = Math.min(farPlaneDistance, 256.0f * finalFogCloseness);
            GL11.glFogf((int)2915, (float)(fogDistance * 0.25f));
            GL11.glFogf((int)2916, (float)fogDistance);
        }
    }
}

