/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.modifiers;

import iguanaman.iguanatweakstconstruct.IguanaConfig;
import iguanaman.iguanatweakstconstruct.IguanaLevelingLogic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Pickaxe;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMod;

public class IguanaModRedstone
extends ToolMod {
    String tooltipName = "\u00a74Haste";
    int increase;
    int max;

    public IguanaModRedstone(ItemStack[] items, int effect, int inc) {
        super(items, effect, "Redstone");
        this.increase = inc;
        this.max = 50;
    }

    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        return this.canModify(tool, input, false);
    }

    public boolean canModify(ItemStack tool, ItemStack[] input, boolean auto) {
        ToolCore toolItem = (ToolCore)tool.func_77973_b();
        if (!this.validType(toolItem)) {
            return false;
        }
        if (auto) {
            return true;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74764_b(this.key)) {
            return tags.func_74762_e("Modifiers") > 0;
        }
        int[] keyPair = tags.func_74759_k(this.key);
        if (keyPair[0] + this.increase <= keyPair[1]) {
            return true;
        }
        if (keyPair[0] == keyPair[1]) {
            return tags.func_74762_e("Modifiers") > 0;
        }
        return false;
    }

    public void modify(ItemStack[] input, ItemStack tool) {
        String tip;
        int modifiers;
        int[] keyPair;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74764_b(this.key)) {
            keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + this.increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.func_74783_a(this.key, keyPair);
                modifiers = tags.func_74762_e("Modifiers");
                tags.func_74768_a("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + this.increase;
                tags.func_74783_a(this.key, keyPair);
            }
            this.updateModTag(tool, keyPair);
        } else {
            modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --modifiers);
            String modName = "\u00a74Redstone (" + this.increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            keyPair = new int[]{this.increase, this.max, tooltipIndex};
            tags.func_74783_a(this.key, keyPair);
        }
        float xpPercentage = -1.0f;
        if (tags.func_74764_b("ToolEXP")) {
            int requiredXp = IguanaLevelingLogic.getRequiredXp(tool, tags, false);
            long currentXp = tags.func_74763_f("ToolEXP");
            xpPercentage = (float)currentXp / (float)requiredXp;
        }
        float headXpPercentage = -1.0f;
        if (tags.func_74764_b("HeadEXP")) {
            int requiredXp = IguanaLevelingLogic.getRequiredXp(tool, tags, true);
            long currentXp = tags.func_74763_f("HeadEXP");
            headXpPercentage = (float)currentXp / (float)requiredXp;
        }
        int miningSpeed = tags.func_74762_e("MiningSpeed");
        tags.func_74768_a("MiningSpeed", miningSpeed += this.increase * 4);
        if (tags.func_74764_b("MiningSpeed2")) {
            int miningSpeed2 = tags.func_74762_e("MiningSpeed2");
            tags.func_74768_a("MiningSpeed2", miningSpeed2 += this.increase * 4);
        }
        if (tags.func_74764_b("DrawSpeed")) {
            int baseDrawSpeed = tags.func_74762_e("BaseDrawSpeed");
            int drawSpeed = (int)((float)baseDrawSpeed - 0.1f * (float)baseDrawSpeed * ((float)keyPair[0] / 50.0f));
            tags.func_74768_a("DrawSpeed", drawSpeed);
        }
        if (tags.func_74764_b("ToolEXP")) {
            int newRequiredXp = IguanaLevelingLogic.getRequiredXp(tool, tags, false);
            long newXp = Math.round((float)newRequiredXp * xpPercentage);
            tags.func_74772_a("ToolEXP", newXp);
        }
        if (tags.func_74764_b("HeadEXP")) {
            int newRequiredXp = IguanaLevelingLogic.getRequiredXp(tool, tags, true);
            long newXp = Math.round((float)newRequiredXp * headXpPercentage);
            tags.func_74772_a("HeadEXP", newXp);
        }
        ArrayList<String> tips = new ArrayList<String>();
        ArrayList<String> modifierTips = new ArrayList<String>();
        if (IguanaConfig.showTooltipXP) {
            int level = tags.func_74762_e("ToolLevel");
            if (level <= 5) {
                tips.add(IguanaLevelingLogic.getXpString(tool, false, false));
                modifierTips.add("");
            }
            if (IguanaConfig.levelingPickaxeBoost) {
                int hLevel;
                int n = hLevel = tags.func_74764_b("HarvestLevel") ? (hLevel = tags.func_74762_e("HarvestLevel")) : -1;
                if (hLevel >= TConstructRegistry.getMaterial((String)"Copper").harvestLevel() && hLevel < TConstructRegistry.getMaterial((String)"Manyullyn").harvestLevel() && !tags.func_74764_b("HarvestLevelModified") && (tool.func_77973_b() instanceof Pickaxe || tool.func_77973_b() instanceof Hammer)) {
                    tips.add(IguanaLevelingLogic.getXpString(tool, false, true));
                    modifierTips.add("");
                }
            }
        }
        int tipNum = 0;
        while (tags.func_74764_b(tip = "Tooltip" + ++tipNum)) {
            String tipString = tags.func_74779_i(tip);
            if (!(tipString.startsWith("XP:") || tipString.startsWith("Head XP:") || tipString.startsWith("Boost XP:"))) {
                tips.add(tipString);
                modifierTips.add(tags.func_74779_i("ModifierTip" + tipNum));
            }
            tags.func_82580_o(tip);
            tags.func_82580_o("ModifierTip" + tipNum);
        }
        for (int i = 1; i <= tips.size(); ++i) {
            if (tips.get(i - 1) == null) continue;
            tags.func_74778_a("Tooltip" + i, (String)tips.get(i - 1));
            if (modifierTips.get(i - 1) != null) {
                tags.func_74778_a("ModifierTip" + i, (String)modifierTips.get(i - 1));
                continue;
            }
            tags.func_74778_a("ModifierTip" + i, "");
        }
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a74Redstone (" + keys[0] + "/" + keys[1] + ")";
        tags.func_74778_a(tip, modName);
    }

    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.toolCategories());
        return list.contains("harvest") || list.contains("utility") || list.contains("bow");
    }
}

