/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.modifiers;

import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Pickaxe;
import tconstruct.library.tools.ToolMod;

public class IguanaModHeads
extends ToolMod {
    String tooltipName;
    String color;
    int miningLevel;

    public IguanaModHeads(ItemStack[] items, int effect, int level, String k, String tip, String c) {
        super(items, effect, k);
        this.miningLevel = level;
        this.tooltipName = tip;
        this.color = c;
    }

    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74764_b("MobHead")) {
            return false;
        }
        if (tool.func_77973_b() instanceof Pickaxe || tool.func_77973_b() instanceof Hammer) {
            if (tags.func_74764_b("HarvestLevelModified")) {
                return false;
            }
            int mLevel = tags.func_74762_e("HarvestLevel");
            if (mLevel > 1 && mLevel < this.miningLevel) {
                return true;
            }
        }
        return false;
    }

    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        tags.func_74757_a("MobHead", true);
        tags.func_74757_a(this.key, true);
        if (tool.func_77973_b() instanceof Pickaxe) {
            tags.func_74768_a("HarvestLevel", tags.func_74762_e("HarvestLevel") + 1);
            tags.func_74757_a("HarvestLevelModified", true);
            this.overwriteToolTip(tool);
        }
        String modTip = this.color + this.key;
        this.addToolTip(tool, this.tooltipName, modTip);
    }

    public void overwriteToolTip(ItemStack tool) {
        String tip;
        NBTTagCompound toolTag = tool.func_77978_p().func_74775_l("InfiTool");
        ArrayList<String> tips = new ArrayList<String>();
        ArrayList<String> modifierTips = new ArrayList<String>();
        tips.add("Mining Level: " + IguanaTweaksTConstruct.getHarvestLevelName(toolTag.func_74762_e("HarvestLevel")));
        modifierTips.add("");
        int tipNum = 0;
        while (toolTag.func_74764_b(tip = "Tooltip" + ++tipNum)) {
            String tipString = toolTag.func_74779_i(tip);
            if (!(tipString.startsWith("Head XP:") || tipString.startsWith("Boost XP:") || tipString.startsWith("Mining Level:") || tipString.contains("Requires boost"))) {
                tips.add(toolTag.func_74779_i(tip));
                modifierTips.add(toolTag.func_74779_i("ModifierTip" + tipNum));
            }
            toolTag.func_82580_o(tip);
            toolTag.func_82580_o("ModifierTip" + tipNum);
        }
        for (int i = 1; i <= tips.size(); ++i) {
            if (tips.get(i - 1) == null) continue;
            toolTag.func_74778_a("Tooltip" + i, (String)tips.get(i - 1));
            if (modifierTips.get(i - 1) != null) {
                toolTag.func_74778_a("ModifierTip" + i, (String)modifierTips.get(i - 1));
                continue;
            }
            toolTag.func_74778_a("ModifierTip" + i, "");
        }
    }
}

