/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfig;
import invtweaks.InvTweaksContainerManager;
import invtweaks.InvTweaksObfuscation;
import invtweaks.InvTweaksShortcutMapping;
import invtweaks.InvTweaksShortcutType;
import invtweaks.ShortcutSpecification;
import invtweaks.api.container.ContainerSection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class InvTweaksHandlerShortcuts
extends InvTweaksObfuscation {
    private static final Logger log = InvTweaks.log;
    private static final int DROP_SLOT = -999;
    private InvTweaksConfig config;
    private InvTweaksContainerManager container;
    private Map<Integer, Boolean> pressedKeys;
    private Map<InvTweaksShortcutType, List<InvTweaksShortcutMapping>> shortcuts;

    public InvTweaksHandlerShortcuts(Minecraft minecraft, InvTweaksConfig invTweaksConfig) {
        super(minecraft);
        this.config = invTweaksConfig;
        this.pressedKeys = new HashMap<Integer, Boolean>();
        this.shortcuts = new HashMap<InvTweaksShortcutType, List<InvTweaksShortcutMapping>>();
    }

    public void loadShortcuts() {
        Object object;
        int n;
        Object[] objectArray;
        Object[] objectArray2;
        this.pressedKeys.clear();
        this.shortcuts.clear();
        Map<String, String> map = this.config.getProperties("shortcutKey");
        for (String string : map.keySet()) {
            objectArray2 = map.get(string).split("[ ]*,[ ]*");
            objectArray = InvTweaksShortcutType.fromConfigKey(string);
            if (objectArray == null) continue;
            String[] stringArray = objectArray2;
            n = stringArray.length;
            for (object = 0; object < n; ++object) {
                String string2 = stringArray[object];
                String[] stringArray2 = string2.split("\\+");
                this.registerShortcutMapping((InvTweaksShortcutType)objectArray, new InvTweaksShortcutMapping(stringArray2));
            }
        }
        int n2 = this.getKeyBindingForwardKeyCode();
        int n3 = this.getKeyBindingBackKeyCode();
        this.registerShortcutMapping(InvTweaksShortcutType.MOVE_UP, new InvTweaksShortcutMapping(n2));
        this.registerShortcutMapping(InvTweaksShortcutType.MOVE_DOWN, new InvTweaksShortcutMapping(n3));
        objectArray = objectArray2 = (Object[])new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 79, 80, 81, 75, 76, 77, 71, 72, 73};
        int n4 = objectArray.length;
        for (n = 0; n < n4; ++n) {
            object = objectArray[n];
            this.registerShortcutMapping(InvTweaksShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT, new InvTweaksShortcutMapping((int)object));
        }
        this.pressedKeys.put(42, false);
        this.pressedKeys.put(54, false);
    }

    private void registerShortcutMapping(InvTweaksShortcutType invTweaksShortcutType, InvTweaksShortcutMapping invTweaksShortcutMapping) {
        Object object;
        if (this.shortcuts.containsKey((Object)invTweaksShortcutType)) {
            this.shortcuts.get((Object)invTweaksShortcutType).add(invTweaksShortcutMapping);
        } else {
            object = new LinkedList<InvTweaksShortcutMapping>();
            object.add(invTweaksShortcutMapping);
            this.shortcuts.put(invTweaksShortcutType, (List<InvTweaksShortcutMapping>)object);
        }
        object = invTweaksShortcutMapping.getKeyCodes().iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            this.pressedKeys.put(n, false);
        }
    }

    public void handleShortcut() {
        try {
            ShortcutConfig shortcutConfig = this.computeShortcutToTrigger();
            if (shortcutConfig != null) {
                int n = Mouse.getEventX();
                int n2 = Mouse.getEventY();
                this.runShortcut(shortcutConfig);
                Mouse.destroy();
                Mouse.create();
                Mouse.setCursorPosition((int)n, (int)n2);
            }
        }
        catch (Exception exception) {
            InvTweaks.logInGameErrorStatic("invtweaks.shortcut.error", exception);
        }
    }

    public ShortcutSpecification computeCurrentShortcut() {
        ShortcutSpecification.Action action = ShortcutSpecification.Action.MOVE;
        ShortcutSpecification.Target target = ShortcutSpecification.Target.UNSPECIFIED;
        ShortcutSpecification.Scope scope = ShortcutSpecification.Scope.ONE_STACK;
        this.updatePressedKeys();
        boolean bl = false;
        if (this.isShortcutDown(InvTweaksShortcutType.DROP) != null) {
            action = ShortcutSpecification.Action.DROP;
            bl = true;
        }
        if (action != ShortcutSpecification.Action.DROP) {
            if (this.isShortcutDown(InvTweaksShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT) != null) {
                target = ShortcutSpecification.Target.HOTBAR_SLOT;
                bl = true;
            } else if (this.isShortcutDown(InvTweaksShortcutType.MOVE_UP) != null) {
                target = ShortcutSpecification.Target.UP;
                bl = true;
            } else if (this.isShortcutDown(InvTweaksShortcutType.MOVE_DOWN) != null) {
                target = ShortcutSpecification.Target.DOWN;
                bl = true;
            }
        }
        if (this.isShortcutDown(InvTweaksShortcutType.MOVE_ALL_ITEMS) != null) {
            scope = ShortcutSpecification.Scope.ALL_ITEMS;
            bl = true;
        } else if (this.isShortcutDown(InvTweaksShortcutType.MOVE_EVERYTHING) != null) {
            scope = ShortcutSpecification.Scope.EVERYTHING;
            bl = true;
        } else if (this.isShortcutDown(InvTweaksShortcutType.MOVE_ONE_ITEM) != null) {
            scope = ShortcutSpecification.Scope.ONE_ITEM;
            bl = true;
        }
        if (bl) {
            return new ShortcutSpecification(action, target, scope);
        }
        return null;
    }

    public ShortcutConfig computeShortcutToTrigger() {
        ShortcutSpecification shortcutSpecification = this.computeCurrentShortcut();
        ShortcutConfig shortcutConfig = new ShortcutConfig();
        this.container = new InvTweaksContainerManager(this.mc);
        Slot slot = InvTweaksObfuscation.getSlotAtMousePosition((GuiContainer)this.getCurrentScreen());
        if (shortcutSpecification != null && slot != null && (slot.func_75216_d() || this.getHeldStack() != null)) {
            int n = InvTweaksHandlerShortcuts.getSlotNumber(slot);
            shortcutConfig.fromSection = this.container.getSlotSection(n);
            shortcutConfig.fromIndex = this.container.getSlotIndex(n);
            ItemStack itemStack = shortcutConfig.fromStack = slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : this.getHeldStack().func_77946_l();
            if (!slot.func_75214_a(slot.func_75211_c()) && shortcutSpecification.getScope() == ShortcutSpecification.Scope.ONE_ITEM) {
                shortcutSpecification.setScope(ShortcutSpecification.Scope.ONE_STACK);
            }
            if (shortcutConfig.fromSection != null && shortcutConfig.fromIndex != -1) {
                if (shortcutSpecification.getAction() != ShortcutSpecification.Action.DROP) {
                    if (shortcutSpecification.getTarget() == ShortcutSpecification.Target.HOTBAR_SLOT) {
                        shortcutConfig.toSection = ContainerSection.INVENTORY_HOTBAR;
                        InvTweaksShortcutMapping invTweaksShortcutMapping = this.isShortcutDown(InvTweaksShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT);
                        if (invTweaksShortcutMapping != null && !invTweaksShortcutMapping.getKeyCodes().isEmpty()) {
                            String string = Keyboard.getKeyName((int)invTweaksShortcutMapping.getKeyCodes().get(0));
                            shortcutConfig.toIndex = -1 + Integer.parseInt(string.replace("NUMPAD", ""));
                        }
                    } else {
                        Vector<ContainerSection> vector = new Vector<ContainerSection>();
                        if (this.container.hasSection(ContainerSection.CHEST)) {
                            vector.add(ContainerSection.CHEST);
                        } else if (this.container.hasSection(ContainerSection.CRAFTING_IN)) {
                            vector.add(ContainerSection.CRAFTING_IN);
                        } else if (this.container.hasSection(ContainerSection.CRAFTING_IN_PERSISTENT)) {
                            vector.add(ContainerSection.CRAFTING_IN_PERSISTENT);
                        } else if (this.container.hasSection(ContainerSection.FURNACE_IN)) {
                            vector.add(ContainerSection.FURNACE_IN);
                        } else if (this.container.hasSection(ContainerSection.BREWING_INGREDIENT)) {
                            ItemStack itemStack2 = slot.func_75211_c();
                            if (itemStack2 != null) {
                                if (itemStack2.field_77993_c == 373) {
                                    vector.add(ContainerSection.BREWING_BOTTLES);
                                } else {
                                    vector.add(ContainerSection.BREWING_INGREDIENT);
                                }
                            }
                        } else if (this.container.hasSection(ContainerSection.ENCHANTMENT)) {
                            vector.add(ContainerSection.ENCHANTMENT);
                        }
                        vector.add(ContainerSection.INVENTORY_NOT_HOTBAR);
                        vector.add(ContainerSection.INVENTORY_HOTBAR);
                        if (shortcutSpecification.getTarget() != ShortcutSpecification.Target.UNSPECIFIED) {
                            int n2 = 0;
                            if (shortcutSpecification.getTarget() == ShortcutSpecification.Target.UP) {
                                --n2;
                            } else if (shortcutSpecification.getTarget() == ShortcutSpecification.Target.DOWN) {
                                ++n2;
                            }
                            int n3 = vector.indexOf((Object)shortcutConfig.fromSection);
                            shortcutConfig.toSection = n3 != -1 ? (ContainerSection)((Object)vector.get((vector.size() + n3 + n2) % vector.size())) : ContainerSection.INVENTORY;
                        } else {
                            switch (shortcutConfig.fromSection) {
                                case CHEST: {
                                    shortcutConfig.toSection = ContainerSection.INVENTORY;
                                    break;
                                }
                                case INVENTORY_HOTBAR: {
                                    if (vector.contains((Object)ContainerSection.CHEST)) {
                                        shortcutConfig.toSection = ContainerSection.CHEST;
                                        break;
                                    }
                                    shortcutConfig.toSection = ContainerSection.INVENTORY_NOT_HOTBAR;
                                    break;
                                }
                                case CRAFTING_IN: 
                                case CRAFTING_IN_PERSISTENT: 
                                case FURNACE_IN: {
                                    shortcutConfig.toSection = ContainerSection.INVENTORY_NOT_HOTBAR;
                                    break;
                                }
                                default: {
                                    shortcutConfig.toSection = vector.contains((Object)ContainerSection.CHEST) ? ContainerSection.CHEST : ContainerSection.INVENTORY_HOTBAR;
                                }
                            }
                        }
                    }
                }
                shortcutConfig.forceEmptySlot = Mouse.isButtonDown((int)1);
                shortcutConfig.action = shortcutSpecification.getAction();
                shortcutConfig.scope = shortcutSpecification.getScope();
                return shortcutConfig;
            }
        }
        return null;
    }

    public void updatePressedKeys() {
        if (this.haveControlsChanged()) {
            this.loadShortcuts();
        }
        for (int n : this.pressedKeys.keySet()) {
            if (n > 0 && Keyboard.isKeyDown((int)n)) {
                if (this.pressedKeys.get(n).booleanValue()) continue;
                this.pressedKeys.put(n, true);
                continue;
            }
            this.pressedKeys.put(n, false);
        }
    }

    private boolean haveControlsChanged() {
        return !this.pressedKeys.containsKey(this.getKeyBindingForwardKeyCode()) || !this.pressedKeys.containsKey(this.getKeyBindingBackKeyCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runShortcut(ShortcutConfig shortcutConfig) throws TimeoutException {
        int n;
        InvTweaksHandlerShortcuts invTweaksHandlerShortcuts;
        if (this.getHeldStack() != null) {
            invTweaksHandlerShortcuts = InvTweaksObfuscation.getSlotAtMousePosition((GuiContainer)this.getCurrentScreen());
            if (invTweaksHandlerShortcuts == null) return;
            n = InvTweaksHandlerShortcuts.getSlotNumber((Slot)invTweaksHandlerShortcuts);
            this.container.putHoldItemDown(this.container.getSlotSection(n), this.container.getSlotIndex(n));
            if (this.getHeldStack() != null) {
                return;
            }
        }
        invTweaksHandlerShortcuts = this;
        synchronized (invTweaksHandlerShortcuts) {
            block27: {
                block26: {
                    if (shortcutConfig.toSection != ContainerSection.INVENTORY_HOTBAR || shortcutConfig.toIndex == -1) break block26;
                    this.container.move(shortcutConfig.fromSection, shortcutConfig.fromIndex, shortcutConfig.toSection, shortcutConfig.toIndex);
                    break block27;
                }
                block2 : switch (shortcutConfig.action) {
                    case DROP: {
                        switch (shortcutConfig.scope) {
                            case ONE_ITEM: {
                                this.container.dropSome(shortcutConfig.fromSection, shortcutConfig.fromIndex, 1);
                                break;
                            }
                            case ONE_STACK: {
                                this.container.drop(shortcutConfig.fromSection, shortcutConfig.fromIndex);
                                break;
                            }
                            case ALL_ITEMS: {
                                this.dropAll(shortcutConfig, shortcutConfig.fromStack);
                                break;
                            }
                            case EVERYTHING: {
                                this.dropAll(shortcutConfig, null);
                            }
                        }
                    }
                    case MOVE: {
                        n = this.getNextTargetIndex(shortcutConfig);
                        if (n == -1) return;
                        switch (shortcutConfig.scope) {
                            case ONE_STACK: {
                                Slot slot = this.container.getSlot(shortcutConfig.fromSection, shortcutConfig.fromIndex);
                                if (shortcutConfig.fromSection != ContainerSection.CRAFTING_OUT && shortcutConfig.toSection != ContainerSection.ENCHANTMENT) {
                                    while (slot.func_75216_d() && n != -1) {
                                        boolean bl = this.container.move(shortcutConfig.fromSection, shortcutConfig.fromIndex, shortcutConfig.toSection, n);
                                        int n2 = this.getNextTargetIndex(shortcutConfig);
                                        n = bl || shortcutConfig.action == ShortcutSpecification.Action.DROP || n2 != n ? n2 : -1;
                                    }
                                } else {
                                    this.container.move(shortcutConfig.fromSection, shortcutConfig.fromIndex, shortcutConfig.toSection, n);
                                }
                                break block27;
                            }
                            case ONE_ITEM: {
                                this.container.moveSome(shortcutConfig.fromSection, shortcutConfig.fromIndex, shortcutConfig.toSection, n, 1);
                                break block2;
                            }
                            case ALL_ITEMS: {
                                this.moveAll(shortcutConfig, shortcutConfig.fromStack);
                                if (shortcutConfig.fromSection != ContainerSection.INVENTORY_NOT_HOTBAR || shortcutConfig.toSection != ContainerSection.CHEST) return;
                                shortcutConfig.fromSection = ContainerSection.INVENTORY_HOTBAR;
                                this.moveAll(shortcutConfig, shortcutConfig.fromStack);
                                break block27;
                            }
                            case EVERYTHING: {
                                this.moveAll(shortcutConfig, null);
                                if (shortcutConfig.fromSection != ContainerSection.INVENTORY_HOTBAR || shortcutConfig.toSection != ContainerSection.CHEST) return;
                                shortcutConfig.fromSection = ContainerSection.INVENTORY_HOTBAR;
                                this.moveAll(shortcutConfig, null);
                            }
                        }
                    }
                }
            }
            return;
        }
    }

    private void dropAll(ShortcutConfig shortcutConfig, ItemStack itemStack) {
        for (Slot slot : this.container.getSlots(shortcutConfig.fromSection)) {
            if (!slot.func_75216_d() || itemStack != null && !this.areSameItemType(itemStack, slot.func_75211_c())) continue;
            int n = this.container.getSlotIndex(InvTweaksHandlerShortcuts.getSlotNumber(slot));
            while (slot.func_75216_d()) {
                this.container.drop(shortcutConfig.fromSection, n);
            }
        }
    }

    private void moveAll(ShortcutConfig shortcutConfig, ItemStack itemStack) throws TimeoutException {
        int n = this.getNextTargetIndex(shortcutConfig);
        for (Slot slot : this.container.getSlots(shortcutConfig.fromSection)) {
            if (slot.func_75216_d() && (itemStack == null || this.areSameItemType(itemStack, slot.func_75211_c()))) {
                int n2 = this.container.getSlotIndex(InvTweaksHandlerShortcuts.getSlotNumber(slot));
                while (slot.func_75216_d() && n != -1 && (shortcutConfig.fromSection != shortcutConfig.toSection || n2 != n)) {
                    boolean bl = this.container.move(shortcutConfig.fromSection, n2, shortcutConfig.toSection, n);
                    int n3 = this.getNextTargetIndex(shortcutConfig);
                    n = bl || shortcutConfig.action == ShortcutSpecification.Action.DROP || n3 != n ? n3 : -1;
                }
            }
            if (n != -1) continue;
            break;
        }
    }

    private int getNextTargetIndex(ShortcutConfig shortcutConfig) {
        if (shortcutConfig.action == ShortcutSpecification.Action.DROP) {
            return -999;
        }
        int n = -1;
        if (!shortcutConfig.forceEmptySlot) {
            int n2 = 0;
            for (Slot slot : this.container.getSlots(shortcutConfig.toSection)) {
                ItemStack itemStack;
                if (slot.func_75216_d() && !(itemStack = slot.func_75211_c()).func_77942_o() && itemStack.func_77969_a(shortcutConfig.fromStack) && itemStack.field_77994_a < itemStack.func_77976_d()) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        if (n == -1) {
            n = this.container.getFirstEmptyIndex(shortcutConfig.toSection);
        }
        if (n == -1 && shortcutConfig.toSection == ContainerSection.FURNACE_IN) {
            shortcutConfig.toSection = ContainerSection.FURNACE_FUEL;
            n = this.container.getFirstEmptyIndex(shortcutConfig.toSection);
        }
        return n;
    }

    public InvTweaksShortcutMapping isShortcutDown(InvTweaksShortcutType invTweaksShortcutType) {
        List<InvTweaksShortcutMapping> list = this.shortcuts.get((Object)invTweaksShortcutType);
        if (list != null) {
            for (InvTweaksShortcutMapping invTweaksShortcutMapping : list) {
                if (!invTweaksShortcutMapping.isTriggered(this.pressedKeys)) continue;
                return invTweaksShortcutMapping;
            }
        }
        return null;
    }

    private class ShortcutConfig {
        public ShortcutSpecification.Action action = null;
        public ShortcutSpecification.Scope scope = null;
        public ContainerSection fromSection = null;
        public int fromIndex = -1;
        public ItemStack fromStack = null;
        public ContainerSection toSection = null;
        public int toIndex = -1;
        public boolean forceEmptySlot = false;

        private ShortcutConfig() {
        }
    }
}

