/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.energy.prefab;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.ElectricItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BasicSource
extends TileEntity
implements IEnergySource {
    public final TileEntity parent;
    public final int capacity;
    public final int tier;
    protected double energyStored;
    protected boolean addedToEnet;

    public BasicSource(TileEntity parent, int capacity, int tier) {
        int power = EnergyNet.instance.getPowerFromTier(tier);
        this.parent = parent;
        this.capacity = capacity < power ? power : capacity;
        this.tier = tier;
    }

    public void onUpdateEntity() {
        if (!this.addedToEnet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        if (!this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.field_70331_k = this.parent.field_70331_k;
            this.field_70329_l = this.parent.field_70329_l;
            this.field_70330_m = this.parent.field_70330_m;
            this.field_70327_n = this.parent.field_70327_n;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void onInvalidate() {
        if (this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    public void onOnChunkUnload() {
        this.onInvalidate();
    }

    public void onReadFromNbt(NBTTagCompound tag) {
        NBTTagCompound data = tag.func_74775_l("IC2BasicSource");
        this.energyStored = data.func_74769_h("energy");
    }

    public void onWriteToNbt(NBTTagCompound tag) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energyStored);
        tag.func_74782_a("IC2BasicSource", (NBTBase)data);
    }

    public double getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(double amount) {
        this.energyStored = amount;
    }

    public double getFreeCapacity() {
        return (double)this.capacity - this.energyStored;
    }

    public double addEnergy(double amount) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        if (amount > (double)this.capacity - this.energyStored) {
            amount = (double)this.capacity - this.energyStored;
        }
        this.energyStored += amount;
        return amount;
    }

    public boolean charge(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        int amount = ElectricItem.manager.charge(stack, (int)this.energyStored, this.tier, false, false);
        this.energyStored -= (double)amount;
        return amount > 0;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        int power = EnergyNet.instance.getPowerFromTier(this.tier);
        if (this.energyStored >= (double)power) {
            return power;
        }
        return 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energyStored -= amount;
    }
}

