/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.energy.prefab;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BasicSink
extends TileEntity
implements IEnergySink {
    public final TileEntity parent;
    public final int capacity;
    public final int tier;
    protected double energyStored;
    protected boolean addedToEnet;

    public BasicSink(TileEntity parent, int capacity, int tier) {
        this.parent = parent;
        this.capacity = capacity;
        this.tier = tier;
    }

    public void onUpdateEntity() {
        if (!this.addedToEnet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        if (!this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.field_70331_k = this.parent.field_70331_k;
            this.field_70329_l = this.parent.field_70329_l;
            this.field_70330_m = this.parent.field_70330_m;
            this.field_70327_n = this.parent.field_70327_n;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void onInvalidate() {
        if (this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    public void onOnChunkUnload() {
        this.onInvalidate();
    }

    public void onReadFromNbt(NBTTagCompound tag) {
        NBTTagCompound data = tag.func_74775_l("IC2BasicSink");
        this.energyStored = data.func_74769_h("energy");
    }

    public void onWriteToNbt(NBTTagCompound tag) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energyStored);
        tag.func_74782_a("IC2BasicSink", (NBTBase)data);
    }

    public double getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(double amount) {
        this.energyStored = amount;
    }

    public boolean canUseEnergy(double amount) {
        return this.energyStored >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.canUseEnergy(amount) && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.energyStored -= amount;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double demandedEnergyUnits() {
        return Math.max(0.0, (double)this.capacity - this.energyStored);
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        this.energyStored += amount;
        return 0.0;
    }

    @Override
    public int getMaxSafeInput() {
        return EnergyNet.instance.getPowerFromTier(this.tier);
    }
}

