/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.PluginInfo;
import forestry.api.recipes.RecipeManagers;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.MachineNBTDefinition;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemNBTTile;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.RecipeUtil;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.factory.GuiHandlerFactory;
import forestry.factory.gadgets.MachineBottler;
import forestry.factory.gadgets.MachineCarpenter;
import forestry.factory.gadgets.MachineCentrifuge;
import forestry.factory.gadgets.MachineFabricator;
import forestry.factory.gadgets.MachineFermenter;
import forestry.factory.gadgets.MachineMoistener;
import forestry.factory.gadgets.MachineRaintank;
import forestry.factory.gadgets.MachineSqueezer;
import forestry.factory.gadgets.MachineStill;
import forestry.factory.gadgets.MillRainmaker;
import forestry.factory.gadgets.TileWorktable;
import forestry.factory.recipes.CraftGuideIntegration;
import forestry.plugins.NativePlugin;
import forestry.plugins.PluginIC2;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@PluginInfo(pluginID="Factory", name="Factory", author="SirSengir", url="http://forestry.sengir.net/", description="Adds a wide variety of machines to craft, produce and process products.")
public class PluginFactory
extends NativePlugin {
    public static MachineDefinition definitionBottler;
    public static MachineDefinition definitionCarpenter;
    public static MachineDefinition definitionCentrifuge;
    public static MachineDefinition definitionFermenter;
    public static MachineDefinition definitionMoistener;
    public static MachineDefinition definitionSqueezer;
    public static MachineDefinition definitionStill;
    public static MachineDefinition definitionRainmaker;
    public static MachineDefinition definitionFabricator;
    public static MachineDefinition definitionRaintank;
    public static MachineDefinition definitionWorktable;

    @Override
    public boolean isAvailable() {
        return !Config.disableFactory;
    }

    @Override
    public void preInit() {
        super.preInit();
        RecipeManagers.craftingProviders = new ArrayList();
        RecipeManagers.bottlerManager = new MachineBottler.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.bottlerManager);
        RecipeManagers.carpenterManager = new MachineCarpenter.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.carpenterManager);
        RecipeManagers.centrifugeManager = new MachineCentrifuge.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.centrifugeManager);
        RecipeManagers.fabricatorManager = new MachineFabricator.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.fabricatorManager);
        RecipeManagers.fermenterManager = new MachineFermenter.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.fermenterManager);
        RecipeManagers.moistenerManager = new MachineMoistener.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.moistenerManager);
        RecipeManagers.squeezerManager = new MachineSqueezer.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.squeezerManager);
        RecipeManagers.stillManager = new MachineStill.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.stillManager);
        int blockIDTESR = Config.getOrCreateBlockIdProperty("machine", 1405);
        definitionBottler = new MachineDefinition(blockIDTESR, 0, "forestry.Bottler", MachineBottler.class, Proxies.render.getRenderDefaultMachine("textures/blocks/bottler_"), ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDTESR, 1, 0), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), ForestryItem.canEmpty, Character.valueOf('Y'), ForestryItem.sturdyCasing}));
        definitionCarpenter = new MachineDefinition(blockIDTESR, 1, "forestry.Carpenter", MachineCarpenter.class, Proxies.render.getRenderDefaultMachine("textures/blocks/carpenter_"), ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDTESR, 1, 1), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), ForestryItem.sturdyCasing}));
        definitionCentrifuge = new MachineDefinition(blockIDTESR, 2, "forestry.Centrifuge", MachineCentrifuge.class, Proxies.render.getRenderDefaultMachine("textures/blocks/centrifuge_"), ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDTESR, 1, 2), "X#X", "XYX", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), ForestryItem.sturdyCasing.getItemStack()));
        definitionFermenter = new MachineDefinition(blockIDTESR, 3, "forestry.Fermenter", MachineFermenter.class, Proxies.render.getRenderDefaultMachine("textures/blocks/fermenter_"), ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDTESR, 1, 3), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "gearBronze", Character.valueOf('Y'), ForestryItem.sturdyCasing}));
        definitionMoistener = new MachineDefinition(blockIDTESR, 4, "forestry.Moistener", MachineMoistener.class, Proxies.render.getRenderDefaultMachine("textures/blocks/moistener_"), ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDTESR, 1, 4), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "gearCopper", Character.valueOf('Y'), ForestryItem.sturdyCasing}));
        definitionRainmaker = new MachineDefinition(blockIDTESR, 7, "forestry.Rainmaker", MillRainmaker.class, Proxies.render.getRenderMill("textures/blocks/rainmaker_"), ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDTESR, 1, 7), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "gearTin", Character.valueOf('Y'), ForestryItem.hardenedCasing}));
        definitionSqueezer = new MachineDefinition(blockIDTESR, 5, "forestry.Squeezer", MachineSqueezer.class, Proxies.render.getRenderDefaultMachine("textures/blocks/squeezer_"), ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDTESR, 1, 5), "X#X", "XYX", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "ingotTin", Character.valueOf('Y'), ForestryItem.sturdyCasing.getItemStack()));
        definitionStill = new MachineDefinition(blockIDTESR, 6, "forestry.Still", MachineStill.class, Proxies.render.getRenderDefaultMachine("textures/blocks/still_"), ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDTESR, 1, 6), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), Item.field_77767_aC, Character.valueOf('Y'), ForestryItem.sturdyCasing}));
        ForestryBlock.factoryTESR = new BlockBase(blockIDTESR, Material.field_76243_f, true, definitionBottler, definitionCarpenter, definitionCentrifuge, definitionFermenter, definitionMoistener, definitionSqueezer, definitionStill, definitionRainmaker).func_71864_b("for.factory");
        Proxies.common.registerBlock(ForestryBlock.factoryTESR, ItemForestryBlock.class);
        int blockIDPlain = Config.getOrCreateBlockIdProperty("mill", 1406);
        definitionFabricator = new MachineDefinition(blockIDPlain, 0, "forestry.Fabricator", MachineFabricator.class, ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDPlain, 1, 0), new Object[]{"X#X", "#Y#", "XZX", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), Item.field_77717_p, Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('Z'), Block.field_72077_au})).setFaces(0, 1, 2, 3, 4, 4);
        definitionRaintank = new MachineDefinition(blockIDPlain, 1, "forestry.Raintank", MachineRaintank.class, ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDPlain, 1, 1), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), Item.field_77703_o, Character.valueOf('Y'), ForestryItem.sturdyCasing})).setFaces(0, 1, 0, 0, 0, 0);
        definitionWorktable = new MachineNBTDefinition(blockIDPlain, 2, "forestry.Worktable", TileWorktable.class, ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockIDPlain, 1, 2), "B", "W", "C", Character.valueOf('B'), Item.field_77760_aL, Character.valueOf('W'), Block.field_72060_ay, Character.valueOf('C'), Block.field_72077_au)).setFaces(0, 1, 2, 3, 4, 4);
        ForestryBlock.factoryPlain = new BlockBase(blockIDPlain, Material.field_76243_f, definitionFabricator, definitionRaintank, definitionWorktable).func_71864_b("for.factory2");
        Proxies.common.registerBlock(ForestryBlock.factoryPlain, ItemNBTTile.class);
    }

    @Override
    public void doInit() {
        super.doInit();
        definitionBottler.register();
        definitionCarpenter.register();
        definitionCentrifuge.register();
        definitionFabricator.register();
        definitionFermenter.register();
        definitionMoistener.register();
        definitionRaintank.register();
        definitionSqueezer.register();
        definitionStill.register();
        definitionRainmaker.register();
        definitionWorktable.register();
    }

    @Override
    public void postInit() {
        super.postInit();
        if (Proxies.common.isModLoaded("craftguide")) {
            CraftGuideIntegration.register();
        } else {
            Proxies.log.info("Skipping CraftGuide integration.");
        }
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 0), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), "ingotCopper"});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 1), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), "ingotTin"});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 2), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), "ingotBronze"});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 3), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Item.field_77703_o});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Item.field_77717_p});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 5), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Item.field_77702_n});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 6), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Block.field_72089_ap});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 7), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Item.field_77722_bw});
        if (PluginIC2.rubber != null) {
            RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 8), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), PluginIC2.rubber});
        }
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 9), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Item.field_77817_bH});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 10), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), "gemApatite"});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), ForestryItem.tubes.getItemStack(4, 11), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), new ItemStack(Item.field_77756_aW, 1, 4)});
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        if (ForestryItem.propolis != null) {
            for (int i = 0; i < 16; ++i) {
                RecipeManagers.fabricatorManager.addRecipe(ForestryItem.waxCast.getItemStack(1, Short.MAX_VALUE), LiquidHelper.getLiquid("glass", 1000), new ItemStack(ForestryBlock.glass, 1, 15 - i), new Object[]{"#", "X", Character.valueOf('#'), dyes[i], Character.valueOf('X'), ForestryItem.propolis.getItemStack(1, Short.MAX_VALUE)});
            }
        }
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Item.field_77706_j)}, LiquidHelper.getLiquid("juice", GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple")), ForestryItem.mulch.getItemStack(), GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple"));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Item.field_77690_S)}, LiquidHelper.getLiquid("seedoil", GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Item.field_77739_bg)}, LiquidHelper.getLiquid("seedoil", GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Item.field_77740_bh)}, LiquidHelper.getLiquid("seedoil", GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.phosphor.getItemStack(2), new ItemStack(Block.field_71978_w)}, LiquidHelper.getLiquid("lava", 1600));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Block.field_72038_aV)}, LiquidHelper.getLiquid("water", 500));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Item.field_77768_aD), ForestryItem.craftingMaterial.getItemStack(4, 5)}, LiquidHelper.getLiquid("ice", 4000));
        RecipeManagers.stillManager.addRecipe(100, LiquidHelper.getLiquid("biomass", 10), LiquidHelper.getLiquid("bioethanol", 3));
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Item.field_77690_S), new ItemStack((Block)Block.field_71994_by), 5000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Block.field_71978_w), new ItemStack(Block.field_72087_ao), 20000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Block.field_72007_bm), new ItemStack(Block.field_72007_bm, 1, 1), 20000);
        RecipeUtil.injectLeveledRecipe(new ItemStack(Block.field_71987_y, 1, 0), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Block.field_71987_y, 1, 1), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Block.field_71987_y, 1, 2), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Block.field_71987_y, 1, 3), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Block.field_72038_aV), GameMode.getGameMode().getIntegerSetting("fermenter.yield.cactus"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Item.field_77685_T), GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Item.field_77758_aJ), GameMode.getGameMode().getIntegerSetting("fermenter.yield.cane"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack((Block)Block.field_72109_af), GameMode.getGameMode().getIntegerSetting("fermenter.yield.mushroom"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack((Block)Block.field_72103_ag), GameMode.getGameMode().getIntegerSetting("fermenter.yield.mushroom"), "biomass");
        RecipeManagers.fabricatorManager.addSmelting(new ItemStack(Block.field_71946_M), LiquidHelper.getLiquid("glass", 1000), 1000);
        RecipeManagers.fabricatorManager.addSmelting(new ItemStack(Block.field_72003_bq), LiquidHelper.getLiquid("glass", 375), 1000);
        RecipeManagers.fabricatorManager.addSmelting(new ItemStack(Block.field_71939_E), LiquidHelper.getLiquid("glass", 1000), 3000);
        RecipeManagers.carpenterManager.addRecipe(50, LiquidHelper.getLiquid("seedoil", 250), null, ForestryItem.impregnatedCasing.getItemStack(), new Object[]{"###", "# #", "###", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(50, LiquidHelper.getLiquid("seedoil", 500), null, new ItemStack(ForestryBlock.core, 1, 1), new Object[]{"#  ", "###", "# #", Character.valueOf('#'), "plankWood"});
        RecipeManagers.carpenterManager.addRecipe(10, LiquidHelper.getLiquid("seedoil", 100), null, ForestryItem.stickImpregnated.getItemStack(2), new Object[]{"#", "#", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 250), null, ForestryItem.woodPulp.getItemStack(4), new Object[]{"#", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 250), null, new ItemStack(Item.field_77759_aK, 1), new Object[]{"#", "#", Character.valueOf('#'), "pulpWood"});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryBlock.soil, 9, 0), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryBlock.soil, 8, 1), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), Block.field_71939_E, Character.valueOf('Y'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(75, LiquidHelper.getLiquid("water", 5000), null, ForestryItem.hardenedCasing.getItemStack(), new Object[]{"# #", " Y ", "# #", Character.valueOf('#'), Item.field_77702_n, Character.valueOf('Y'), ForestryItem.sturdyCasing});
        RecipeManagers.carpenterManager.addRecipe(20, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.circuitboards.getItemStack(1, 0), new Object[]{"R R", "R#R", "R R", Character.valueOf('#'), "ingotTin", Character.valueOf('R'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(40, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.circuitboards.getItemStack(1, 1), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), "ingotBronze", Character.valueOf('R'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(80, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.circuitboards.getItemStack(1, 2), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(80, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.circuitboards.getItemStack(1, 3), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(40, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.solderingIron.getItemStack(), new Object[]{" # ", "# #", "  B", Character.valueOf('#'), Item.field_77703_o, Character.valueOf('B'), "ingotBronze"});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.iodineCharge.getItemStack(), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.pollen, Character.valueOf('X'), Item.field_77677_M, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeyDrop});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.craftingMaterial.getItemStack(1, 4), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.royalJelly, Character.valueOf('X'), Item.field_77677_M, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeydew});
        RecipeManagers.carpenterManager.addRecipe(100, null, new ItemStack(Item.field_77730_bn, 1), new Object[]{" # ", "###", " # ", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 1)});
        RecipeManagers.carpenterManager.addRecipe(10, LiquidHelper.getLiquid("water", 500), null, ForestryItem.craftingMaterial.getItemStack(1, 3), new Object[]{"###", "###", "###", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 2)});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.carton.getItemStack(2), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), "pulpWood"});
        RecipeManagers.carpenterManager.addRecipe(20, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.crate.getItemStack(24), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(20, null, ForestryItem.carton.getItemStack(), ForestryItem.kitPickaxe.getItemStack(), new Object[]{"###", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood"});
        RecipeManagers.carpenterManager.addRecipe(20, null, ForestryItem.carton.getItemStack(), ForestryItem.kitShovel.getItemStack(), new Object[]{" # ", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood"});
        RecipeManagers.carpenterManager.addRecipe(null, ForestryItem.ingotBronze.getItemStack(2, ForestryItem.ingotBronze.item().func_77612_l()), new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzePickaxe});
        RecipeManagers.carpenterManager.addRecipe(null, ForestryItem.ingotBronze.getItemStack(), new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzeShovel});
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedWood.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCobblestone.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedDirt.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedStone.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedBrick.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCacti.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSand.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedObsidian.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedNetherrack.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSoulsand.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSandstone.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedBogearth.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedHumus.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedNetherbrick.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedPeat.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedApatite.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedFertilizer.getItemStack());
        ((MachineCarpenter.RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotTin", ForestryItem.ingotTin.getItemStack(), ForestryItem.cratedTin.getItemStack());
        ((MachineCarpenter.RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotCopper", ForestryItem.ingotCopper.getItemStack(), ForestryItem.cratedCopper.getItemStack());
        ((MachineCarpenter.RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotBronze", ForestryItem.ingotBronze.getItemStack(), ForestryItem.cratedBronze.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedWheat.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedMycelium.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedMulch.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCookies.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedHoneycombs.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedBeeswax.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedPollen.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedPropolis.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedHoneydew.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedRoyalJelly.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCocoaComb.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedRedstone.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedLapis.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedReeds.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedClay.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedGlowstone.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedApples.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedNetherwart.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSimmeringCombs.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedStringyCombs.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedFrozenCombs.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedDrippingCombs.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedRefractoryWax.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedPhosphor.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedAsh.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCharcoal.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedGravel.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCoal.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSeeds.getItemStack());
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSaplings.getItemStack());
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFactory();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }
}

