/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemInventory;
import forestry.plugins.PluginLepidopterology;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class ItemFlutterlyzer
extends ItemInventoried {
    public ItemFlutterlyzer(int i) {
        super(i);
        this.func_77625_d(1);
        this.func_77637_a(Tabs.tabLepidopterology);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.FlutterlyzerGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static class FlutterlyzerInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        public static final int SLOT_SPECIMEN = 0;
        public static final int SLOT_ANALYZE_1 = 1;
        public static final int SLOT_ANALYZE_2 = 2;
        public static final int SLOT_ANALYZE_3 = 3;
        public static final int SLOT_ANALYZE_4 = 4;
        public static final int SLOT_ANALYZE_5 = 6;
        public static final int SLOT_ENERGY = 5;
        EntityPlayer player;

        public FlutterlyzerInventory(EntityPlayer player) {
            super(ItemFlutterlyzer.class, 7);
            this.player = player;
        }

        public FlutterlyzerInventory(EntityPlayer player, ItemStack itemStack) {
            super(ItemFlutterlyzer.class, 7, itemStack);
            this.player = player;
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 5; i < 6; ++i) {
                if (this.inventoryStacks[i] == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                this.inventoryStacks[i].func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }

        private boolean isEnergy(ItemStack itemstack) {
            if (itemstack == null || itemstack.field_77994_a <= 0) {
                return false;
            }
            return ForestryItem.honeyDrop.isItemEqual(itemstack) || ForestryItem.honeydew.isItemEqual(itemstack);
        }

        private void tryAnalyze() {
            if (this.inventoryStacks[1] != null || this.inventoryStacks[2] != null || this.inventoryStacks[3] != null || this.inventoryStacks[4] != null || this.inventoryStacks[6] != null) {
                return;
            }
            if (this.func_70301_a(0) == null) {
                return;
            }
            IButterfly butterfly = PluginLepidopterology.butterflyInterface.getMember(this.func_70301_a(0));
            if (butterfly == null) {
                return;
            }
            if (!butterfly.isAnalyzed()) {
                if (!this.isEnergy(this.func_70301_a(5))) {
                    return;
                }
                butterfly.analyze();
                if (this.player != null) {
                    PluginLepidopterology.butterflyInterface.getBreedingTracker(this.player.field_70170_p, this.player.field_71092_bJ).registerSpecies(butterfly.getGenome().getPrimary());
                    PluginLepidopterology.butterflyInterface.getBreedingTracker(this.player.field_70170_p, this.player.field_71092_bJ).registerSpecies(butterfly.getGenome().getSecondary());
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound("tag");
                butterfly.writeToNBT(nbttagcompound);
                this.func_70301_a(0).func_77982_d(nbttagcompound);
                this.func_70298_a(5, 1);
            }
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, null);
        }

        @Override
        public void func_70296_d() {
            this.tryAnalyze();
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("flutterlyzer") != null && ((String[])Config.hints.get("flutterlyzer")).length > 0;
        }

        @Override
        public String[] getHints() {
            return (String[])Config.hints.get("flutterlyzer");
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (PluginLepidopterology.butterflyInterface.isMember(this.inventoryStacks[0]) && !this.isEnergy(this.func_70301_a(5))) {
                return EnumErrorCode.NOHONEY;
            }
            return EnumErrorCode.OK;
        }
    }
}

