/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.gui;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IMutation;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.AlleleBoolean;
import forestry.core.genetics.AlleleTolerance;
import forestry.core.genetics.ClimateHelper;
import forestry.core.genetics.GenericRatings;
import forestry.core.gui.GuiAlyzer;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.lepidopterology.gui.ContainerFlutterlyzer;
import forestry.lepidopterology.items.ItemButterflyGE;
import forestry.lepidopterology.items.ItemFlutterlyzer;
import forestry.plugins.PluginLepidopterology;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GuiFlutterlyzer
extends GuiAlyzer {
    private ItemStack[] tempProductList;

    public GuiFlutterlyzer(EntityPlayer player, ItemFlutterlyzer.FlutterlyzerInventory inventory) {
        super(AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies"), player, new ContainerFlutterlyzer(player.field_71071_by, inventory), inventory, 1, inventory.func_70302_i_());
        this.field_74194_b = 196;
        this.field_74195_c = 238;
        ArrayList butterflyList = new ArrayList();
        ((ItemButterflyGE)ForestryItem.butterflyGE.item()).addCreativeItems(butterflyList, false);
        for (ItemStack butterflyStack : butterflyList) {
            this.iconStacks.put(PluginLepidopterology.butterflyInterface.getMember(butterflyStack).getIdent(), butterflyStack);
        }
    }

    @Override
    protected void func_74185_a(float var1, int mouseX, int mouseY) {
        super.func_74185_a(var1, mouseX, mouseY);
        int page = 0;
        IButterfly butterfly = null;
        for (int k = 1; k < 7; ++k) {
            if (k == 5 || this.inventory.func_70301_a(k) == null || (butterfly = PluginLepidopterology.butterflyInterface.getMember(this.inventory.func_70301_a(k))) == null || !butterfly.isAnalyzed()) continue;
            page = k;
            break;
        }
        switch (page) {
            case 1: {
                this.drawAnalyticsPage1(butterfly);
                break;
            }
            case 2: {
                this.drawAnalyticsPage2(butterfly);
                break;
            }
            case 3: {
                this.drawAnalyticsPage3(butterfly);
                break;
            }
            case 4: {
                this.drawAnalyticsPage4(butterfly);
                break;
            }
            case 6: {
                this.drawAnalyticsPageClassification(butterfly);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private void drawAnalyticsOverview() {
        this.startPage();
        this.newLine();
        String title = StringUtil.localize("item.flutterlyzer").toUpperCase();
        this.drawCenteredLine(title, 8, 158);
        this.newLine();
        this.field_73886_k.func_78279_b(StringUtil.localize("gui.flutterlyzer.help"), (int)((float)(this.field_74198_m + 12 + 4) * (1.0f / this.factor)), (int)((float)(this.field_74197_n + 42) * (1.0f / this.factor)), (int)(158.0f * (1.0f / this.factor)), this.fontColor.get("gui.screen"));
        this.newLine();
        this.newLine();
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.beealyzer.overview") + ":", 16);
        this.newLine();
        this.drawLine("I  : " + StringUtil.localize("gui.general"), 16);
        this.newLine();
        this.drawLine("II : " + StringUtil.localize("gui.environment"), 16);
        this.newLine();
        this.drawLine("III: " + StringUtil.localize("gui.produce"), 16);
        this.newLine();
        this.drawLine("IV : " + StringUtil.localize("gui.evolution"), 16);
        this.endPage();
    }

    private void drawAnalyticsPage1(IButterfly butterfly) {
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.active"), 52);
        this.drawLine(StringUtil.localize("gui.inactive"), 108);
        this.newLine();
        this.newLine();
        this.drawSpeciesRow(StringUtil.localize("gui.species"), butterfly, EnumButterflyChromosome.SPECIES);
        this.newLine();
        this.drawRow(StringUtil.localize("gui.size"), butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.SIZE.ordinal()).getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.SIZE.ordinal()).getName(), butterfly, EnumButterflyChromosome.SPEED);
        this.drawRow(StringUtil.localize("gui.lifespan"), butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.LIFESPAN.ordinal()).getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.LIFESPAN.ordinal()).getName(), butterfly, EnumButterflyChromosome.LIFESPAN);
        this.drawRow(StringUtil.localize("gui.speed"), butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.SPEED.ordinal()).getName(), butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.SPEED.ordinal()).getName(), butterfly, EnumButterflyChromosome.SPEED);
        this.drawRow(StringUtil.localize("gui.metabolism"), GenericRatings.rateMetabolism(butterfly.getGenome().getMetabolism()), GenericRatings.rateMetabolism(((IAlleleInteger)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.METABOLISM.ordinal())).getValue()), butterfly, EnumButterflyChromosome.METABOLISM);
        this.drawLine(StringUtil.localize("gui.fertility"), 12);
        this.drawFertilityInfo(butterfly.getGenome().getFertility(), 52, this.getColorCoding(butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.FERTILITY.ordinal()).isDominant()), 8);
        this.drawFertilityInfo(((IAlleleInteger)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FERTILITY.ordinal())).getValue(), 108, this.getColorCoding(butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FERTILITY.ordinal()).isDominant()), 8);
        this.newLine();
        this.drawRow(StringUtil.localize("gui.flowers"), StringUtil.localize(butterfly.getGenome().getFlowerProvider().getDescription()), StringUtil.localize(((IAlleleFlowers)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FLOWER_PROVIDER.ordinal())).getProvider().getDescription()), butterfly, EnumButterflyChromosome.FLOWER_PROVIDER);
        this.drawRow(StringUtil.localize("gui.effect"), StringUtil.localize(butterfly.getGenome().getEffect().getName()), StringUtil.localize(((IAlleleEffect)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.EFFECT.ordinal())).getName()), butterfly, EnumButterflyChromosome.EFFECT);
        this.newLine();
        this.endPage();
    }

    private void drawAnalyticsPage2(IButterfly butterfly) {
        String nocturnal1;
        String diurnal1;
        String nocturnal0;
        String diurnal0;
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.active"), 52);
        this.drawLine(StringUtil.localize("gui.inactive"), 108);
        this.newLine();
        this.newLine();
        this.drawRow(StringUtil.localize("gui.climate"), ClimateHelper.toDisplay(butterfly.getGenome().getPrimary().getTemperature()), ClimateHelper.toDisplay(butterfly.getGenome().getPrimary().getTemperature()), butterfly, EnumButterflyChromosome.SPECIES);
        this.drawLine(StringUtil.localize("gui.temptol"), 12);
        this.drawToleranceInfo(butterfly.getGenome().getToleranceTemp(), 52, this.getColorCoding(butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE.ordinal()).isDominant()));
        this.drawToleranceInfo(((AlleleTolerance)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE.ordinal())).getValue(), 108, this.getColorCoding(butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE.ordinal()).isDominant()));
        this.newLine();
        this.drawRow(StringUtil.localize("gui.humidity"), ClimateHelper.toDisplay(butterfly.getGenome().getPrimary().getHumidity()), ClimateHelper.toDisplay(butterfly.getGenome().getPrimary().getHumidity()), butterfly, EnumButterflyChromosome.SPECIES);
        this.drawLine(StringUtil.localize("gui.humidtol"), 12);
        this.drawToleranceInfo(butterfly.getGenome().getToleranceHumid(), 52, this.getColorCoding(butterfly.getGenome().getActiveAllele(EnumButterflyChromosome.HUMIDITY_TOLERANCE.ordinal()).isDominant()));
        this.drawToleranceInfo(((AlleleTolerance)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.HUMIDITY_TOLERANCE.ordinal())).getValue(), 108, this.getColorCoding(butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.HUMIDITY_TOLERANCE.ordinal()).isDominant()));
        this.newLine();
        this.newLine();
        String yes = StringUtil.localize("yes");
        String no = StringUtil.localize("no");
        if (butterfly.getGenome().getNocturnal()) {
            nocturnal0 = diurnal0 = yes;
        } else {
            nocturnal0 = butterfly.getGenome().getPrimary().isNocturnal() ? yes : no;
            String string = diurnal0 = !butterfly.getGenome().getPrimary().isNocturnal() ? yes : no;
        }
        if (((AlleleBoolean)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.NOCTURNAL.ordinal())).getValue()) {
            nocturnal1 = diurnal1 = yes;
        } else {
            nocturnal1 = butterfly.getGenome().getSecondary().isNocturnal() ? yes : no;
            diurnal1 = !butterfly.getGenome().getSecondary().isNocturnal() ? yes : no;
        }
        this.drawLine(StringUtil.localize("gui.diurnal"), 12);
        this.drawLine(diurnal0, 52, this.getColorCoding(false));
        this.drawLine(diurnal1, 108, this.getColorCoding(false));
        this.newLine();
        this.drawLine(StringUtil.localize("gui.nocturnal"), 12);
        this.drawLine(nocturnal0, 52, this.getColorCoding(false));
        this.drawLine(nocturnal1, 108, this.getColorCoding(false));
        this.newLine();
        String primary = StringUtil.readableBoolean(butterfly.getGenome().getTolerantFlyer(), yes, no);
        String secondary = StringUtil.readableBoolean(((AlleleBoolean)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.TOLERANT_FLYER.ordinal())).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.flyer"), primary, secondary, butterfly, EnumButterflyChromosome.TOLERANT_FLYER);
        primary = StringUtil.readableBoolean(butterfly.getGenome().getFireResist(), yes, no);
        secondary = StringUtil.readableBoolean(((AlleleBoolean)butterfly.getGenome().getInactiveAllele(EnumButterflyChromosome.FIRE_RESIST.ordinal())).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.fireresist"), primary, secondary, butterfly, EnumButterflyChromosome.FIRE_RESIST);
        this.endPage();
    }

    private void drawAnalyticsPage3(IButterfly butterfly) {
        this.tempProductList = butterfly.getGenome().getPrimary().getButterflyLoot().keySet().toArray(StackUtils.EMPTY_STACK_ARRAY);
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.loot.butterfly") + ":", 12);
        this.newLine();
        int x = 12;
        for (ItemStack stack : this.tempProductList) {
            field_74196_a.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, stack, (int)((float)(this.field_74198_m + x) * (1.0f / this.factor)), (int)((float)(this.field_74197_n + this.getLineY()) * (1.0f / this.factor)));
            if ((x += 18) <= this.adjustToFactor(148)) continue;
            x = 12;
            this.newLine();
        }
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.loot.caterpillar") + ":", 12);
        this.newLine();
        x = 12;
        for (ItemStack stack : butterfly.getGenome().getPrimary().getCaterpillarLoot().keySet().toArray(StackUtils.EMPTY_STACK_ARRAY)) {
            field_74196_a.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, stack, (int)((float)(this.field_74198_m + x) * (1.0f / this.factor)), (int)((float)(this.field_74197_n + this.getLineY()) * (1.0f / this.factor)));
            if ((x += 18) <= this.adjustToFactor(148)) continue;
            x = 12;
            this.newLine();
        }
        this.endPage();
    }

    private void drawAnalyticsPage4(IButterfly butterfly) {
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.beealyzer.mutations") + ":", 12);
        this.newLine();
        this.newLine();
        RenderHelper.func_74520_c();
        HashMap combinations = new HashMap();
        int columnWidth = 50;
        int x = 0;
        for (Map.Entry mutation : combinations.entrySet()) {
            this.drawMutationInfo((IMutation)mutation.getKey(), (IAllele)mutation.getValue(), 12 + x);
            if ((x += columnWidth) <= 150) continue;
            x = 0;
            this.newLine();
            this.newLine();
        }
        this.endPage();
    }
}

