/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.api.farming.IFarmLogic;
import forestry.core.gui.ContainerSocketed;
import forestry.core.gui.slots.SlotCustom;
import forestry.core.gui.slots.SlotForestry;
import forestry.core.gui.slots.SlotLiquidContainer;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.network.PacketTankUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.TileInventoryAdapter;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.plugins.PluginFarming;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerFarm
extends ContainerSocketed {
    TileFarmPlain tile;
    private Map syncedFluids = new HashMap();

    public ContainerFarm(InventoryPlayer playerinventory, TileFarmPlain tile) {
        super((IInventory)playerinventory, tile);
        int j;
        int i;
        this.tile = tile;
        IInventory inventory = tile.getInventory();
        if (inventory == null) {
            inventory = new TileInventoryAdapter(tile, 22, "Items");
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 2; ++j) {
                this.addSlot(new SlotResources(inventory, tile.getFarmLogics(), 0 + j + i * 2, 123 + j * 18, 22 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 2; ++j) {
                this.addSlot(new SlotGermlings(inventory, tile.getFarmLogics(), 6 + j + i * 2, 164 + j * 18, 22 + i * 18));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                this.addSlot(new SlotOutput(inventory, 12 + j + i * 2, 123 + j * 18, 86 + i * 18));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                this.addSlot(new SlotOutput(inventory, 16 + j + i * 2, 164 + j * 18, 86 + i * 18));
            }
        }
        this.addSlot(new SlotCustom(inventory, 20, 63, 95, PluginFarming.farmFertilizer));
        this.addSlot(new SlotLiquidContainer(inventory, 21, 15, 95));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((IInventory)playerinventory, j + i * 9 + 9, 28 + j * 18, 138 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((IInventory)playerinventory, i, 28 + i * 18, 196));
        }
    }

    public void func_75137_b(int i, int j) {
        this.tile.getGUINetworkData(i, j);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            this.tile.sendGUINetworkData(this, (ICrafting)this.field_75149_d.get(i));
        }
        ForestryTank tank = this.tile.getTank();
        if (tank.getFluid() == null && this.getTank(0).getFluidAmount() <= 0) {
            return;
        }
        if (tank.getFluid() != null && tank.getFluid().isFluidStackIdentical(this.getTank(0).getFluid())) {
            return;
        }
        for (int j = 0; j < this.field_75149_d.size(); ++j) {
            if (!(this.field_75149_d.get(j) instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)this.field_75149_d.get(j);
            Proxies.net.sendToPlayer(new PacketTankUpdate(0, tank), (EntityPlayer)player);
        }
        this.syncedFluids.put(0, new ForestryTank(tank.getFluid() == null ? null : tank.getFluid().copy(), tank.getCapacity()));
    }

    @Override
    public void onTankUpdate(NBTTagCompound nbt) {
        byte tankID = nbt.func_74771_c("tank");
        short capacity = nbt.func_74765_d("capacity");
        ForestryTank tank = new ForestryTank(capacity);
        tank.readFromNBT(nbt);
        this.syncedFluids.put(Integer.valueOf(tankID), tank);
    }

    @Override
    public ForestryTank getTank(int slot) {
        return this.syncedFluids.get(slot) == null ? ForestryTank.FAKETANK : (ForestryTank)((Object)this.syncedFluids.get(slot));
    }

    private class SlotGermlings
    extends SlotForestry {
        private final IFarmLogic[] logics;

        public SlotGermlings(IInventory inventory, IFarmLogic[] logics, int slotIndex, int xPos, int yPos) {
            super(inventory, slotIndex, xPos, yPos);
            this.logics = logics;
        }

        public boolean func_75214_a(ItemStack stack) {
            for (IFarmLogic logic : this.logics) {
                if (logic == null || !logic.isAcceptedGermling(stack)) continue;
                return true;
            }
            return false;
        }
    }

    private class SlotResources
    extends SlotForestry {
        private final IFarmLogic[] logics;

        public SlotResources(IInventory inventory, IFarmLogic[] logics, int slotIndex, int xPos, int yPos) {
            super(inventory, slotIndex, xPos, yPos);
            this.logics = logics;
        }

        public boolean func_75214_a(ItemStack stack) {
            for (IFarmLogic logic : this.logics) {
                if (logic == null || !logic.isAcceptedResource(stack)) continue;
                return true;
            }
            return false;
        }
    }
}

