/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.WidgetManager;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import forestry.factory.gadgets.TileWorktable;
import forestry.factory.gui.ContainerWorktable;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiWorktable
extends GuiForestry {
    private TileWorktable worktable;
    protected ContainerWorktable container;

    public GuiWorktable(EntityPlayer player, TileWorktable tile) {
        super("textures/gui/worktable.png", (ContainerForestry)new ContainerWorktable(player, tile));
        this.field_74195_c = 218;
        this.worktable = tile;
        this.tile = tile;
        this.container = (ContainerWorktable)this.field_74193_d;
        this.widgetManager.add(new BookSlot(this.widgetManager, 128, 38));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 146, 20, 0));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 146, 38, 1));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 146, 56, 2));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 128, 56, 3));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 110, 56, 4));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 110, 38, 5));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 110, 20, 6));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 128, 20, 7));
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        super.func_74189_g(mouseX, mouseY);
        String name = StringUtil.localize("tile.for." + this.tile.func_70303_b());
        this.field_73886_k.func_78276_b(name, this.getCenteredOffset(name), 6, this.fontColor.get("gui.title"));
    }

    private class BookSlot
    extends Widget {
        private final ItemStack BOOK;

        public BookSlot(WidgetManager manager, int xPos, int yPos) {
            super(manager, xPos, yPos);
            this.BOOK = new ItemStack(Item.field_77760_aL);
        }

        @Override
        public void draw(int startX, int startY) {
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.manager.gui.drawItemStack(this.BOOK, startX + this.xPos, startY + this.yPos);
            GL11.glPopAttrib();
        }

        @Override
        protected String getLegacyTooltip(EntityPlayer player) {
            return StringUtil.localize("gui.worktable.clear");
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            GuiWorktable.this.container.sendRecipeClick(mouseButton, 9);
        }
    }

    private class MemorizedSlot
    extends Widget {
        int slotNumber;

        public MemorizedSlot(WidgetManager manager, int xPos, int yPos, int slot) {
            super(manager, xPos, yPos);
            this.slotNumber = slot;
        }

        private ItemStack getOutputStack() {
            return GuiWorktable.this.worktable.getMemory().getRecipeOutput(this.slotNumber);
        }

        @Override
        public void draw(int startX, int startY) {
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack output = this.getOutputStack();
            if (output != null) {
                this.manager.gui.drawItemStack(output, startX + this.xPos, startY + this.yPos);
            }
            GL11.glDisable((int)2929);
            if (GuiWorktable.this.worktable.getMemory().isLocked(this.slotNumber)) {
                this.manager.gui.setZLevel(110.0f);
                Proxies.common.bindTexture(SpriteSheet.ITEMS);
                this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos, TextureManager.getInstance().getDefault("slots/locked"), 16, 16);
                this.manager.gui.setZLevel(0.0f);
            }
            GL11.glPopAttrib();
        }

        @Override
        protected String getLegacyTooltip(EntityPlayer player) {
            ItemStack output = this.getOutputStack();
            return output != null ? output.func_82833_r() : null;
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            GuiWorktable.this.container.sendRecipeClick(mouseButton, this.slotNumber);
        }
    }
}

