/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory.manipulators;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.core.inventory.filters.IStackFilter;
import forestry.core.inventory.manipulators.InventoryManipulator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;

public class SpecialManipulator
extends InventoryManipulator {
    private final ISpecialInventory inv;
    protected ForgeDirection side = ForgeDirection.UNKNOWN;

    protected SpecialManipulator(ISpecialInventory inv) {
        super(inv);
        this.inv = inv;
    }

    public void setSide(ForgeDirection side) {
        this.side = side;
    }

    @Override
    public ItemStack tryAddStack(ItemStack stack) {
        return this.addStackInternal(stack, false);
    }

    @Override
    public ItemStack addStack(ItemStack stack) {
        return this.addStackInternal(stack, true);
    }

    private ItemStack addStackInternal(ItemStack stack, boolean doAdd) {
        if (stack == null) {
            return null;
        }
        int used = this.inv.addItem((stack = stack.func_77946_l()).func_77946_l(), doAdd, this.side);
        if (used >= stack.field_77994_a) {
            return null;
        }
        stack.field_77994_a -= used;
        return stack;
    }

    @Override
    public boolean canRemoveItem(IStackFilter filter) {
        return this.tryRemoveItem(filter) == null;
    }

    @Override
    public ItemStack tryRemoveItem(IStackFilter filter) {
        return this.removeStackInternal(filter, false);
    }

    @Override
    public ItemStack removeItem(IStackFilter filter) {
        return this.removeStackInternal(filter, true);
    }

    protected ItemStack removeStackInternal(IStackFilter filter, boolean doRemove) {
        ItemStack[] extracted = this.inv.extractItem(false, this.side, 1);
        if (extracted != null && extracted.length > 0 && filter.matches(extracted[0])) {
            if (doRemove) {
                this.inv.extractItem(true, this.side, 1);
            }
            return extracted[0];
        }
        return null;
    }

    @Override
    public ItemStack moveItem(IInventory dest, IStackFilter filter) {
        ItemStack result;
        InventoryManipulator imDest = InventoryManipulator.get(dest);
        ItemStack stack = this.tryRemoveItem(filter);
        if (stack != null && (result = imDest.addStack(stack)) == null) {
            return this.removeItem(filter);
        }
        return null;
    }
}

