/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.Chromosome;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;

public abstract class SpeciesRoot
implements ISpeciesRoot {
    LinkedHashMap researchCatalysts = new LinkedHashMap();
    public HashMap speciesTemplates = new HashMap();

    @Override
    public Map getResearchCatalysts() {
        return Collections.unmodifiableMap(this.researchCatalysts);
    }

    @Override
    public void setResearchSuitability(ItemStack itemstack, float suitability) {
        this.researchCatalysts.put(itemstack, Float.valueOf(suitability));
    }

    @Override
    public Map getGenomeTemplates() {
        return this.speciesTemplates;
    }

    @Override
    public void registerTemplate(IAllele[] template) {
        this.registerTemplate(template[0].getUID(), template);
    }

    @Override
    public IAllele[] getRandomTemplate(Random rand) {
        return ((IAllele[][])this.speciesTemplates.values().toArray((T[])new IAllele[0][]))[rand.nextInt(this.speciesTemplates.values().size())];
    }

    @Override
    public IAllele[] getTemplate(String identifier) {
        return (IAllele[])this.speciesTemplates.get(identifier);
    }

    @Override
    public Collection getCombinations(IAllele other) {
        ArrayList<IMutation> combinations = new ArrayList<IMutation>();
        for (IMutation mutation : this.getMutations(false)) {
            if (!mutation.isPartner(other)) continue;
            combinations.add(mutation);
        }
        return combinations;
    }

    @Override
    public Collection getPaths(IAllele result, int chromosomeOrdinal) {
        ArrayList<IMutation> paths = new ArrayList<IMutation>();
        for (IMutation mutation : this.getMutations(false)) {
            if (mutation.getTemplate()[chromosomeOrdinal] != result) continue;
            paths.add(mutation);
        }
        return paths;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] template) {
        IChromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        IChromosome[] chromosomes = new Chromosome[templateActive.length];
        for (int i = 0; i < templateActive.length; ++i) {
            if (templateActive[i] == null) continue;
            chromosomes[i] = new Chromosome(templateActive[i], templateInactive[i]);
        }
        return chromosomes;
    }
}

