/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.gadgets.NaturalistGame;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ICrafter;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.network.ForestryPacket;
import forestry.core.network.GuiId;
import forestry.core.network.PacketTileNBT;
import forestry.core.network.PacketTileUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TileInventoryAdapter;
import forestry.core.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEscritoire
extends TileBase
implements ISidedInventory,
IRenderableMachine,
ICrafter {
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_RESULTS_1 = 1;
    public static final short SLOTS_RESULTS_COUNT = 6;
    public static final short SLOT_INPUT_1 = 7;
    public static final short SLOTS_INPUT_COUNT = 5;
    private NaturalistGame game = new NaturalistGame();
    private InventoryAdapter inventory = new TileInventoryAdapter(this, 12, "Items");

    @Override
    public String func_70303_b() {
        return StringUtil.localize("core.1");
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.NaturalistBenchGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        this.game.writeToNBT(nbttagcompound);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.game.readFromNBT(nbttagcompound);
        this.inventory.readFromNBT(nbttagcompound);
    }

    public NaturalistGame getGame() {
        return this.game;
    }

    public void processTurnResult(String researcher) {
        if (!this.game.isWon()) {
            return;
        }
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(this.inventory.func_70301_a(0));
        if (individual == null) {
            return;
        }
        for (ItemStack itemstack : individual.getGenome().getPrimary().getResearchBounty(this.field_70331_k, researcher, individual, this.game.getBountyLevel())) {
            this.inventory.addStack(itemstack, 1, 6, false, true);
        }
    }

    private boolean areProbeSlotsFilled() {
        int filledSlots = 0;
        int required = this.game.getSampleSize() < 5 ? this.game.getSampleSize() : 5;
        for (int i = 7; i < 7 + required; ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            ++filledSlots;
        }
        return filledSlots >= required;
    }

    public void probe() {
        if (!this.field_70331_k.field_72995_K && this.inventory.func_70301_a(0) != null && this.areProbeSlotsFilled()) {
            this.game.probe(this.inventory.func_70301_a(0), (IInventory)this, 7, 5);
        }
    }

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        if (packetRaw instanceof PacketTileUpdate) {
            super.fromPacket(packetRaw);
            return;
        }
        PacketTileNBT packet = (PacketTileNBT)packetRaw;
        this.func_70307_a(packet.getTagCompound());
    }

    public void sendBoard(EntityPlayer player) {
        Proxies.net.sendToPlayer(new PacketTileNBT(5, this), player);
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        if (slotIndex >= 7 && slotIndex < 12) {
            return slotIndex < 7 + this.game.getSampleSize();
        }
        return true;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex >= 1 && slotIndex < 7;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        int samples = this.game.getSampleSize();
        return slotIndex >= 7 && slotIndex < 7 + (samples < 5 ? samples : 5);
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.inventory.func_70299_a(slotIndex, itemstack);
        if (slotIndex == 0 && Proxies.common.isSimulating(this.field_70331_k)) {
            ItemStack ersatz;
            if (!AlleleManager.alleleRegistry.isIndividual(this.inventory.func_70301_a(0)) && this.inventory.func_70301_a(0) != null && (ersatz = Utils.convertSaplingToGeneticEquivalent(this.inventory.func_70301_a(0))) != null) {
                this.inventory.func_70299_a(0, ersatz);
            }
            this.game.initialize(this.inventory.func_70301_a(0));
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, boolean consumeRecipe, EntityPlayer player) {
        if (slotIndex == 0) {
            this.game.reset();
        }
        return null;
    }

    @Override
    public ItemStack getResult() {
        return null;
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return true;
    }
}

