/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.EnumCircuitBoardType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class CircuitBoard
implements ICircuitBoard {
    EnumCircuitBoardType type;
    ICircuitLayout layout;
    ICircuit[] circuits;

    public CircuitBoard(EnumCircuitBoardType type, ICircuitLayout layout, ICircuit[] circuits) {
        this.type = type;
        this.layout = layout;
        this.circuits = circuits;
    }

    public CircuitBoard(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    @Override
    public int getPrimaryColor() {
        return this.type.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.type.secondaryColor;
    }

    @Override
    public void addTooltip(List list) {
        if (this.layout != null) {
            list.add("\u00a76" + this.layout.getUsage() + ":");
        }
        for (ICircuit circuit : this.circuits) {
            if (circuit == null) continue;
            circuit.addTooltip(list);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.type = EnumCircuitBoardType.values()[nbttagcompound.func_74765_d("T")];
        if (nbttagcompound.func_74764_b("LY")) {
            this.layout = ChipsetManager.circuitRegistry.getLayout(nbttagcompound.func_74779_i("LY"));
        }
        if (this.layout == null) {
            ChipsetManager.circuitRegistry.getDefaultLayout();
        }
        ArrayList<ICircuit> readcircuits = new ArrayList<ICircuit>();
        if (nbttagcompound.func_74764_b("CS")) {
            NBTTagList nbttaglist = nbttagcompound.func_74761_m("CS");
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
                readcircuits.add(ChipsetManager.circuitRegistry.getFromLegacyMap(nbttagcompound1.func_74762_e("I")));
            }
            this.circuits = readcircuits.toArray(new ICircuit[0]);
            return;
        }
        if (nbttagcompound.func_74764_b("CL")) {
            NBTTagList nbttaglist = nbttagcompound.func_74761_m("CL");
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
                readcircuits.add(ChipsetManager.circuitRegistry.getCircuit(nbttagcompound1.func_74779_i("I")));
            }
            this.circuits = readcircuits.toArray(new ICircuit[0]);
            return;
        }
        if (this.circuits != null) {
            return;
        }
        this.circuits = new ICircuit[4];
        for (int i = 0; i < 4; ++i) {
            if (!nbttagcompound.func_74764_b("CA.I" + i)) continue;
            this.circuits[i] = ChipsetManager.circuitRegistry.getCircuit(nbttagcompound.func_74779_i("CA.I" + i));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("T", (short)this.type.ordinal());
        if (this.layout != null) {
            nbttagcompound.func_74778_a("LY", this.layout.getUID());
        }
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            nbttagcompound.func_74778_a("CA.I" + i, circuit.getUID());
        }
    }

    @Override
    public void onInsertion(TileEntity tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            if (this.circuits[i] == null) continue;
            this.circuits[i].onInsertion(i, tile);
        }
    }

    @Override
    public void onLoad(TileEntity tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            if (this.circuits[i] == null) continue;
            this.circuits[i].onLoad(i, tile);
        }
    }

    @Override
    public void onRemoval(TileEntity tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            if (this.circuits[i] == null) continue;
            this.circuits[i].onRemoval(i, tile);
        }
    }

    @Override
    public void onTick(TileEntity tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            if (this.circuits[i] == null) continue;
            this.circuits[i].onTick(i, tile);
        }
    }

    @Override
    public ICircuit[] getCircuits() {
        return this.circuits;
    }
}

