/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.core.genetics.Mutation;
import forestry.plugins.PluginArboriculture;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TreeMutation
extends Mutation
implements ITreeMutation {
    private ITreeRoot root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");

    public TreeMutation(IAllele allele0, IAllele allele1, IAllele[] template, int chance) {
        super(allele0, allele1, template, chance);
        PluginArboriculture.treeInterface.registerMutation(this);
    }

    @Override
    public ITreeRoot getRoot() {
        return this.root;
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        float processedChance = this.chance;
        BiomeGenBase biome = world.func_72959_q().func_76935_a(x, z);
        if (biome.field_76750_F < this.minTemperature || biome.field_76750_F > this.maxTemperature) {
            return 0.0f;
        }
        if (biome.field_76751_G < this.minRainfall || biome.field_76751_G > this.maxRainfall) {
            return 0.0f;
        }
        processedChance *= PluginArboriculture.treeInterface.getTreekeepingMode(world).getMutationModifier((ITreeGenome)genome0, (ITreeGenome)genome1, 1.0f);
        if (this.allele0.getUID().equals(allele0.getUID()) && this.allele1.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        if (this.allele1.getUID().equals(allele0.getUID()) && this.allele0.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        return 0.0f;
    }
}

