/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodType;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockSlab
extends BlockHalfSlab
implements IWoodTyped {
    private SlabCat cat;

    public BlockSlab(int id, SlabCat cat) {
        super(id, false, Material.field_76245_d);
        this.cat = cat;
        this.func_71849_a(Tabs.tabArboriculture);
        this.func_71868_h(0);
        this.func_71848_c(2.0f);
        this.func_71894_b(5.0f);
        this.func_71884_a(field_71967_e);
        Block.field_71982_s[id] = true;
    }

    public boolean func_71926_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        WoodType.registerIcons(register);
    }

    public Icon func_71858_a(int side, int meta) {
        WoodType type = WoodType.VALUES[8 * this.cat.ordinal() + (meta & 7)];
        return type.getPlankIcon();
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return this.field_71990_ca;
    }

    public int func_71922_a(World world, int x, int y, int z) {
        return this.field_71990_ca;
    }

    public int func_71873_h(World world, int x, int y, int z) {
        return super.func_71873_h(world, x, y, z) & 7;
    }

    protected ItemStack func_71880_c_(int meta) {
        return new ItemStack(Block.field_72092_bO.field_71990_ca, 2, meta & 7);
    }

    public String func_72240_d(int var1) {
        return "SomeSlab";
    }

    public void func_71879_a(int id, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < 8; ++i) {
            itemList.add(new ItemStack(id, 1, i));
        }
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 5;
    }

    @Override
    public WoodType getWoodType(int meta) {
        if (meta + this.cat.ordinal() * 8 < WoodType.VALUES.length) {
            return WoodType.VALUES[meta + this.cat.ordinal() * 8];
        }
        return WoodType.LARCH;
    }

    @Override
    public String getBlockKind() {
        return "slab";
    }

    public static enum SlabCat {
        CAT0,
        CAT1,
        CAT2;

    }
}

