/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Vect;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class AlleleEffectGlacial
extends AlleleEffectThrottled {
    public AlleleEffectGlacial(String uid) {
        super(uid, "glacial", false, 200, true, false);
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        if (this.isHalted(storedData, housing)) {
            return storedData;
        }
        EnumTemperature temp = EnumTemperature.getFromValue(BiomeGenBase.field_76773_a[housing.getBiomeId()].field_76750_F);
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = new Vect(world.field_73012_v.nextInt(area.x), world.field_73012_v.nextInt(area.y), world.field_73012_v.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord()));
            posBlock = posBlock.add(offset);
            int blockid = world.func_72798_a(posBlock.x, posBlock.y, posBlock.z);
            if (blockid != Block.field_71943_B.field_71990_ca || !world.func_72799_c(posBlock.x, posBlock.y + 1, posBlock.z)) continue;
            Proxies.common.setBlockWithNotify(world, posBlock.x, posBlock.y, posBlock.z, Block.field_72036_aT.field_71990_ca);
        }
        return storedData;
    }
}

