/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ByteUtils {
    public static short set(short val, int slot, boolean bool) {
        if (ByteUtils.get(val, slot) != bool) {
            val = (short)(val + (bool ? 1 << slot : -(1 << slot)));
        }
        return val;
    }

    public static short set(short val, Enum<?> slot, boolean bool) {
        return ByteUtils.set(val, slot.ordinal(), bool);
    }

    public static boolean get(short val, int slot) {
        return (val & 1 << slot) != 0;
    }

    public static boolean get(short val, Enum<?> slot) {
        return ByteUtils.get(val, slot.ordinal());
    }

    public static void writeVLI(DataOutput output, int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"Value cannot be negative");
        try {
            int b;
            while (true) {
                b = value & 0x7F;
                int next = value >> 7;
                if (next <= 0) break;
                output.writeByte(b |= 0x80);
                value = next;
            }
            output.writeByte(b);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static int readVLI(DataInput input) {
        int result = 0;
        int shift = 0;
        try {
            byte b;
            do {
                b = input.readByte();
                result |= (b & 0x7F) << shift;
                shift += 7;
            } while (b < 0);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return result;
    }

    public static int nextPowerOf2(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public static boolean isPowerOfTwo(int size) {
        return (size & size - 1) == 0;
    }
}

