/*
 * Decompiled with CFR 0.152.
 */
package openmods.tileentity;

import java.io.IOException;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.common.ForgeDirection;
import openmods.Log;
import openmods.sync.ISyncHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncMapTile;
import openmods.sync.SyncableDirection;
import openmods.tileentity.OpenTileEntity;

public abstract class SyncedTileEntity
extends OpenTileEntity
implements ISyncHandler {
    protected SyncMapTile<SyncedTileEntity> syncMap = new SyncMapTile<SyncedTileEntity>(this);

    public SyncedTileEntity() {
        this.createSyncedFields();
        this.syncMap.autoregister();
    }

    protected abstract void createSyncedFields();

    public void addSyncedObject(String name, ISyncableObject obj) {
        this.syncMap.put(name, obj);
    }

    public void sync() {
        Set<ISyncableObject> changed = this.syncMap.sync();
        if (!changed.isEmpty()) {
            this.onServerSync(changed);
        }
    }

    public void onServerSync(Set<ISyncableObject> changed) {
    }

    public SyncMap<SyncedTileEntity> getSyncMap() {
        return this.syncMap;
    }

    public Packet func_70319_e() {
        try {
            return this.syncMap.createPacket(true, false);
        }
        catch (IOException e) {
            Log.severe(e, "Error during description packet creation", new Object[0]);
            return null;
        }
    }

    public ForgeDirection getSecondaryRotation() {
        ISyncableObject rot = this.syncMap.get("_rotation2");
        if (rot != null) {
            return ((SyncableDirection)rot).getValue();
        }
        return null;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.syncMap.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.syncMap.readFromNBT(tag);
    }
}

