/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import net.minecraft.world.World;
import openmods.OpenMods;
import openmods.sync.ISyncableObject;

public abstract class SyncableObjectBase
implements ISyncableObject {
    protected long lastChangeTime = 0L;
    protected boolean dirty = false;

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void resetChangeTimer(World world) {
        this.lastChangeTime = OpenMods.proxy.getTicks(world);
    }

    @Override
    public int getTicksSinceChange(World world) {
        return (int)(OpenMods.proxy.getTicks(world) - this.lastChangeTime);
    }
}

