/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.SyncableObjectBase;

public class SyncableFloat
extends SyncableObjectBase {
    public static final float EPSILON = 1.0E-4f;
    private float value;

    public SyncableFloat(float value) {
        this.value = value;
    }

    public SyncableFloat() {
    }

    public void setValue(float newValue) {
        if (!this.equals(newValue)) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public float getValue() {
        return this.value;
    }

    public boolean equals(float otherValue) {
        return Math.abs(otherValue - this.value) < 1.0E-4f;
    }

    @Override
    public void readFromStream(DataInput stream) throws IOException {
        this.value = stream.readFloat();
    }

    @Override
    public void writeToStream(DataOutput stream, boolean fullData) throws IOException {
        stream.writeFloat(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74776_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74760_g(name);
    }

    public void modify(float by) {
        this.setValue(this.value + by);
    }
}

