/*
 * Decompiled with CFR 0.152.
 */
package openmods.network;

import cpw.mods.fml.common.network.Player;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.event.Event;
import openmods.Log;
import openmods.OpenMods;
import openmods.network.EventPacketManager;
import openmods.network.IEventPacketType;
import openmods.network.PacketDirection;
import openmods.network.events.TileEntityMessageEventPacket;

public abstract class EventPacket
extends Event {
    public INetworkManager manager;
    public Player player;

    public static void registerCorePackets() {
        for (CoreEventTypes type : CoreEventTypes.values()) {
            EventPacketManager.registerType(type);
        }
    }

    public abstract IEventPacketType getType();

    protected abstract void readFromStream(DataInput var1) throws IOException;

    protected abstract void writeToStream(DataOutput var1) throws IOException;

    protected void appendLogInfo(List<String> info) {
    }

    public void reply(EventPacket reply) {
        boolean isRemote;
        boolean bl = isRemote = !(this.player instanceof EntityPlayerMP);
        if (!this.getType().getDirection().validateSend(isRemote)) {
            for (Packet packet : EventPacketManager.serializeEvent(reply)) {
                this.manager.func_74429_a(packet);
            }
        } else {
            Log.warn("Invalid sent direction for packet '%s'", new Object[]{this});
        }
    }

    protected boolean checkSendToClient() {
        if (!this.getType().getDirection().toClient) {
            Log.warn("Trying to sent message '%s' to client", new Object[]{this});
            return false;
        }
        return true;
    }

    protected boolean checkSendToServer() {
        if (!this.getType().getDirection().toServer) {
            Log.warn("Trying to sent message '%s' to server", new Object[]{this});
            return false;
        }
        return true;
    }

    public void sendToPlayer(Player player) {
        if (this.checkSendToClient()) {
            for (Packet packet : EventPacketManager.serializeEvent(this)) {
                OpenMods.proxy.sendPacketToPlayer(player, packet);
            }
        }
    }

    public void sendToPlayer(EntityPlayer player) {
        this.sendToPlayer((Player)player);
    }

    public void sendToPlayers(Collection<EntityPlayer> players) {
        if (this.checkSendToClient()) {
            for (Packet packet : EventPacketManager.serializeEvent(this)) {
                for (EntityPlayer player : players) {
                    OpenMods.proxy.sendPacketToPlayer((Player)player, packet);
                }
            }
        }
    }

    public void sendToServer() {
        if (this.checkSendToServer()) {
            for (Packet packet : EventPacketManager.serializeEvent(this)) {
                OpenMods.proxy.sendPacketToServer(packet);
            }
        }
    }

    public static enum CoreEventTypes implements IEventPacketType
    {
        TILE_ENTITY_NOTIFY{

            @Override
            public EventPacket createPacket() {
                return new TileEntityMessageEventPacket();
            }

            @Override
            public PacketDirection getDirection() {
                return PacketDirection.ANY;
            }
        };


        @Override
        public abstract EventPacket createPacket();

        @Override
        public abstract PacketDirection getDirection();

        @Override
        public boolean isCompressed() {
            return false;
        }

        @Override
        public boolean isChunked() {
            return false;
        }

        @Override
        public int getId() {
            return 0 + this.ordinal();
        }
    }
}

