/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.client.Minecraft;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import openmods.gui.component.BaseComponent;
import openmods.utils.render.FakeIcon;
import org.lwjgl.opengl.GL11;

public class GuiComponentSprite
extends BaseComponent {
    protected Icon icon;
    protected ResourceLocation texture;
    protected float r = 1.0f;
    protected float g = 1.0f;
    protected float b = 1.0f;
    protected boolean overlay_mode;

    public boolean isOverlay() {
        return this.overlay_mode;
    }

    public BaseComponent setOverlayMode(boolean isOverlay) {
        this.overlay_mode = isOverlay;
        return this;
    }

    public GuiComponentSprite(int x, int y, Icon icon, ResourceLocation texture) {
        super(x, y);
        this.texture = texture;
        this.icon = icon;
    }

    public GuiComponentSprite setColor(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        return this;
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.render(minecraft, offsetX, offsetY, mouseX, mouseY);
        if (!this.overlay_mode) {
            this.doRender(minecraft, offsetX, offsetY, mouseX, mouseY);
        }
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.renderOverlay(minecraft, offsetX, offsetY, mouseX, mouseY);
        if (this.overlay_mode) {
            this.doRender(minecraft, offsetX, offsetY, mouseX, mouseY);
        }
    }

    protected void doRender(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.icon == null) {
            return;
        }
        if (this.texture != null) {
            minecraft.field_71446_o.func_110577_a(this.texture);
        }
        GL11.glColor3f((float)this.r, (float)this.g, (float)this.b);
        this.func_94065_a(offsetX + this.x, offsetY + this.y, this.icon, this.icon.func_94211_a(), this.icon.func_94216_b());
    }

    @Override
    public int getWidth() {
        if (this.icon != null) {
            return this.icon.func_94211_a();
        }
        return 0;
    }

    @Override
    public int getHeight() {
        if (this.icon != null) {
            return this.icon.func_94216_b();
        }
        return 0;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public static class Sprites {
        public static Icon hammer = FakeIcon.createSheetIcon(0, 233, 23, 23);
        public static Icon plus = FakeIcon.createSheetIcon(23, 242, 13, 13);
        public static Icon result = FakeIcon.createSheetIcon(36, 241, 22, 15);
    }
}

