/*
 * Decompiled with CFR 0.152.
 */
package openmods.fakeplayer;

import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;
import openmods.LibConfig;
import openmods.Log;
import openmods.fakeplayer.OpenModsFakePlayer;

public class FakePlayerPool {
    public static final FakePlayerPool instance = new FakePlayerPool();
    private static final Map<World, WorldPool> worldPools = new WeakHashMap<World, WorldPool>();

    private FakePlayerPool() {
    }

    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load evt) {
        worldPools.put(evt.world, new WorldPool());
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload evt) {
        worldPools.remove(evt.world);
    }

    public void executeOnPlayer(World world, PlayerUser user) {
        WorldPool pool = worldPools.get(world);
        if (pool != null) {
            pool.executeOnPlayer(world, user);
        } else {
            Log.warn("Trying to execute %s on world %s, but it's not loaded", user, world);
        }
    }

    private static class WorldPool {
        private final Queue<OpenModsFakePlayer> pool = new ConcurrentLinkedQueue<OpenModsFakePlayer>();
        private final AtomicInteger playerCount = new AtomicInteger();

        private WorldPool() {
        }

        public void executeOnPlayer(World world, PlayerUser user) {
            OpenModsFakePlayer player = this.pool.poll();
            if (player == null) {
                int id = this.playerCount.incrementAndGet();
                if (id > LibConfig.fakePlayerThreshold) {
                    Log.warn("Number of fake players in use has reached %d. Something may leak them", id);
                }
                player = new OpenModsFakePlayer(world, id);
            }
            player.field_70128_L = false;
            user.usePlayer(player);
            player.func_70106_y();
            this.pool.add(player);
        }
    }

    public static interface PlayerUser {
        public void usePlayer(OpenModsFakePlayer var1);
    }
}

