/*
 * Decompiled with CFR 0.152.
 */
package openmods.config;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import openmods.Log;
import openmods.config.ConfigProcessing;
import openmods.config.ConfigPropertyMeta;
import openmods.utils.CommandUtils;
import openmods.utils.io.StringConversionException;
import org.apache.commons.lang3.ArrayUtils;

public class CommandConfig
implements ICommand {
    private static final String COMMAND_REMOVE = "remove";
    private static final String COMMAND_APPEND = "append";
    private static final String COMMAND_SET = "set";
    private static final String COMMAND_CLEAR = "clear";
    private static final String COMMAND_GET = "get";
    private static final String COMMAND_HELP = "help";
    private static final String COMMAND_SAVE = "save";
    private static final String COMMAND_DEFAULT = "default";
    private static final Set<String> SUBCOMMANDS = ImmutableSet.of((Object)"save", (Object)"help", (Object)"get", (Object)"clear", (Object)"set", (Object)"append", (Object[])new String[]{"remove", "default"});
    private final String name;
    private final boolean restricted;

    public CommandConfig(String name, boolean restricted) {
        this.name = name;
        this.restricted = restricted;
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((ICommand)o).func_71517_b());
    }

    public String func_71517_b() {
        return this.name;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return this.name + " save <modid> OR\n" + this.name + " help <modid> <category> <name> OR\n" + this.name + " get <modid> <category> <name> OR\n" + this.name + " clear <modid> <category> <name> OR\n" + this.name + " set <modid> <category> <name> <value>... OR\n" + this.name + " append <modid> <category> <name> <value>... OR\n" + this.name + " remove <modid> <category> <name> <value>... OR\n" + this.name + " default <modid> <category> <name> <value>... OR\n";
    }

    public List func_71514_a() {
        return null;
    }

    private static void printValue(ICommandSender sender, ConfigProcessing.ModConfig config, ConfigPropertyMeta property) {
        CommandUtils.respond(sender, "%s.%s.%s = %s (%s)", config.modId, property.category, property.name, property.valueDescription(), property.type.toString());
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            throw CommandUtils.error("openmodslib.command.no_enough_args", new Object[0]);
        }
        String command = args[0];
        if (!SUBCOMMANDS.contains(command)) {
            throw CommandUtils.error("openmodslib.command.invalid_command", command);
        }
        String modId = args[1];
        ConfigProcessing.ModConfig config = ConfigProcessing.getConfig(modId);
        if (config == null) {
            throw CommandUtils.error("openmodslib.command.unknown_modid", new Object[0]);
        }
        if (COMMAND_SAVE.equals(command)) {
            config.save();
            CommandUtils.respond(sender, "openmodslib.command.saved", config.configFile.getAbsolutePath());
            return;
        }
        if (args.length < 4) {
            throw CommandUtils.error("openmodslib.command.no_enough_args", new Object[0]);
        }
        String category = args[2];
        String name = args[3];
        ConfigPropertyMeta property = config.getValue(category, name);
        if (property == null) {
            throw CommandUtils.error("openmodslib.command.unknown_value", new Object[0]);
        }
        if (COMMAND_HELP.equals(command)) {
            CommandUtils.respond(sender, "%s.%s.%s: %s (%s)", config.modId, property.category, property.name, property.comment, property.type.toString());
            return;
        }
        if (COMMAND_GET.equals(command)) {
            CommandConfig.printValue(sender, config, property);
            return;
        }
        if (COMMAND_CLEAR.equals(command)) {
            if (!property.acceptsMultipleValues()) {
                throw CommandUtils.error("openmodslib.command.not_multiple", new Object[0]);
            }
            this.changeValue(config, sender, property, new String[0]);
            return;
        }
        if (COMMAND_DEFAULT.equals(command)) {
            this.changeValue(config, sender, property, property.getDefaultValues());
            return;
        }
        if (args.length < 5) {
            throw CommandUtils.error("openmodslib.command.no_enough_args", new Object[0]);
        }
        Object[] values = Arrays.copyOfRange(args, 4, args.length);
        if (COMMAND_SET.equals(command)) {
            this.changeValue(config, sender, property, (String[])values);
            return;
        }
        if (!property.acceptsMultipleValues()) {
            throw CommandUtils.error("openmodslib.command.not_multiple", new Object[0]);
        }
        Object[] current = property.getPropertyValue();
        if (COMMAND_APPEND.equals(command)) {
            this.changeValue(config, sender, property, (String[])ArrayUtils.addAll((Object[])current, (Object[])values));
            return;
        }
        if (COMMAND_REMOVE.equals(command)) {
            this.changeValue(config, sender, property, (String[])ArrayUtils.removeElements((Object[])current, (Object[])values));
            return;
        }
        throw CommandUtils.error("openmodslib.command.no_enough_args", new Object[0]);
    }

    protected void changeValue(ConfigProcessing.ModConfig config, ICommandSender sender, ConfigPropertyMeta property, String ... values) {
        try {
            ConfigPropertyMeta.Result changeResult = property.tryChangeValue(values);
            switch (changeResult) {
                case ONLINE: {
                    CommandUtils.respond(sender, "openmodslib.command.online_change");
                    break;
                }
                case OFFLINE: {
                    CommandUtils.respond(sender, "openmodslib.command.offline_change");
                    break;
                }
                default: {
                    CommandUtils.respond(sender, "openmodslib.command.cancelled");
                }
            }
            CommandConfig.printValue(sender, config, property);
        }
        catch (StringConversionException e) {
            throw CommandUtils.error("openmodslib.command.invalid_type", Arrays.toString(values), property.type);
        }
        catch (Exception e) {
            Log.warn(e, "Error during command change", new Object[0]);
            throw CommandUtils.error("openmodslib.command.unknown_error", e.getMessage());
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        int level = this.restricted ? 4 : 0;
        return sender.func_70003_b(level, this.name);
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        String command = args[0];
        if (args.length == 1) {
            return CommandUtils.filterPrefixes(command, SUBCOMMANDS);
        }
        String modId = args[1];
        if (args.length == 2) {
            return CommandUtils.filterPrefixes(modId, ConfigProcessing.getConfigsIds());
        }
        if (COMMAND_SAVE.equals(command)) {
            return null;
        }
        ConfigProcessing.ModConfig config = ConfigProcessing.getConfig(modId);
        if (config == null) {
            return null;
        }
        String category = args[2];
        if (args.length == 3) {
            return CommandUtils.filterPrefixes(category, config.getCategories());
        }
        String name = args[3];
        if (args.length == 4) {
            return CommandUtils.filterPrefixes(name, config.getValues(category));
        }
        return null;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }
}

