/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.network;

import com.google.common.base.Throwables;
import com.google.common.collect.MapMaker;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLNetworkException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import net.minecraftforge.common.network.packet.DimensionRegisterPacket;
import net.minecraftforge.fluids.FluidIdMapPacket;

public abstract class ForgePacket {
    public static final String CHANNEL_ID = "FORGE";
    private Type type;
    private byte[][] partials;

    public static ea[] makePacketSet(ForgePacket packet) {
        byte[] packetData = packet.generatePacket();
        if (packetData.length < 32000) {
            return new ea[]{new ea(CHANNEL_ID, Bytes.concat({UnsignedBytes.checkedCast(0L), UnsignedBytes.checkedCast(packet.getID())}, packetData))};
        }
        byte[][] chunks = new byte[packetData.length / 32000 + 1][];
        for (int i2 = 0; i2 < packetData.length / 32000 + 1; ++i2) {
            int len = Math.min(32000, packetData.length - i2 * 32000);
            chunks[i2] = Bytes.concat({UnsignedBytes.checkedCast(1L), UnsignedBytes.checkedCast(packet.getID()), UnsignedBytes.checkedCast(i2), UnsignedBytes.checkedCast(chunks.length)}, Ints.toByteArray(len), Arrays.copyOfRange(packetData, i2 * 32000, len + i2 * 32000));
        }
        ea[] ret = new ea[chunks.length];
        for (int i3 = 0; i3 < chunks.length; ++i3) {
            ret[i3] = new ea(CHANNEL_ID, chunks[i3]);
        }
        return ret;
    }

    public static ForgePacket readPacket(cm network, byte[] payload) {
        boolean multipart = UnsignedBytes.toInt(payload[0]) == 1;
        int type = UnsignedBytes.toInt(payload[1]);
        Type eType = Type.values()[type];
        byte[] data = Arrays.copyOfRange(payload, 2, payload.length);
        if (multipart) {
            ForgePacket pkt = eType.consumePart(network, data);
            if (pkt != null) {
                return pkt.consumePacket(Bytes.concat(pkt.partials));
            }
            return null;
        }
        return eType.make().consumePacket(data);
    }

    public ForgePacket() {
        for (Type t2 : Type.values()) {
            if (t2.packetType != this.getClass()) continue;
            this.type = t2;
        }
        if (this.type == null) {
            throw new RuntimeException("ForgePacket constructor called on ungregistered type.");
        }
    }

    public byte getID() {
        return UnsignedBytes.checkedCast(this.type.ordinal());
    }

    public abstract byte[] generatePacket();

    public abstract ForgePacket consumePacket(byte[] var1);

    public abstract void execute(cm var1, uf var2);

    static /* synthetic */ byte[][] access$002(ForgePacket x0, byte[][] x1) {
        x0.partials = x1;
        return x1;
    }

    static enum Type {
        REGISTERDIMENSION(DimensionRegisterPacket.class),
        FLUID_IDMAP(FluidIdMapPacket.class);

        private Class<? extends ForgePacket> packetType;
        private ConcurrentMap<cm, ForgePacket> partTracker;

        private Type(Class<? extends ForgePacket> clazz) {
            this.packetType = clazz;
        }

        ForgePacket make() {
            try {
                return this.packetType.newInstance();
            }
            catch (Exception e2) {
                Throwables.propagateIfPossible(e2);
                FMLLog.log(Level.SEVERE, e2, "A bizarre critical error occured during packet encoding", new Object[0]);
                throw new FMLNetworkException(e2);
            }
        }

        private ForgePacket consumePart(cm network, byte[] data) {
            if (this.partTracker == null) {
                this.partTracker = new MapMaker().weakKeys().weakValues().makeMap();
            }
            if (!this.partTracker.containsKey(network)) {
                this.partTracker.put(network, this.make());
            }
            ForgePacket pkt = (ForgePacket)this.partTracker.get(network);
            ByteArrayDataInput bdi2 = ByteStreams.newDataInput(data);
            int chunkIdx = UnsignedBytes.toInt(bdi2.readByte());
            int chunkTotal = UnsignedBytes.toInt(bdi2.readByte());
            int chunkLength = bdi2.readInt();
            if (pkt.partials == null) {
                ForgePacket.access$002(pkt, new byte[chunkTotal][]);
            }
            ((ForgePacket)pkt).partials[chunkIdx] = new byte[chunkLength];
            bdi2.readFully(pkt.partials[chunkIdx]);
            for (int i2 = 0; i2 < pkt.partials.length; ++i2) {
                if (pkt.partials[i2] != null) continue;
                return null;
            }
            return pkt;
        }
    }
}

