/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.Queues;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.SingleIntervalHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicLong;

public class TickRegistry {
    private static PriorityQueue<TickQueueElement> clientTickHandlers = Queues.newPriorityQueue();
    private static PriorityQueue<TickQueueElement> serverTickHandlers = Queues.newPriorityQueue();
    private static AtomicLong clientTickCounter = new AtomicLong();
    private static AtomicLong serverTickCounter = new AtomicLong();

    public static void registerScheduledTickHandler(IScheduledTickHandler handler, Side side) {
        TickRegistry.getQueue(side).add(new TickQueueElement(handler, TickRegistry.getCounter(side).get()));
    }

    private static PriorityQueue<TickQueueElement> getQueue(Side side) {
        return side.isClient() ? clientTickHandlers : serverTickHandlers;
    }

    private static AtomicLong getCounter(Side side) {
        return side.isClient() ? clientTickCounter : serverTickCounter;
    }

    public static void registerTickHandler(ITickHandler handler, Side side) {
        TickRegistry.registerScheduledTickHandler(new SingleIntervalHandler(handler), side);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTickQueue(List<IScheduledTickHandler> ticks, Side side) {
        List<IScheduledTickHandler> list = ticks;
        synchronized (list) {
            ticks.clear();
            long tick = TickRegistry.getCounter(side).incrementAndGet();
            PriorityQueue<TickQueueElement> tickHandlers = TickRegistry.getQueue(side);
            while (tickHandlers.size() != 0 && tickHandlers.peek().scheduledNow(tick)) {
                TickQueueElement tickQueueElement = tickHandlers.poll();
                tickQueueElement.update(tick);
                tickHandlers.offer(tickQueueElement);
                ticks.add(tickQueueElement.ticker);
            }
        }
    }

    public static class TickQueueElement
    implements Comparable<TickQueueElement> {
        private long next;
        public IScheduledTickHandler ticker;

        public TickQueueElement(IScheduledTickHandler ticker, long tickCounter) {
            this.ticker = ticker;
            this.update(tickCounter);
        }

        @Override
        public int compareTo(TickQueueElement o2) {
            return (int)(this.next - o2.next);
        }

        public void update(long tickCounter) {
            this.next = tickCounter + (long)Math.max(this.ticker.nextTickSpacing(), 1);
        }

        public boolean scheduledNow(long tickCounter) {
            return tickCounter >= this.next;
        }
    }
}

